/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.cyclos.impl.sql.CachingPreparedStatement;
import org.cyclos.impl.sql.CachingResultSetMetaData;
import org.cyclos.impl.sql.TableCacheValue;
import org.cyclos.utils.coercion.CoercionHelper;

public class CachingResultSet
implements ResultSet {
    private final CachingPreparedStatement statement;
    private final TableCacheValue cacheValue;
    private final CachingResultSetMetaData metaData;
    private int pos;
    private Object[] row;
    private boolean wasNull;

    public CachingResultSet(CachingPreparedStatement cachingPreparedStatement, TableCacheValue tableCacheValue) {
        this.statement = cachingPreparedStatement;
        this.cacheValue = tableCacheValue;
        this.metaData = tableCacheValue.getMetaData();
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.pos = n - 1;
        return this.posOk();
    }

    @Override
    public void afterLast() throws SQLException {
        this.pos = this.cacheValue.getRows().size();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.pos = 0;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        this.pos = 0;
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.metaData.findColumn(string);
    }

    @Override
    public boolean first() throws SQLException {
        if (this.cacheValue.getRows().size() == 0) {
            return false;
        }
        this.pos = 1;
        return true;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        return (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)this.getObject(n));
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)this.getObject(n));
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)this.getObject(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)this.getColumnLabelValue(string));
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        return (Boolean)CoercionHelper.coerce(Boolean.TYPE, (Object)this.getObject(n));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return (Boolean)CoercionHelper.coerce(Boolean.TYPE, (Object)this.getColumnLabelValue(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        return (Byte)CoercionHelper.coerce(Byte.TYPE, (Object)this.getObject(n));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return (Byte)CoercionHelper.coerce(Byte.TYPE, (Object)this.getColumnLabelValue(string));
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int n) throws SQLException {
        java.util.Date date = (java.util.Date)this.getObject(n);
        return date == null ? null : new Date(date.getTime());
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Date getDate(String string) throws SQLException {
        java.util.Date date = (java.util.Date)this.getColumnLabelValue(string);
        return date == null ? null : new Date(date.getTime());
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public double getDouble(int n) throws SQLException {
        return (Double)CoercionHelper.coerce(Double.TYPE, (Object)this.getObject(n));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return (Double)CoercionHelper.coerce(Double.TYPE, (Object)this.getColumnLabelValue(string));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        return ((Float)CoercionHelper.coerce(Float.TYPE, (Object)this.getObject(n))).floatValue();
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return ((Float)CoercionHelper.coerce(Float.TYPE, (Object)this.getColumnLabelValue(string))).floatValue();
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getInt(int n) throws SQLException {
        return (Integer)CoercionHelper.coerce(Integer.TYPE, (Object)this.getObject(n));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return (Integer)CoercionHelper.coerce(Integer.TYPE, (Object)this.getColumnLabelValue(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        return (Long)CoercionHelper.coerce(Long.TYPE, (Object)this.getObject(n));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return (Long)CoercionHelper.coerce(Long.TYPE, (Object)this.getColumnLabelValue(string));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Object getObject(int n) throws SQLException {
        Object object = this.row[n - 1];
        this.wasNull = object == null;
        return object;
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        return (T)CoercionHelper.coerce(clazz, (Object)this.getObject(n));
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getColumnLabelValue(string);
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return (T)CoercionHelper.coerce(clazz, (Object)this.getObject(string));
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public int getRow() throws SQLException {
        return this.pos + 1;
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public short getShort(int n) throws SQLException {
        return (Short)CoercionHelper.coerce(Short.TYPE, (Object)this.getObject(n));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return (Short)CoercionHelper.coerce(Short.TYPE, (Object)this.getColumnLabelValue(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public String getString(int n) throws SQLException {
        return (String)CoercionHelper.coerce(String.class, (Object)this.getObject(n));
    }

    @Override
    public String getString(String string) throws SQLException {
        return (String)CoercionHelper.coerce(String.class, (Object)this.getColumnLabelValue(string));
    }

    @Override
    public Time getTime(int n) throws SQLException {
        java.util.Date date = (java.util.Date)this.getObject(n);
        return date == null ? null : new Time(date.getTime());
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Time getTime(String string) throws SQLException {
        java.util.Date date = (java.util.Date)this.getColumnLabelValue(string);
        return date == null ? null : new Time(date.getTime());
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        java.util.Date date = (java.util.Date)this.getObject(n);
        return date == null ? null : new Timestamp(date.getTime());
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        java.util.Date date = (java.util.Date)this.getColumnLabelValue(string);
        return date == null ? null : new Timestamp(date.getTime());
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.pos >= this.cacheValue.getRows().size();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.pos <= 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.cacheValue.getRows().size() > 0 && this.pos == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.pos == this.cacheValue.getRows().size() - 1;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        List<Object[]> list = this.cacheValue.getRows();
        if (list.size() == 0) {
            return false;
        }
        this.pos = list.size() - 1;
        return true;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public boolean next() throws SQLException {
        try {
            this.row = this.cacheValue.getRows().get(this.pos++);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        --this.pos;
        return this.posOk();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public boolean relative(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    private Object getColumnLabelValue(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n);
    }

    private boolean posOk() {
        return this.pos >= 0 && this.pos < this.cacheValue.getRows().size();
    }
}

