/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclos.utils.CollectionHelper;

public class ConfigurationAccessorCacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Long networkId;
    private final Long[] configurationPathIds;
    private final String methodName;

    public ConfigurationAccessorCacheKey(Long l, List<Long> list, String string) {
        this.networkId = l;
        this.configurationPathIds = (Long[])list.toArray(Long[]::new);
        this.methodName = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConfigurationAccessorCacheKey configurationAccessorCacheKey = (ConfigurationAccessorCacheKey)object;
        return Arrays.equals((Object[])this.configurationPathIds, (Object[])configurationAccessorCacheKey.configurationPathIds) && Objects.equals(this.methodName, configurationAccessorCacheKey.methodName) && Objects.equals(this.networkId, configurationAccessorCacheKey.networkId);
    }

    public Long getConfigurationId() {
        return (Long)CollectionHelper.first((Object[])this.configurationPathIds);
    }

    public Long[] getConfigurationPathIds() {
        return this.configurationPathIds;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Long getNetworkId() {
        return this.networkId;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode((Object[])this.configurationPathIds);
        n = 31 * n + Objects.hash(this.methodName, this.networkId);
        return n;
    }

    public boolean matchesConfiguration(Long l) {
        return ArrayUtils.contains((Object[])this.configurationPathIds, (Object)l);
    }

    public boolean matchesConfigurationAndMethod(Long l, String string) {
        return this.matchesConfiguration(l) && Objects.equals(this.methodName, string);
    }

    public boolean matchesNetwork(Long l) {
        return l == null ? true : l.equals(l);
    }

    public boolean matchesNetworkAndMethod(Long l, Collection<String> collection) {
        return this.matchesNetwork(l) && CollectionHelper.isNotEmpty(collection) && collection.contains(this.methodName);
    }

    public boolean matchesNetworkAndMethod(Long l, String string) {
        return this.matchesNetwork(l) && this.methodName.equals(string);
    }

    public String toString() {
        return this.getConfigurationId() + "." + this.methodName + "@" + String.valueOf(this.networkId == null ? "global" : this.networkId);
    }
}

