/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.contentmanagement.DocumentCustomField;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldPossibleValue;
import org.cyclos.entities.system.CustomFieldPossibleValueCategory;
import org.cyclos.entities.system.CustomFieldValue;
import org.cyclos.entities.system.CustomOperationField;
import org.cyclos.entities.system.CustomWizardField;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.QCustomFieldValue;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactCustomField;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldNature;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.users.fields.UserCustomFieldValueDTO;

public interface CustomFieldValueHandler {
    public static final String ATTR_OBJECT = "object";
    public static final String ATTR_FIELD = "field";
    public static final String ATTR_VALUE = "value";
    public static final List<Property<?, ?>> VALUE_PROPERTIES = Collections.unmodifiableList(Arrays.asList(CustomFieldValueDTO.BOOLEAN_VALUE, CustomFieldValueDTO.DATE_VALUE, CustomFieldValueDTO.INTEGER_VALUE, CustomFieldValueDTO.DECIMAL_VALUE, CustomFieldValueDTO.STRING_VALUE, CustomFieldValueDTO.TEXT_VALUE, CustomFieldValueDTO.RICH_TEXT_VALUE, CustomFieldValueDTO.ENUMERATED_VALUE, CustomFieldValueDTO.ENUMERATED_VALUES, CustomFieldValueDTO.LINKED_ENTITY_VALUE, CustomFieldValueDTO.DYNAMIC_VALUES, CustomFieldValueDTO.FILE_VALUES, CustomFieldValueDTO.IMAGE_VALUES));
    public static final List<Property<?, ?>> SEARCH_PROPERTIES = Collections.unmodifiableList(Arrays.asList(CustomFieldValueForSearchDTO.BOOLEAN_VALUE, CustomFieldValueForSearchDTO.DATE_PERIOD, CustomFieldValueForSearchDTO.DECIMAL_RANGE, CustomFieldValueForSearchDTO.INTEGER_RANGE, CustomFieldValueForSearchDTO.STRING_VALUE, CustomFieldValueForSearchDTO.DYNAMIC_VALUES, CustomFieldValueForSearchDTO.ENUMERATED_VALUES, CustomFieldValueForSearchDTO.LINKED_ENTITY_VALUES));

    public static Class<? extends CustomField<?, ?, ?>> getCustomFieldClass(CustomFieldNature customFieldNature) {
        switch (customFieldNature) {
            case AD: {
                return AdCustomField.class;
            }
            case CONTACT: {
                return ContactCustomField.class;
            }
            case CUSTOM_OPERATION: {
                return CustomOperationField.class;
            }
            case CUSTOM_WIZARD: {
                return CustomWizardField.class;
            }
            case DOCUMENT: {
                return DocumentCustomField.class;
            }
            case RECORD: {
                return RecordCustomField.class;
            }
            case TRANSFER: {
                return TransactionCustomField.class;
            }
            case USER: {
                return UserCustomField.class;
            }
            case CONTACT_INFO: {
                return ContactInfoField.class;
            }
            case VOUCHER: {
                return VoucherCustomField.class;
            }
        }
        throw new IllegalArgumentException("Unknown custom field nature: " + String.valueOf(customFieldNature));
    }

    public static CustomFieldNature getCustomFieldNature(Class<? extends CustomField<?, ?, ?>> clazz) {
        if (clazz == AdCustomField.class) {
            return CustomFieldNature.AD;
        }
        if (clazz == ContactCustomField.class) {
            return CustomFieldNature.CONTACT;
        }
        if (clazz == CustomOperationField.class) {
            return CustomFieldNature.CUSTOM_OPERATION;
        }
        if (clazz == DocumentCustomField.class) {
            return CustomFieldNature.DOCUMENT;
        }
        if (clazz == RecordCustomField.class) {
            return CustomFieldNature.RECORD;
        }
        if (clazz == TransactionCustomField.class) {
            return CustomFieldNature.TRANSFER;
        }
        if (clazz == UserCustomField.class) {
            return CustomFieldNature.USER;
        }
        if (clazz == ContactInfoField.class) {
            return CustomFieldNature.CONTACT_INFO;
        }
        if (clazz == VoucherCustomField.class) {
            return CustomFieldNature.VOUCHER;
        }
        throw new IllegalArgumentException("Unknown custom field class: " + String.valueOf(clazz));
    }

    public void addLengthValidation(org.cyclos.impl.utils.validation.Property var1, IntegerRange var2);

    public void addPatternValidation(org.cyclos.impl.utils.validation.Property var1, String var2);

    public org.cyclos.impl.utils.validation.Property addValueValidation(Validator var1, CustomField<?, ?, ?> var2, EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> var3, Map<String, ?> var4);

    public org.cyclos.impl.utils.validation.Property addValueValidation(Validator var1, CustomField<?, ?, ?> var2, EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> var3, Map<String, ?> var4, LoadValuesScriptFunction var5, String var6);

    public org.cyclos.impl.utils.validation.Property addValueValidation(Validator var1, CustomField<?, ?, ?> var2, EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> var3, Map<String, ?> var4, String var5);

    public org.cyclos.impl.utils.validation.Property addValueValidationAsProperty(Validator var1, CustomField<?, ?, ?> var2, EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> var3, Map<String, ?> var4, Property<?, ?> var5);

    public org.cyclos.impl.utils.validation.Property addValueValidationAsPropertyIgnoringRequired(Validator var1, CustomField<?, ?, ?> var2, EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> var3, Map<String, ?> var4, Property<?, ?> var5);

    public org.cyclos.impl.utils.validation.Property addValueValidationIgnoringRequired(Validator var1, CustomField<?, ?, ?> var2, EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> var3, Map<String, ?> var4);

    public void addWordSizeValidation(org.cyclos.impl.utils.validation.Property var1, CustomField<?, ?, ?> var2);

    public <CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, V extends CustomFieldValue<CF, C, PV, O>, O extends SimpleEntity> V buildFieldValue(CF var1, Class<V> var2, QCustomFieldValue var3, Tuple var4);

    public <CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, V extends CustomFieldValue<CF, C, PV, E>, E extends SimpleEntity> List<V> cloneCustomValuesData(E var1, Collection<V> var2);

    public <CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, V extends CustomFieldValue<CF, C, PV, E>, E extends SimpleEntity> void cloneCustomValuesData(ModelWithCustomValues<CustomFieldValueDTO> var1, Collection<V> var2);

    public void fillValuesFromScript(Class<? extends CustomField<?, ?, ?>> var1, LoadValuesScriptFunction var2, Map<String, ?> var3, Collection<? extends CustomFieldDetailedVO> var4);

    public void fillValuesFromScript(Class<? extends CustomField<?, ?, ?>> var1, LoadValuesScriptFunction var2, Map<String, ?> var3, Collection<? extends CustomFieldDetailedVO> var4, boolean var5);

    public String format(FormatterImpl var1, CustomField<?, ?, ?> var2, Object var3);

    public CustomField<?, ?, ?> getCustomField(CustomFieldVO var1);

    public Object getDefaultValue(CustomField<?, ?, ?> var1);

    public Set<Path<?>> getProjectionPaths(CustomField<?, ?, ?> var1, QCustomFieldValue var2);

    public Object getValue(CustomField<?, ?, ?> var1, Object var2, boolean var3);

    public Object getValue(CustomField<?, ?, ?> var1, Object var2, boolean var3, FormatterImpl var4);

    public Object getValueForSearch(CustomField<?, ?, ?> var1, Object var2, boolean var3);

    public Class<?> getValueType(CustomField<?, ?, ?> var1);

    public void processAfterSave(EntityWithCustomValues<?, ?, ?, ?> var1);

    public Predicate queryFilter(EntityPath<? extends CustomFieldValue<?, ?, ?, ?>> var1, CustomField<?, ?, ?> var2, CustomFieldValueForSearchDTO var3);

    public void remove(CustomFieldValue<?, ?, ?, ?> var1);

    public void removeAll(EntityWithCustomValues<?, ?, ?, ?> var1);

    public Set<CustomFieldValueForSearchDTO> resolveDefaultSearchValues(Collection<CustomFieldDetailedVO> var1);

    public Object resolveReference(CustomField<?, ?, ?> var1, String var2, boolean var3, boolean var4, FormatterImpl var5, String var6);

    public <DTO extends CustomFieldValueDTO> List<DTO> resolveValues(Class<? extends CustomField<?, ?, ?>> var1, Collection<DTO> var2);

    public void setCustomValues(BasicUser var1, Collection<UserCustomField> var2, Collection<UserCustomField> var3, Collection<UserCustomField> var4, Collection<UserCustomFieldValueDTO> var5);

    public <CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, V extends CustomFieldValue<CF, C, PV, E>, E extends SimpleEntity> void setCustomValues(E var1, Collection<CF> var2, Collection<CF> var3, Collection<CustomFieldValueDTO> var4);

    public void setDefaultValue(CustomFieldDetailedVO var1, Object var2);

    default public void setDefaultValues(List<? extends CustomFieldDetailedVO> list, ModelWithCustomValues<CustomFieldValueDTO> modelWithCustomValues) {
        this.setDefaultValues(list, modelWithCustomValues, customFieldDetailedVO -> new CustomFieldValueDTO((Property)CustomFieldValueDTO.FIELD, customFieldDetailedVO));
    }

    public <DTO extends CustomFieldValueDTO> void setDefaultValues(List<? extends CustomFieldDetailedVO> var1, ModelWithCustomValues<DTO> var2, Function<CustomFieldDetailedVO, DTO> var3);

    public <CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, V extends CustomFieldValue<CF, C, PV, O>, O extends SimpleEntity> void setDefaultValues(O var1, Collection<CF> var2);

    public void setModelValue(CustomField<?, ?, ?> var1, Object var2, ICustomFieldValue<?, ?, ?, ?> var3);

    public void sortAndRemoveMissing(List<? extends CustomFieldValueDTO> var1, List<? extends IEntity> var2);

    public void sortAndRemoveMissingFromVO(List<? extends CustomFieldValueVO> var1, List<? extends IEntity> var2);

    public List<? extends CustomFieldPossibleValue<?, ?, ?>> toCustomFieldPossibleValues(CustomField<?, ?, ?> var1, Collection<?> var2);

    public List<SimpleEntity> toLinkedEntityValues(CustomField<?, ?, ?> var1, Collection<?> var2);

    public String toReference(CustomField<?, ?, ?> var1, Object var2);

    public <CF extends CustomField<CF, ?, ?>> SortedMap<CF, Object> toSearchFiltersMap(Collection<CF> var1, Collection<? extends CustomFieldValueForSearchDTO> var2, boolean var3);

    public <CF extends CustomField<CF, ?, ?>> SortedMap<CF, Object> toValuesMap(Collection<CF> var1, Collection<? extends ICustomFieldValue<?, ?, ?, ?>> var2, boolean var3);
}

