/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.cyclos.entities.contentmanagement.MenuItem;
import org.cyclos.entities.system.CustomWizardExecution;
import org.cyclos.entities.system.CustomWizardStep;
import org.cyclos.entities.system.EntityWithParameterStorageContext;
import org.cyclos.entities.users.InviteToken;
import org.cyclos.entities.utils.EntityBackedParameterStorage;
import org.cyclos.impl.system.CustomWizardStepWithTransitions;
import org.cyclos.impl.users.IdentityProviderProfile;
import org.cyclos.impl.utils.CustomValuesMap;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.model.users.users.PublicRegistrationDTO;
import org.cyclos.model.utils.NotificationLevel;

public class CustomWizardExecutionStorage
extends EntityBackedParameterStorage {
    private static final String CAPTCHA_VALIDATED = "captchaValidated";
    private static final String VERIFIED_EMAIL = "verifiedEmail";
    private static final String EMAIL_TO_VERIFY = "emailToVerify";
    private static final String VERIFIED_SMS = "verifiedSms";
    private static final String SMS_TO_VERIFY = "smsToVerify";
    private static final String IDENTITY_PROVIDER_ID = "identityProviderId";
    private static final String IDENTITY_PROVIDER_PROFILE = "identityProviderProfile";
    private static final String INVITE_TOKEN = "inviteToken";
    private static final String USER_AGENT_ID = "userAgentId";
    private static final String EXTERNAL_PAYMENT_TOKEN = "externalPaymentToken";
    private static final String NOTIFICATION_LEVEL = "notificationLevel";
    private static final String NOTIFICATION_MESSAGE = "notificationMessage";
    private static final String MENU_ITEM = "menuItem";
    private final ConversionHandler conversionHandler;
    private CustomWizardExecution execution;

    public CustomWizardExecutionStorage(ObjectMapper objectMapper, CustomWizardExecution customWizardExecution, ConversionHandler conversionHandler) {
        super(objectMapper, (EntityWithParameterStorageContext)customWizardExecution);
        this.execution = customWizardExecution;
        this.conversionHandler = conversionHandler;
    }

    public void clearNotification() {
        this.remove(NOTIFICATION_LEVEL);
        this.remove(NOTIFICATION_MESSAGE);
    }

    public void error(String string) {
        this.notify(NotificationLevel.ERROR, string);
    }

    public Map<String, Object> getCustomValues() {
        Map map = (Map)this.getObject("customValues");
        if (!(map instanceof CustomValuesMap)) {
            map = this.ensureCustomValues(map);
            this.setObject("customValues", map);
        }
        return map;
    }

    public String getEmailToVerify() {
        return this.getString(EMAIL_TO_VERIFY);
    }

    public String getExternalPaymentToken() {
        return this.getString(EXTERNAL_PAYMENT_TOKEN);
    }

    public Long getIdentityProviderId() {
        return this.getLong(IDENTITY_PROVIDER_ID);
    }

    public IdentityProviderProfile getIdentityProviderProfile() {
        return (IdentityProviderProfile)this.getObject(IDENTITY_PROVIDER_PROFILE);
    }

    public InviteToken getInviteToken() {
        return (InviteToken)this.getObject(INVITE_TOKEN);
    }

    public MenuItem getMenuItem() {
        return (MenuItem)this.getObject(MENU_ITEM);
    }

    public NotificationLevel getNotificationLevel() {
        return (NotificationLevel)this.getEnum(NOTIFICATION_LEVEL, NotificationLevel.class);
    }

    public String getNotificationMessage() {
        return this.getString(NOTIFICATION_MESSAGE);
    }

    public PublicRegistrationDTO getRegistration() {
        PublicRegistrationDTO publicRegistrationDTO = this.conversionHandler.convert(PublicRegistrationDTO.class, this.getObject("registration"));
        if (publicRegistrationDTO == null) {
            publicRegistrationDTO = new PublicRegistrationDTO();
            this.setRegistration(publicRegistrationDTO);
        }
        return publicRegistrationDTO;
    }

    public String getSmsToVerify() {
        return this.getString(SMS_TO_VERIFY);
    }

    public List<CustomWizardStepWithTransitions> getSteps() {
        List<CustomWizardStepWithTransitions> list = this.conversionHandler.convertList(CustomWizardStepWithTransitions.class, (Collection)this.getObject("steps"));
        if (list == null) {
            list = new ArrayList<CustomWizardStepWithTransitions>();
            this.setSteps(list);
        }
        return list;
    }

    public String getUserAgentId() {
        return (String)this.getObject(USER_AGENT_ID);
    }

    public String getVerifiedEmail() {
        return this.getString(VERIFIED_EMAIL);
    }

    public String getVerifiedSms() {
        return this.getString(VERIFIED_SMS);
    }

    public void info(String string) {
        this.notify(NotificationLevel.INFORMATION, string);
    }

    public boolean isCaptchaValidated() {
        return this.getBoolean(CAPTCHA_VALIDATED);
    }

    public boolean isStepExecuted(CustomWizardStep customWizardStep) {
        return this.getBoolean(this.executedKey(customWizardStep));
    }

    public void notify(NotificationLevel notificationLevel, String string) {
        this.setEnum(NOTIFICATION_LEVEL, new Enum[]{notificationLevel});
        this.setString(NOTIFICATION_MESSAGE, new String[]{string});
    }

    public void setCaptchaValidated(boolean bl) {
        this.setBoolean(CAPTCHA_VALIDATED, bl);
    }

    public void setCustomValues(Map<String, Object> map) {
        this.setObject("customValues", this.ensureCustomValues(map));
    }

    public void setEmailToVerify(String string) {
        this.setString(EMAIL_TO_VERIFY, new String[]{string});
    }

    public void setExternalPaymentToken(String string) {
        this.setString(EXTERNAL_PAYMENT_TOKEN, new String[]{string});
    }

    public void setIdentityProviderId(Long l) {
        this.setLong(IDENTITY_PROVIDER_ID, new Long[]{l});
    }

    public void setIdentityProviderProfile(IdentityProviderProfile identityProviderProfile) {
        this.setObject(IDENTITY_PROVIDER_PROFILE, identityProviderProfile);
    }

    public void setInviteToken(InviteToken inviteToken) {
        this.setObject(INVITE_TOKEN, inviteToken);
    }

    public void setMenuItem(MenuItem menuItem) {
        this.setObject(MENU_ITEM, menuItem);
    }

    public void setRegistration(PublicRegistrationDTO publicRegistrationDTO) {
        this.setObject("registration", publicRegistrationDTO);
    }

    public void setSmsToVerify(String string) {
        this.setString(SMS_TO_VERIFY, new String[]{string});
    }

    public void setStepExecuted(CustomWizardStep customWizardStep, boolean bl) {
        this.setBoolean(this.executedKey(customWizardStep), bl);
    }

    public void setSteps(List<CustomWizardStepWithTransitions> list) {
        this.setObject("steps", list);
    }

    public void setUserAgentId(String string) {
        this.setObject(USER_AGENT_ID, string);
    }

    public void setVerifiedEmail(String string) {
        this.setString(VERIFIED_EMAIL, new String[]{string});
    }

    public void setVerifiedSms(String string) {
        this.setString(VERIFIED_SMS, new String[]{string});
    }

    public void warn(String string) {
        this.notify(NotificationLevel.WARNING, string);
    }

    private CustomValuesMap ensureCustomValues(Map<String, Object> map) {
        if (map instanceof CustomValuesMap) {
            return (CustomValuesMap)map;
        }
        CustomValuesMap customValuesMap = new CustomValuesMap(this.execution.getWizard().getCustomFields(), false);
        if (map != null) {
            customValuesMap.putAll(map);
        }
        return customValuesMap;
    }

    private String executedKey(CustomWizardStep customWizardStep) {
        return "executed@" + customWizardStep.getId();
    }
}

