/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.io.Serializable;
import java.util.Objects;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Agreement;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.RecordType;
import org.cyclos.model.system.imports.ImportType;

public class ExtensionPointFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long groupId;
    private Long agreementId;
    private Long transferTypeId;
    private Long recordTypeId;
    private Long voucherConfigurationId;
    private ImportType importType;

    public ExtensionPointFilter(Group group) {
        this.groupId = SimpleEntity.id((SimpleEntity)group);
    }

    public ExtensionPointFilter(Group group, Agreement agreement) {
        this.groupId = SimpleEntity.id((SimpleEntity)group);
        this.agreementId = SimpleEntity.id((SimpleEntity)agreement);
    }

    public ExtensionPointFilter(Group group, RecordType recordType) {
        this.groupId = SimpleEntity.id((SimpleEntity)group);
        this.recordTypeId = SimpleEntity.id((SimpleEntity)recordType);
    }

    public ExtensionPointFilter(ImportType importType) {
        this.importType = importType;
    }

    public ExtensionPointFilter(TransferType transferType) {
        this.transferTypeId = SimpleEntity.id((SimpleEntity)transferType);
    }

    public ExtensionPointFilter(VoucherConfiguration voucherConfiguration) {
        this.voucherConfigurationId = SimpleEntity.id((SimpleEntity)voucherConfiguration);
    }

    public Long ensureAgreementId() {
        if (this.agreementId == null) {
            throw new IllegalStateException("No agreement in this extension point filter");
        }
        return this.agreementId;
    }

    public Long ensureGroupId() {
        if (this.groupId == null) {
            throw new IllegalStateException("No group in this extension point filter");
        }
        return this.groupId;
    }

    public ImportType ensureImportType() {
        if (this.importType == null) {
            throw new IllegalStateException("No import type in this extension point filter");
        }
        return this.importType;
    }

    public Long ensureRecordTypeId() {
        if (this.recordTypeId == null) {
            throw new IllegalStateException("No record type in this extension point filter");
        }
        return this.recordTypeId;
    }

    public Long ensureTransferTypeId() {
        if (this.transferTypeId == null) {
            throw new IllegalStateException("No transfer type in this extension point filter");
        }
        return this.transferTypeId;
    }

    public Long ensureVoucherConfigurationId() {
        if (this.voucherConfigurationId == null) {
            throw new IllegalStateException("No voucher configuration in this extension point filter");
        }
        return this.voucherConfigurationId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ExtensionPointFilter extensionPointFilter = (ExtensionPointFilter)object;
        return Objects.equals(this.agreementId, extensionPointFilter.agreementId) && Objects.equals(this.groupId, extensionPointFilter.groupId) && this.importType == extensionPointFilter.importType && Objects.equals(this.recordTypeId, extensionPointFilter.recordTypeId) && Objects.equals(this.transferTypeId, extensionPointFilter.transferTypeId) && Objects.equals(this.voucherConfigurationId, extensionPointFilter.voucherConfigurationId);
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public Long getRecordTypeId() {
        return this.recordTypeId;
    }

    public Long getTransferTypeId() {
        return this.transferTypeId;
    }

    public int hashCode() {
        return Objects.hash(this.agreementId, this.groupId, this.importType, this.recordTypeId, this.transferTypeId, this.voucherConfigurationId);
    }
}

