/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.system.CustomWizardExecution;
import org.cyclos.entities.system.CustomWizardField;
import org.cyclos.entities.system.FormFieldsWizardStepField;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.impl.system.CustomWizardExecutionStorage;
import org.cyclos.model.system.wizardsteps.CustomWizardStepFieldDefinitionType;
import org.cyclos.model.system.wizardsteps.FormFieldsWizardStepFieldVO;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.utils.CollectionHelper;

public class FormFieldsWizardStepMeta {
    private List<Object> fields = new ArrayList<Object>();
    private Set<Object> readOnly = new HashSet<Object>();
    private boolean requireEmailVerification;
    private boolean requirePhoneVerification;

    public void add(FormFieldsWizardStepField formFieldsWizardStepField) {
        Object object = formFieldsWizardStepField.getIdentity();
        this.fields.add(object);
        if (formFieldsWizardStepField.isReadOnly()) {
            this.readOnly.add(object);
        }
        if (formFieldsWizardStepField.isRequireVerification()) {
            if (object == BasicProfileField.EMAIL) {
                this.requireEmailVerification = true;
            }
            if (object == PhoneNature.MOBILE) {
                this.requirePhoneVerification = true;
            }
        }
    }

    public FormFieldsWizardStepMeta add(FormFieldsWizardStepMeta formFieldsWizardStepMeta) {
        FormFieldsWizardStepMeta formFieldsWizardStepMeta2 = new FormFieldsWizardStepMeta();
        formFieldsWizardStepMeta2.fields.addAll(this.fields);
        formFieldsWizardStepMeta2.fields.addAll(formFieldsWizardStepMeta.fields);
        formFieldsWizardStepMeta2.readOnly.addAll(this.readOnly);
        formFieldsWizardStepMeta2.readOnly.addAll(formFieldsWizardStepMeta.readOnly);
        formFieldsWizardStepMeta2.requireEmailVerification = this.requireEmailVerification || formFieldsWizardStepMeta.requireEmailVerification;
        formFieldsWizardStepMeta2.requirePhoneVerification = this.requirePhoneVerification || formFieldsWizardStepMeta.requirePhoneVerification;
        return formFieldsWizardStepMeta2;
    }

    public FormFieldsWizardStepMeta applyPrevious(CustomWizardExecution customWizardExecution, FormFieldsWizardStepMeta formFieldsWizardStepMeta) {
        FormFieldsWizardStepMeta formFieldsWizardStepMeta2 = this.add(new FormFieldsWizardStepMeta());
        formFieldsWizardStepMeta2.fields.removeIf(object -> !this.isReadOnly(object) && formFieldsWizardStepMeta.has(object));
        formFieldsWizardStepMeta2.readOnly.retainAll(formFieldsWizardStepMeta2.fields);
        if (!formFieldsWizardStepMeta2.fields.contains(BasicProfileField.EMAIL)) {
            formFieldsWizardStepMeta2.requireEmailVerification = false;
        }
        if (!formFieldsWizardStepMeta2.fields.contains(PhoneNature.MOBILE)) {
            formFieldsWizardStepMeta2.requirePhoneVerification = false;
        }
        if (((CustomWizardExecutionStorage)customWizardExecution.getStorage()).getIdentityProviderId() != null) {
            formFieldsWizardStepMeta2.fields.remove(CustomWizardStepFieldDefinitionType.CAPTCHA);
        }
        return formFieldsWizardStepMeta2;
    }

    public List<Object> getFields(boolean bl) {
        return this.fields.stream().filter(object -> bl ? true : !this.readOnly.contains(object)).collect(Collectors.toList());
    }

    public Set<PhoneNature> getPhoneNatures(boolean bl) {
        List<Object> list = this.getFields(bl);
        if (list.contains(CustomWizardStepFieldDefinitionType.CONTACT_INFO)) {
            return EnumSet.allOf(PhoneNature.class);
        }
        return CollectionHelper.filterByType(list.stream(), PhoneNature.class).collect(Collectors.toSet());
    }

    public Set<ProfileField> getProfileFields(boolean bl) {
        return this.getFields(bl).stream().filter(object -> object instanceof ProfileField || object instanceof PhoneNature).map(object -> object instanceof PhoneNature ? BasicProfileField.PHONE : object).map(object -> (ProfileField)object).collect(Collectors.toSet());
    }

    public Set<CustomWizardField> getWizardFields(boolean bl) {
        return CollectionHelper.filterByType(this.getFields(bl).stream(), CustomWizardField.class).collect(Collectors.toSet());
    }

    public boolean has(Object object) {
        if (object instanceof FormFieldsWizardStepFieldVO) {
            return this.matches(this.fields, (FormFieldsWizardStepFieldVO)object);
        }
        return this.fields.contains(object);
    }

    public boolean isAgreements() {
        return this.fields.contains(CustomWizardStepFieldDefinitionType.AGREEMENTS);
    }

    public boolean isCaptcha() {
        return this.fields.contains(CustomWizardStepFieldDefinitionType.CAPTCHA);
    }

    public boolean isContactInfo() {
        return this.fields.contains(CustomWizardStepFieldDefinitionType.CONTACT_INFO);
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public boolean isPasswords() {
        return this.fields.contains(CustomWizardStepFieldDefinitionType.PASSWORDS);
    }

    public boolean isReadOnly(Object object) {
        if (object instanceof FormFieldsWizardStepFieldVO) {
            return this.matches(this.readOnly, (FormFieldsWizardStepFieldVO)object);
        }
        return this.readOnly.contains(object);
    }

    public boolean isRequireEmailVerification() {
        return this.requireEmailVerification;
    }

    public boolean isRequirePhoneVerification() {
        return this.requirePhoneVerification;
    }

    public boolean isSecurityQuestion() {
        return this.fields.contains(CustomWizardStepFieldDefinitionType.SECURITY_QUESTION);
    }

    private boolean matches(Collection<Object> collection, FormFieldsWizardStepFieldVO formFieldsWizardStepFieldVO) {
        if (formFieldsWizardStepFieldVO.getPhoneNature() != null) {
            return collection.contains(formFieldsWizardStepFieldVO.getPhoneNature());
        }
        if (formFieldsWizardStepFieldVO.getBasicProfileField() != null) {
            return collection.contains(formFieldsWizardStepFieldVO.getBasicProfileField());
        }
        if (formFieldsWizardStepFieldVO.getCustomProfileField() != null) {
            return collection.stream().anyMatch(object -> object instanceof UserCustomField && ((UserCustomField)object).getInternalName().equals(formFieldsWizardStepFieldVO.getCustomProfileField()));
        }
        if (formFieldsWizardStepFieldVO.getWizardField() != null) {
            return collection.stream().anyMatch(object -> object instanceof CustomWizardField && ((CustomWizardField)object).getInternalName().equals(formFieldsWizardStepFieldVO.getWizardField()));
        }
        return collection.contains(formFieldsWizardStepFieldVO.getType());
    }
}

