/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclos.impl.system.ProfilingElement;
import org.cyclos.impl.system.ProfilingEndEvent;
import org.cyclos.impl.system.ProfilingEntryType;
import org.cyclos.impl.system.ProfilingEvent;
import org.cyclos.impl.system.ProfilingEventType;
import org.cyclos.impl.system.ProfilingScriptStartEvent;
import org.cyclos.impl.system.ProfilingTransactionStartEvent;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.CollectionHelper;

public class ProfilingEntry
extends ProfilingElement {
    private static final long serialVersionUID = 1L;
    private static final Set<String> EXCLUDED_FROM_CONTEXT = new HashSet<String>();
    private Integer seq;
    private ProfilingEntryType type;
    private String name;
    private String taskClassName;
    private String host;
    private String network;
    private String channel;
    private String user;
    private String remoteAddress;
    private String errorTrace;
    private String sessionToken;
    private List<ProfilingEvent> events;
    private Object parameters;
    private Object result;
    private Map<String, Integer> cacheProducing;
    private Set<Triple<String, String, String>> scripts;

    public static void excludeClassFromProfilingContext(String string) {
        EXCLUDED_FROM_CONTEXT.add(ProfilingEntry.toExcludedClass(string));
    }

    public static void excludeMethodFromProfilingContext(String string, String string2) {
        EXCLUDED_FROM_CONTEXT.add(ProfilingEntry.toExcludedMethod(string, string2));
    }

    public static void excludePackageFromProfilingContext(String string) {
        EXCLUDED_FROM_CONTEXT.add(ProfilingEntry.toExcludedPackage(string));
    }

    private static String toExcludedClass(String string) {
        return string + ".*";
    }

    private static String toExcludedMethod(String string, String string2) {
        return string + "." + string2;
    }

    private static String toExcludedPackage(String string) {
        return ClassUtils.getPackageName((String)string) + ".**";
    }

    public ProfilingEntry() {
    }

    public ProfilingEntry(ProfilingEntryType profilingEntryType, String string) {
        this.type = profilingEntryType;
        this.name = string;
    }

    public void addCacheProducing(String string2, int n) {
        if (this.cacheProducing == null) {
            this.cacheProducing = new HashMap<String, Integer>();
        }
        this.cacheProducing.compute(string2, (string, n2) -> n2 == null ? n : n2 + n);
    }

    public void addEvent(ProfilingEvent profilingEvent2) {
        if (this.events == null) {
            this.events = new ArrayList<ProfilingEvent>();
        }
        if (profilingEvent2.getType() == ProfilingEventType.TRANSACTION_END) {
            ProfilingTransactionStartEvent profilingTransactionStartEvent;
            ProfilingEvent profilingEvent3 = (ProfilingEvent)CollectionHelper.last(this.events);
            if (profilingEvent3 != null && profilingEvent3.getType() == ProfilingEventType.TRANSACTION_START && (profilingTransactionStartEvent = (ProfilingTransactionStartEvent)profilingEvent3).getLevel() == TransactionLevel.READ_ONLY) {
                this.events.remove(this.events.size() - 1);
                return;
            }
        } else if (profilingEvent2.getType() == ProfilingEventType.SCRIPT_START) {
            if (this.scripts == null) {
                this.scripts = new HashSet<Triple<String, String, String>>();
            }
            ProfilingScriptStartEvent profilingScriptStartEvent = (ProfilingScriptStartEvent)profilingEvent2;
            this.scripts.add((Triple<String, String, String>)Triple.ofNonNull((Object)profilingScriptStartEvent.getName(), (Object)profilingScriptStartEvent.getScriptType(), (Object)profilingScriptStartEvent.getFunction()));
        }
        if (!(profilingEvent2 instanceof ProfilingEndEvent)) {
            profilingEvent2.setSeq((int)this.events.stream().filter(profilingEvent -> !(profilingEvent instanceof ProfilingEndEvent)).count() + 1);
            this.setContext(profilingEvent2);
        }
        profilingEvent2.onAdded(this);
        this.events.add(profilingEvent2);
    }

    public Map<String, Integer> getCacheProducing() {
        return this.cacheProducing;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getErrorTrace() {
        return this.errorTrace;
    }

    public List<ProfilingEvent> getEvents() {
        return this.events;
    }

    public String getHost() {
        return this.host;
    }

    public String getName() {
        return this.name;
    }

    public String getNetwork() {
        return this.network;
    }

    public Object getParameters() {
        return this.parameters;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public Object getResult() {
        return this.result;
    }

    @JsonIgnore
    public Set<Triple<String, String, String>> getScripts() {
        return this.scripts;
    }

    public Integer getSeq() {
        return this.seq;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getTaskClassName() {
        return this.taskClassName;
    }

    public ProfilingEntryType getType() {
        return this.type;
    }

    public String getUser() {
        return this.user;
    }

    public void setCacheProducing(Map<String, Integer> map) {
        this.cacheProducing = map;
    }

    public void setChannel(String string) {
        this.channel = string;
    }

    public void setErrorTrace(String string) {
        this.errorTrace = string;
    }

    public void setEvents(List<ProfilingEvent> list) {
        this.events = list;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNetwork(String string) {
        this.network = string;
    }

    public void setParameters(Object object) {
        this.parameters = object;
    }

    public void setRemoteAddress(String string) {
        this.remoteAddress = string;
    }

    public void setResult(Object object) {
        this.result = object;
    }

    public void setSeq(Integer n) {
        this.seq = n;
    }

    public void setSessionToken(String string) {
        this.sessionToken = string;
    }

    public void setTaskClassName(String string) {
        this.taskClassName = string;
    }

    public void setType(ProfilingEntryType profilingEntryType) {
        this.type = profilingEntryType;
    }

    public void setUser(String string) {
        this.user = string;
    }

    private boolean isExcludedMethod(String string, String string2) {
        int n = string2.lastIndexOf(36);
        if (n != -1) {
            string2 = string2.substring(0, n).replace("lambda$", "");
        }
        return EXCLUDED_FROM_CONTEXT.contains(ProfilingEntry.toExcludedMethod(string, string2));
    }

    private void setContext(ProfilingEvent profilingEvent) {
        String string = Stream.of(Thread.currentThread().getStackTrace()).filter(stackTraceElement -> !EXCLUDED_FROM_CONTEXT.contains(ProfilingEntry.toExcludedPackage(stackTraceElement.getClassName()))).filter(stackTraceElement -> stackTraceElement.getClassName().startsWith("org.cyclos.impl") || stackTraceElement.getClassName().startsWith("org.cyclos.security")).filter(stackTraceElement -> !EXCLUDED_FROM_CONTEXT.contains(ProfilingEntry.toExcludedClass(stackTraceElement.getClassName()))).filter(stackTraceElement -> !this.isExcludedMethod(stackTraceElement.getClassName(), stackTraceElement.getMethodName())).map(stackTraceElement -> String.format("%s.%s / %s:%s", ClassUtils.getShortClassName((String)stackTraceElement.getClassName()), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber())).findFirst().orElseGet(() -> null);
        profilingEvent.setContext(string);
    }
}

