/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system.scriptbindings;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import javax.script.Bindings;
import org.cyclos.model.system.scripts.DefaultScriptFunction;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.system.scripts.ScriptType;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

public abstract class BaseScriptBindings {
    private Map<String, Method> cache;
    private BeanWrapper bean = new BeanWrapperImpl((Object)this);

    public void apply(Bindings bindings) {
        this.properties().keySet().forEach(string -> bindings.put((String)string, this.bean.getPropertyValue(string)));
    }

    public Map<String, Method> properties() {
        if (this.cache == null) {
            this.cache = new TreeMap<String, Method>();
            for (PropertyDescriptor propertyDescriptor : this.bean.getPropertyDescriptors()) {
                if (propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null) continue;
                this.cache.put(propertyDescriptor.getName(), propertyDescriptor.getReadMethod());
            }
        }
        return this.cache;
    }

    public ScriptFunction scriptFunction() {
        return DefaultScriptFunction.DEFAULT;
    }

    public abstract ScriptType scriptType();
}

