/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system.scriptbindings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.cyclos.impl.system.scriptbindings.AccountFeeCalculationScriptBindings;
import org.cyclos.impl.system.scriptbindings.AccountNumberGenerationScriptBindings;
import org.cyclos.impl.system.scriptbindings.BackgroundTaskScriptBindings;
import org.cyclos.impl.system.scriptbindings.BaseScriptBindings;
import org.cyclos.impl.system.scriptbindings.ContentHelperScriptBindings;
import org.cyclos.impl.system.scriptbindings.CustomFieldValidationScriptBindings;
import org.cyclos.impl.system.scriptbindings.CustomOperationAvailabilityScriptBindings;
import org.cyclos.impl.system.scriptbindings.CustomOperationCallbackScriptBindings;
import org.cyclos.impl.system.scriptbindings.CustomOperationDefaultScriptBindings;
import org.cyclos.impl.system.scriptbindings.CustomOperationPreRunScriptBindings;
import org.cyclos.impl.system.scriptbindings.CustomWebServiceScriptBindings;
import org.cyclos.impl.system.scriptbindings.CustomWizardCallbackScriptBindings;
import org.cyclos.impl.system.scriptbindings.CustomWizardDefaultScriptBindings;
import org.cyclos.impl.system.scriptbindings.CustomWizardExternalRedirectScriptBindings;
import org.cyclos.impl.system.scriptbindings.CustomWizardStartScriptBindings;
import org.cyclos.impl.system.scriptbindings.CustomWizardTransitionScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExportFormatScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointAdScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointAgreementScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointAuthorizationScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointBaseScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointImportScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointOperatorScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointOrderScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointPhoneScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointRecordScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointTransactionScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointTransferScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointUserAddressScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointUserScriptBindings;
import org.cyclos.impl.system.scriptbindings.ExtensionPointVoucherScriptBindings;
import org.cyclos.impl.system.scriptbindings.InboundSmsGenerateResponseScriptBindings;
import org.cyclos.impl.system.scriptbindings.InboundSmsResolveSmsDataScriptBindings;
import org.cyclos.impl.system.scriptbindings.IpGeolocationScriptBindings;
import org.cyclos.impl.system.scriptbindings.LibraryScriptBindings;
import org.cyclos.impl.system.scriptbindings.LinkGenerationScriptBindings;
import org.cyclos.impl.system.scriptbindings.LoadCustomFieldValuesEntityScriptBindings;
import org.cyclos.impl.system.scriptbindings.LoadCustomFieldValuesFilterScriptBindings;
import org.cyclos.impl.system.scriptbindings.NotificationScriptBindings;
import org.cyclos.impl.system.scriptbindings.OutboundSmsScriptBindings;
import org.cyclos.impl.system.scriptbindings.PasswordHandlingScriptBindings;
import org.cyclos.impl.system.scriptbindings.PhoneNumberHandlingExampleScriptBindings;
import org.cyclos.impl.system.scriptbindings.PhoneNumberHandlingParseScriptBindings;
import org.cyclos.impl.system.scriptbindings.ScheduledTaskScriptBindings;
import org.cyclos.impl.system.scriptbindings.ScriptBindingKey;
import org.cyclos.impl.system.scriptbindings.ServiceInterceptorAfterScriptBindings;
import org.cyclos.impl.system.scriptbindings.ServiceInterceptorBeforeScriptBindings;
import org.cyclos.impl.system.scriptbindings.SessionHandlingLoginScriptBindings;
import org.cyclos.impl.system.scriptbindings.SessionHandlingLogoutScriptBindings;
import org.cyclos.impl.system.scriptbindings.SessionHandlingResolveScriptBindings;
import org.cyclos.impl.system.scriptbindings.SessionHandlingSearchScriptBindings;
import org.cyclos.impl.system.scriptbindings.SessionHandlingSetPropertiesScriptBindings;
import org.cyclos.impl.system.scriptbindings.SmsOperationScriptBindings;
import org.cyclos.impl.system.scriptbindings.TransferFeeCalculationScriptBindings;
import org.cyclos.impl.system.scriptbindings.TransferStatusScriptBindings;
import org.cyclos.model.system.extensionpoints.ExtensionPointNature;
import org.cyclos.model.system.scripts.CustomOperationScriptFunction;
import org.cyclos.model.system.scripts.CustomWizardScriptFunction;
import org.cyclos.model.system.scripts.DefaultScriptFunction;
import org.cyclos.model.system.scripts.ExtensionPointScriptFunction;
import org.cyclos.model.system.scripts.InboundSmsScriptFunction;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.system.scripts.PhoneNumberHandlingScriptFunction;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.system.scripts.ServiceInterceptorScriptFunction;
import org.cyclos.model.system.scripts.SessionHandlingScriptFunction;

public class ScriptBindingsRegistry {
    private static final Map<ScriptBindingKey, Class<? extends BaseScriptBindings>> MAPPINGS;

    public static Class<? extends BaseScriptBindings> getBindings(ScriptType scriptType) {
        return ScriptBindingsRegistry.getBindings(scriptType, (ScriptFunction)DefaultScriptFunction.DEFAULT);
    }

    public static Class<? extends BaseScriptBindings> getBindings(ScriptType scriptType, ScriptFunction scriptFunction) {
        return MAPPINGS.get(ScriptBindingsRegistry.newBindingKey(scriptType, scriptFunction, null));
    }

    public static Class<? extends BaseScriptBindings> getExtensionPointBindings(ExtensionPointScriptFunction extensionPointScriptFunction, ExtensionPointNature extensionPointNature) {
        return MAPPINGS.get(ScriptBindingsRegistry.newBindingKey(ScriptType.EXTENSION_POINT, (ScriptFunction)extensionPointScriptFunction, extensionPointNature));
    }

    public static void initialize() {
    }

    private static ScriptBindingKey newBindingKey(ScriptType scriptType) {
        return ScriptBindingsRegistry.newBindingKey(scriptType, (ScriptFunction)DefaultScriptFunction.DEFAULT, null);
    }

    private static ScriptBindingKey newBindingKey(ScriptType scriptType, ScriptFunction scriptFunction) {
        return ScriptBindingsRegistry.newBindingKey(scriptType, scriptFunction, null);
    }

    private static ScriptBindingKey newBindingKey(ScriptType scriptType, ScriptFunction scriptFunction, ExtensionPointNature extensionPointNature) {
        return new ScriptBindingKey(scriptType, scriptFunction, extensionPointNature);
    }

    private static void registerExtensionPointBindings(Class<? extends ExtensionPointBaseScriptBindings> clazz, ExtensionPointNature extensionPointNature, Map<ScriptBindingKey, Class<? extends BaseScriptBindings>> map) {
        map.put(ScriptBindingsRegistry.newBindingKey(ScriptType.EXTENSION_POINT, (ScriptFunction)ExtensionPointScriptFunction.SAVED, extensionPointNature), clazz);
        map.put(ScriptBindingsRegistry.newBindingKey(ScriptType.EXTENSION_POINT, (ScriptFunction)ExtensionPointScriptFunction.VALIDATED, extensionPointNature), clazz);
    }

    static {
        HashMap<ScriptBindingKey, Class<? extends BaseScriptBindings>> hashMap = new HashMap<ScriptBindingKey, Class<? extends BaseScriptBindings>>();
        hashMap.put(new ScriptBindingKey(ScriptType.ACCOUNT_FEE_CALCULATION), AccountFeeCalculationScriptBindings.class);
        hashMap.put(ScriptBindingsRegistry.newBindingKey(ScriptType.ACCOUNT_NUMBER_GENERATION), AccountNumberGenerationScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.BACKGROUND_TASK), BackgroundTaskScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.CONTENT_HELPER), ContentHelperScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.CUSTOM_FIELD_VALIDATION), CustomFieldValidationScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.CUSTOM_OPERATION, (ScriptFunction)CustomOperationScriptFunction.AVAILABILITY), CustomOperationAvailabilityScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.CUSTOM_OPERATION, (ScriptFunction)CustomOperationScriptFunction.CALLBACK), CustomOperationCallbackScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.CUSTOM_OPERATION, (ScriptFunction)CustomOperationScriptFunction.DEFAULT), CustomOperationDefaultScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.CUSTOM_OPERATION, (ScriptFunction)CustomOperationScriptFunction.PRE_RUN), CustomOperationPreRunScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.CUSTOM_WEB_SERVICE), CustomWebServiceScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.CUSTOM_WIZARD, (ScriptFunction)CustomWizardScriptFunction.CALLBACK), CustomWizardCallbackScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.CUSTOM_WIZARD, (ScriptFunction)CustomWizardScriptFunction.DEFAULT), CustomWizardDefaultScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.CUSTOM_WIZARD, (ScriptFunction)CustomWizardScriptFunction.EXTERNAL_REDIRECT), CustomWizardExternalRedirectScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.CUSTOM_WIZARD, (ScriptFunction)CustomWizardScriptFunction.START), CustomWizardStartScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.CUSTOM_WIZARD, (ScriptFunction)CustomWizardScriptFunction.TRANSITION), CustomWizardTransitionScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.EXPORT_FORMAT), ExportFormatScriptBindings.class);
        ScriptBindingsRegistry.registerExtensionPointBindings(ExtensionPointAdScriptBindings.class, ExtensionPointNature.AD, hashMap);
        ScriptBindingsRegistry.registerExtensionPointBindings(ExtensionPointAgreementScriptBindings.class, ExtensionPointNature.AGREEMENT, hashMap);
        ScriptBindingsRegistry.registerExtensionPointBindings(ExtensionPointAuthorizationScriptBindings.class, ExtensionPointNature.AUTHORIZATION, hashMap);
        ScriptBindingsRegistry.registerExtensionPointBindings(ExtensionPointImportScriptBindings.class, ExtensionPointNature.IMPORT, hashMap);
        ScriptBindingsRegistry.registerExtensionPointBindings(ExtensionPointOperatorScriptBindings.class, ExtensionPointNature.OPERATOR, hashMap);
        ScriptBindingsRegistry.registerExtensionPointBindings(ExtensionPointOrderScriptBindings.class, ExtensionPointNature.ORDER, hashMap);
        ScriptBindingsRegistry.registerExtensionPointBindings(ExtensionPointPhoneScriptBindings.class, ExtensionPointNature.PHONE, hashMap);
        ScriptBindingsRegistry.registerExtensionPointBindings(ExtensionPointRecordScriptBindings.class, ExtensionPointNature.RECORD, hashMap);
        ScriptBindingsRegistry.registerExtensionPointBindings(ExtensionPointTransactionScriptBindings.class, ExtensionPointNature.TRANSACTION, hashMap);
        ScriptBindingsRegistry.registerExtensionPointBindings(ExtensionPointTransferScriptBindings.class, ExtensionPointNature.TRANSFER, hashMap);
        ScriptBindingsRegistry.registerExtensionPointBindings(ExtensionPointUserScriptBindings.class, ExtensionPointNature.USER, hashMap);
        ScriptBindingsRegistry.registerExtensionPointBindings(ExtensionPointUserAddressScriptBindings.class, ExtensionPointNature.USER_ADDRESS, hashMap);
        ScriptBindingsRegistry.registerExtensionPointBindings(ExtensionPointVoucherScriptBindings.class, ExtensionPointNature.VOUCHER, hashMap);
        hashMap.put(new ScriptBindingKey(ScriptType.INBOUND_SMS, (ScriptFunction)InboundSmsScriptFunction.GENERATE_RESPONSE), InboundSmsGenerateResponseScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.INBOUND_SMS, (ScriptFunction)InboundSmsScriptFunction.RESOLVE_SMS_DATA), InboundSmsResolveSmsDataScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.IP_GEOLOCATION), IpGeolocationScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.LIBRARY), LibraryScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.LINK_GENERATION), LinkGenerationScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.LOAD_CUSTOM_FIELD_VALUES, (ScriptFunction)LoadValuesScriptFunction.ENTITY), LoadCustomFieldValuesEntityScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.LOAD_CUSTOM_FIELD_VALUES, (ScriptFunction)LoadValuesScriptFunction.FILTER), LoadCustomFieldValuesFilterScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.NOTIFICATION), NotificationScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.OUTBOUND_SMS), OutboundSmsScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.PASSWORD_HANDLING), PasswordHandlingScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.PHONE_NUMBER_HANDLING, (ScriptFunction)PhoneNumberHandlingScriptFunction.EXAMPLE), PhoneNumberHandlingExampleScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.PHONE_NUMBER_HANDLING, (ScriptFunction)PhoneNumberHandlingScriptFunction.PARSE), PhoneNumberHandlingParseScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.SCHEDULED_TASK), ScheduledTaskScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.SERVICE_INTERCEPTOR, (ScriptFunction)ServiceInterceptorScriptFunction.AFTER), ServiceInterceptorAfterScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.SERVICE_INTERCEPTOR, (ScriptFunction)ServiceInterceptorScriptFunction.BEFORE), ServiceInterceptorBeforeScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.SESSION_HANDLING, (ScriptFunction)SessionHandlingScriptFunction.LOGIN), SessionHandlingLoginScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.SESSION_HANDLING, (ScriptFunction)SessionHandlingScriptFunction.LOGOUT), SessionHandlingLogoutScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.SESSION_HANDLING, (ScriptFunction)SessionHandlingScriptFunction.RESOLVE), SessionHandlingResolveScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.SESSION_HANDLING, (ScriptFunction)SessionHandlingScriptFunction.SEARCH), SessionHandlingSearchScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.SESSION_HANDLING, (ScriptFunction)SessionHandlingScriptFunction.SET_PROPERTIES), SessionHandlingSetPropertiesScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.SMS_OPERATION), SmsOperationScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.TRANSFER_FEE_CALCULATION), TransferFeeCalculationScriptBindings.class);
        hashMap.put(new ScriptBindingKey(ScriptType.TRANSFER_STATUS), TransferStatusScriptBindings.class);
        Stream.of(ScriptType.values()).forEach(scriptType -> {
            if (!scriptType.getFunctionClass().isEnum()) {
                throw new IllegalStateException("Script function class must be an enum");
            }
            Stream.of((ScriptFunction[])scriptType.getFunctionClass().getEnumConstants()).forEach(scriptFunction -> {
                if (scriptType == ScriptType.EXTENSION_POINT) {
                    Stream.of(ExtensionPointNature.values()).forEach(extensionPointNature -> {
                        Class clazz = (Class)hashMap.get(ScriptBindingsRegistry.newBindingKey(scriptType, scriptFunction, extensionPointNature));
                        if (clazz == null) {
                            throw new IllegalStateException(String.format("Missing script bindings for %s extension point and function=%s", extensionPointNature, scriptFunction));
                        }
                    });
                } else {
                    Class clazz = (Class)hashMap.get(ScriptBindingsRegistry.newBindingKey(scriptType, scriptFunction));
                    if (clazz == null) {
                        throw new IllegalStateException(String.format("Missing script bindings for type=%s and function=%s", scriptType, scriptFunction));
                    }
                }
            });
        });
        MAPPINGS = Collections.unmodifiableMap(hashMap);
    }
}

