/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.cyclos.utils.CollectionHelper;

public class GroupsCacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Long networkId;
    private final Long groupId;
    private final Long[] productIds;

    public GroupsCacheKey(Long l, Long l2, Set<Long> set) {
        this.networkId = l;
        this.groupId = l2;
        this.productIds = (Long[])CollectionHelper.orEmpty(set).toArray(Long[]::new);
        Arrays.sort((Object[])this.productIds);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GroupsCacheKey groupsCacheKey = (GroupsCacheKey)object;
        return Objects.equals(this.groupId, groupsCacheKey.groupId) && Objects.equals(this.networkId, groupsCacheKey.networkId) && Arrays.equals((Object[])this.productIds, (Object[])groupsCacheKey.productIds);
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public Long getNetworkId() {
        return this.networkId;
    }

    public Long[] getProductIds() {
        return this.productIds;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode((Object[])this.productIds);
        n = 31 * n + Objects.hash(this.groupId, this.networkId);
        return n;
    }

    public boolean matchesNetwork(Long l) {
        return l == null || l.equals(this.networkId);
    }
}

