/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.math.BigDecimal;
import java.util.List;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.banking.AccountFee;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.messaging.MessageCategory;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.UserWizard;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.users.MemberOrBrokerProductAccessor;
import org.cyclos.impl.users.Resolver;
import org.cyclos.impl.users.productresolvers.HasAccountsResolver;
import org.cyclos.impl.users.productresolvers.ListResolver;
import org.cyclos.impl.users.productresolvers.MaxResolver;
import org.cyclos.impl.users.productresolvers.MemberCustomOperationsResolver;
import org.cyclos.impl.users.productresolvers.MemberCustomWizardsResolver;
import org.cyclos.impl.users.productresolvers.MemberProductsResolver;
import org.cyclos.impl.users.productresolvers.MinResolver;
import org.cyclos.impl.users.productresolvers.MyTokenTypesResolver;
import org.cyclos.impl.users.productresolvers.NullOrMaxResolver;
import org.cyclos.impl.users.productresolvers.ProductMyAdFieldPropertyResolver;
import org.cyclos.impl.users.productresolvers.ViewMyAccountsResolver;
import org.cyclos.impl.users.productresolvers.VouchersResolver;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.model.users.products.AccountAccessibility;
import org.cyclos.model.users.products.AccountProfileVisibility;
import org.cyclos.model.users.products.AccountVisibility;
import org.cyclos.model.users.products.BrokerVisibility;
import org.cyclos.model.users.products.MyMessagesForwardOperation;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.products.UserProfileActivity;
import org.cyclos.model.users.users.GroupFilterDefault;
import org.cyclos.utils.CollectionHelper;

public interface MemberProductAccessor
extends MemberOrBrokerProductAccessor {
    @Resolver(value=MinResolver.class)
    public AccountAccessibility getAccountAccessibility();

    @Resolver(value=ListResolver.class)
    public List<AccountFee> getAccountFees();

    @Resolver(value=MinResolver.class)
    public AccountVisibility getAccountVisibility();

    @Resolver(value=ListResolver.class)
    public List<TokenPrincipalType> getActivateUserTokenTypes();

    @Resolver(value=ListResolver.class)
    public List<TransferType> getChargebackPaymentTypes();

    @Resolver(value=ListResolver.class)
    public List<ContactInfoField> getContactInfoFields();

    @Resolver(value=MemberCustomOperationsResolver.class)
    public BooleanPropertiesHolder<CustomOperation> getCustomOperations();

    @Resolver(value=MaxResolver.class)
    public TimeInterval getDefaultAdPublicationTime();

    @Resolver(value=MaxResolver.class)
    public BigDecimal getDefaultCreditLimit();

    @Resolver(value=ListResolver.class)
    public List<BasicGroup> getDefaultFilterGroups();

    @Resolver(value=NullOrMaxResolver.class)
    public BigDecimal getDefaultPaymentAmountLimit();

    @Resolver(value=NullOrMaxResolver.class)
    public BigDecimal getDefaultPaymentAmountPerDayLimit();

    @Resolver(value=NullOrMaxResolver.class)
    public BigDecimal getDefaultPaymentAmountPerMonthLimit();

    @Resolver(value=NullOrMaxResolver.class)
    public BigDecimal getDefaultPaymentAmountPerWeekLimit();

    @Resolver(value=NullOrMaxResolver.class)
    public BigDecimal getDefaultPaymentAmountPerYearLimit();

    @Resolver(value=NullOrMaxResolver.class)
    public BigDecimal getDefaultUpperCreditLimit();

    @Resolver(value=MaxResolver.class)
    public MyMessagesForwardOperation getFwdMessageToEmail();

    @Resolver(value=ListResolver.class)
    public List<GroupFilterDefault> getGroupFilterDefault();

    @Resolver(value=ListResolver.class)
    public List<BasicGroup> getGroupsForUserSearch();

    @Resolver(value=ListResolver.class)
    public List<BasicGroup> getGroupsForViewProfile();

    @Resolver(value=MaxResolver.class)
    public BigDecimal getIndividualCreditLimit();

    @Resolver(value=MaxResolver.class)
    public BigDecimal getInitialCredit();

    @Resolver(value=MinResolver.class)
    public GeneratedTransferType getInitialCreditType();

    @Resolver(value=ListResolver.class)
    public List<PaymentTransferType> getMakePosPaymentTypes();

    @Resolver(value=MaxResolver.class)
    public int getMaxAdDescriptionSize();

    @Resolver(value=MaxResolver.class)
    public int getMaxAddressesPerAd();

    @Resolver(value=MaxResolver.class)
    public int getMaxAdImages();

    @Resolver(value=MaxResolver.class)
    public TimeInterval getMaxAdPublicationTime();

    @Resolver(value=MaxResolver.class)
    public int getMaxAds();

    @Resolver(value=MaxResolver.class)
    public int getMaxCategoriesPerAd();

    @Resolver(value=MaxResolver.class)
    public int getMaxContactInfos();

    @Resolver(value=MemberProductsResolver.class)
    public List<MemberProduct> getMemberProducts();

    @Resolver(value=ProductMyAdFieldPropertyResolver.class)
    public BooleanPropertiesHolder<AdCustomField> getMyAdFields();

    @Resolver(value=ListResolver.class)
    public List<PaymentTransferType> getMyApproveTicketPaymentTypes();

    @Resolver(value=ListResolver.class)
    public List<PaymentTransferType> getMyCreateTicketPaymentTypes();

    @Resolver(value=ListResolver.class)
    public List<PaymentTransferType> getMyExternalPaymentTypes();

    @Resolver(value=ListResolver.class)
    public List<PaymentTransferType> getMyPaymentRequestsSendToSystem();

    @Resolver(value=ListResolver.class)
    public List<PaymentTransferType> getMyPaymentRequestsSendToUser();

    @Resolver(value=ListResolver.class)
    public List<PaymentTransferType> getMyPaymentRequestTypes();

    @Resolver(value=ListResolver.class)
    public List<PaymentTransferType> getMyPaymentTypes();

    @Resolver(value=MyTokenTypesResolver.class)
    public BooleanPropertiesHolder<TokenPrincipalType> getMyTokenTypes();

    @Resolver(value=ListResolver.class)
    public List<TransferFilter> getMyTransferFilters();

    @Override
    default public Class<?> getProxyClass() {
        return MemberProductAccessor.class;
    }

    @Resolver(value=ListResolver.class)
    public List<PaymentTransferType> getReceivePaymentRequestTypes();

    @Resolver(value=ListResolver.class)
    public List<PaymentTransferType> getReceivePosPaymentTypes();

    @Resolver(value=ListResolver.class)
    public List<UserGroupAccessibility> getSearchUsersOnGroups();

    @Resolver(value=ListResolver.class)
    public List<PaymentTransferType> getSelfPayments();

    @Resolver(value=ListResolver.class)
    public List<MessageCategory> getSendMessagesToAdmin();

    @Resolver(value=MaxResolver.class)
    public AccountProfileVisibility getShowAccountInProfile();

    @Resolver(value=ListResolver.class)
    public List<UserProfileActivity> getShowActivitiesInProfile();

    @Resolver(value=MaxResolver.class)
    public BrokerVisibility getShowBrokers();

    @Resolver(value=ListResolver.class)
    public List<PaymentTransferType> getSystemPayments();

    @Resolver(value=ListResolver.class, name="userAccount")
    public List<UserAccountType> getUserAccounts();

    @Resolver(value=ListResolver.class)
    public List<PaymentTransferType> getUserPayments();

    @Resolver(value=ListResolver.class)
    public List<Currency> getViewAdsInOtherCurrencies();

    @Resolver(value=ListResolver.class)
    public List<UserGroupAccessibility> getViewProfileOnGroups();

    @Resolver(value=VouchersResolver.class)
    public BooleanPropertiesHolder<VoucherConfiguration> getVouchers();

    @Resolver(value=MemberCustomWizardsResolver.class)
    public BooleanPropertiesHolder<UserWizard> getWizards();

    @Resolver(value=HasAccountsResolver.class)
    default public boolean hasUserAccounts() {
        return CollectionHelper.isNotEmpty(this.getUserAccounts());
    }

    @Resolver(value=MaxResolver.class)
    public boolean isAdsRequireAuthorization();

    @Resolver(value=MaxResolver.class)
    public boolean isShowAdExpirationDate();

    @Resolver(value=MaxResolver.class)
    public boolean isShowAdPublicationDate();

    @Resolver(value=ViewMyAccountsResolver.class)
    public boolean isViewMyAccounts();

    @Resolver(value=MaxResolver.class)
    public boolean isWebShopAdsRequireAuthorization();
}

