/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.BooleanPath;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.access.AccessClientPrincipalType;
import org.cyclos.entities.access.Agreement;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.contentmanagement.DocumentCategory;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomWebService;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.ContactCustomField;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.QProductTransferStatusFlow;
import org.cyclos.entities.users.QuickAccess;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.BooleanPropertiesHolderImpl;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.users.ProfileField;

public class RestrictedOperatorProductAccessor<A extends ProductAccessor>
implements ProductAccessor {
    protected final OperatorGroup group;
    protected final A delegate;
    protected final Set<Permission> permissions;

    public RestrictedOperatorProductAccessor(OperatorGroup operatorGroup, A a, Set<Permission> set) {
        this.group = operatorGroup;
        this.delegate = a;
        this.permissions = set;
    }

    @Override
    public List<BasicGroup> getAccessibleUserGroups() {
        return this.delegate.getAccessibleUserGroups();
    }

    @Override
    public List<Agreement> getAgreements() {
        return this.delegate.getAgreements();
    }

    @Override
    public List<QuickAccess> getDefaultQuickAccess() {
        return this.delegate.getDefaultQuickAccess();
    }

    @Override
    public List<DocumentCategory> getDocumentCategoryView() {
        return Collections.emptyList();
    }

    @Override
    public List<BasicGroup> getGroupsForUserDirectory() {
        return this.delegate.getGroupsForUserDirectory();
    }

    @Override
    public int getMaxAddresses() {
        return 0;
    }

    @Override
    public int getMaxCustomImages() {
        return this.delegate.getMaxCustomImages();
    }

    @Override
    public int getMaxInvitationRecipients() {
        return 0;
    }

    @Override
    public int getMaxLandlinePhones() {
        return this.delegate.getMaxLandlinePhones();
    }

    @Override
    public int getMaxMessageRecipients() {
        if (this.group.isMessages()) {
            return this.delegate.getMaxMessageRecipients();
        }
        return 0;
    }

    @Override
    public int getMaxMobilePhones() {
        return this.delegate.getMaxMobilePhones();
    }

    @Override
    public int getMaxProfileImages() {
        return 0;
    }

    @Override
    public int getMaxSmsPerMonth() {
        return this.delegate.getMaxSmsPerMonth();
    }

    @Override
    public BooleanPropertiesHolder<AccessClientPrincipalType> getMyAccessClients() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public BooleanPropertiesHolder<ContactCustomField> getMyContactFields() {
        return this.delegate.getMyContactFields();
    }

    @Override
    public BooleanPropertiesHolder<ProfileField> getMyProfileFields() {
        return this.delegate.getMyProfileFields();
    }

    @Override
    public BooleanPropertiesHolder<RecordCustomField> getMyRecordFields(UserRecordType userRecordType) {
        return this.delegate.getMyRecordFields(userRecordType);
    }

    @Override
    public BooleanPropertiesHolder<UserRecordType> getMyRecordTypes() {
        BooleanPropertiesHolder<UserRecordType> booleanPropertiesHolder = this.delegate.getMyRecordTypes();
        for (Map.Entry<UserRecordType, BooleanProperties> entry : booleanPropertiesHolder.entries()) {
            if (this.group.getRecordTypes().contains(entry.getKey())) continue;
            entry.getValue().clear();
        }
        return booleanPropertiesHolder;
    }

    @Override
    public BooleanPropertiesHolder<PasswordType> getPasswordActions() {
        return this.delegate.getPasswordActions();
    }

    @Override
    public List<Permission> getPermissions() {
        List<Permission> list = this.delegate.getPermissions();
        list.retainAll(this.permissions);
        return list;
    }

    @Override
    public List<Product> getProducts() {
        return this.delegate.getProducts();
    }

    @Override
    public List<Role> getRoles() {
        if (this.group.isBrokering()) {
            return this.delegate.getRoles();
        }
        return Collections.singletonList(Role.MEMBER);
    }

    @Override
    public List<CustomWebService> getRunCustomWebServices() {
        return this.delegate.getRunCustomWebServices();
    }

    @Override
    public List<CustomOperation> getRunTransferCustomOperations() {
        return this.group.getCustomOperations().stream().filter(customOperation -> this.delegate.getRunTransferCustomOperations().contains(customOperation)).filter(customOperation -> customOperation.getScope() == CustomOperationScope.TRANSFER).sorted().collect(Collectors.toList());
    }

    @Override
    public List<ProfileField> getSimpleUserSearchProfileFields() {
        return this.delegate.getSimpleUserSearchProfileFields();
    }

    @Override
    public BooleanPropertiesHolder<TransferStatusFlow> getTransferStatusFlows() {
        BooleanPropertiesHolder<TransferStatusFlow> booleanPropertiesHolder = this.delegate.getTransferStatusFlows();
        BooleanPath booleanPath = QProductTransferStatusFlow.productTransferStatusFlow.editable;
        booleanPropertiesHolder.keysSet((Path<Boolean>)booleanPath).forEach(transferStatusFlow -> booleanPropertiesHolder.get((TransferStatusFlow)transferStatusFlow).clear((Path<Boolean>)booleanPath));
        return booleanPropertiesHolder;
    }

    @Override
    public List<UserGroupAccessibility> getUserDirectoryOnGroups() {
        return this.delegate.getUserDirectoryOnGroups();
    }

    @Override
    public List<UserGroupAccessibility> getUserGroupAccessibility() {
        return this.delegate.getUserGroupAccessibility();
    }

    @Override
    public BooleanPropertiesHolder<ProfileField> getUserProfileFields() {
        return this.delegate.getUserProfileFields();
    }

    @Override
    public List<TransactionCustomField> getVisibleTransactionFields() {
        return this.delegate.getVisibleTransactionFields();
    }

    @Override
    public List<VoucherCustomField> getVisibleVoucherFields() {
        return this.delegate.getVisibleVoucherFields();
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.delegate.hasPermission(permission) && this.permissions.contains(permission);
    }

    @Override
    public boolean hasRole(Role role) {
        return this.getRoles().contains(role);
    }

    @Override
    public boolean isEditMyProfile() {
        return false;
    }
}

