/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Predicate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cyclos.entities.access.AccessClientPrincipalType;
import org.cyclos.entities.access.Agreement;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.QAccessClientPrincipalType;
import org.cyclos.entities.access.QPasswordType;
import org.cyclos.entities.banking.QTransactionCustomField;
import org.cyclos.entities.banking.QTransferStatusFlow;
import org.cyclos.entities.banking.QVoucherCustomField;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.contentmanagement.DocumentCategory;
import org.cyclos.entities.contentmanagement.QDocumentCategory;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomWebService;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QCustomOperation;
import org.cyclos.entities.system.QCustomWebService;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.ContactCustomField;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.QContactCustomField;
import org.cyclos.entities.users.QProduct;
import org.cyclos.entities.users.QUserRecordType;
import org.cyclos.entities.users.QuickAccess;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.users.AbstractSystemProductAccessor;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.productresolvers.MyAccessClientsResolver;
import org.cyclos.impl.users.productresolvers.MyContactFieldsResolver;
import org.cyclos.impl.users.productresolvers.MyPasswordActionsResolver;
import org.cyclos.impl.users.productresolvers.MyProfileFieldsResolver;
import org.cyclos.impl.users.productresolvers.MyRecordTypesResolver;
import org.cyclos.impl.users.productresolvers.TransferStatusFlowsResolver;
import org.cyclos.impl.users.productresolvers.UserProfileFieldsResolver;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.users.ProfileField;
import org.springframework.context.ApplicationContext;

public class SystemProductAccessor
extends AbstractSystemProductAccessor
implements ProductAccessor {
    public SystemProductAccessor(ApplicationContext applicationContext, Network network) {
        super(applicationContext, network);
    }

    @Override
    public List<BasicGroup> getAccessibleUserGroups() {
        return Collections.emptyList();
    }

    @Override
    public List<Agreement> getAgreements() {
        return Collections.emptyList();
    }

    @Override
    public List<QuickAccess> getDefaultQuickAccess() {
        return Collections.emptyList();
    }

    @Override
    public List<DocumentCategory> getDocumentCategoryView() {
        return this.selectFrom(QDocumentCategory.documentCategory).fetch();
    }

    @Override
    public List<BasicGroup> getGroupsForUserDirectory() {
        return Collections.emptyList();
    }

    @Override
    public int getMaxAddresses() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxCustomImages() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxInvitationRecipients() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxLandlinePhones() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxMessageRecipients() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxMobilePhones() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxProfileImages() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxSmsPerMonth() {
        return Integer.MAX_VALUE;
    }

    @Override
    public BooleanPropertiesHolder<AccessClientPrincipalType> getMyAccessClients() {
        return this.toBooleanPropertiesHolder(QAccessClientPrincipalType.accessClientPrincipalType, MyAccessClientsResolver.class);
    }

    @Override
    public BooleanPropertiesHolder<ContactCustomField> getMyContactFields() {
        return this.toBooleanPropertiesHolder(QContactCustomField.contactCustomField, MyContactFieldsResolver.class);
    }

    @Override
    public BooleanPropertiesHolder<ProfileField> getMyProfileFields() {
        return this.forProfileFields(MyProfileFieldsResolver.class, true);
    }

    @Override
    public BooleanPropertiesHolder<RecordCustomField> getMyRecordFields(UserRecordType userRecordType) {
        return this.forRecordFields((RecordType)userRecordType);
    }

    @Override
    public BooleanPropertiesHolder<UserRecordType> getMyRecordTypes() {
        return this.toBooleanPropertiesHolder(QUserRecordType.userRecordType, MyRecordTypesResolver.class);
    }

    @Override
    public BooleanPropertiesHolder<PasswordType> getPasswordActions() {
        return this.toBooleanPropertiesHolder(QPasswordType.passwordType, MyPasswordActionsResolver.class);
    }

    @Override
    public List<Permission> getPermissions() {
        return Arrays.asList(Permission.values());
    }

    @Override
    public List<Product> getProducts() {
        return this.selectFrom(QProduct.product).fetch();
    }

    @Override
    public List<Role> getRoles() {
        return Collections.emptyList();
    }

    @Override
    public List<CustomWebService> getRunCustomWebServices() {
        QCustomWebService qCustomWebService = QCustomWebService.customWebService;
        return this.selectFrom(qCustomWebService).fetch();
    }

    @Override
    public List<CustomOperation> getRunTransferCustomOperations() {
        QCustomOperation qCustomOperation = QCustomOperation.customOperation;
        return ((DBQuery)this.selectFrom(qCustomOperation).where((Predicate)qCustomOperation.scope.eq((Object)CustomOperationScope.TRANSFER))).fetch();
    }

    @Override
    public List<ProfileField> getSimpleUserSearchProfileFields() {
        return Collections.emptyList();
    }

    @Override
    public BooleanPropertiesHolder<TransferStatusFlow> getTransferStatusFlows() {
        return this.toBooleanPropertiesHolder(QTransferStatusFlow.transferStatusFlow, TransferStatusFlowsResolver.class);
    }

    @Override
    public List<UserGroupAccessibility> getUserDirectoryOnGroups() {
        return Collections.singletonList(UserGroupAccessibility.ALL);
    }

    @Override
    public List<UserGroupAccessibility> getUserGroupAccessibility() {
        return Collections.singletonList(UserGroupAccessibility.ALL);
    }

    @Override
    public BooleanPropertiesHolder<ProfileField> getUserProfileFields() {
        return this.forProfileFields(UserProfileFieldsResolver.class, false);
    }

    @Override
    public List<TransactionCustomField> getVisibleTransactionFields() {
        return this.selectFrom(QTransactionCustomField.transactionCustomField).fetch();
    }

    @Override
    public List<VoucherCustomField> getVisibleVoucherFields() {
        return this.selectFrom(QVoucherCustomField.voucherCustomField).fetch();
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return true;
    }

    @Override
    public boolean hasRole(Role role) {
        return false;
    }

    @Override
    public boolean isEditMyProfile() {
        return true;
    }
}

