/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.QAccountType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.QProduct;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.BrokerProductAccessor;
import org.cyclos.impl.users.MemberOrBrokerProductAccessor;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.SystemAdminProductAccessor;
import org.cyclos.impl.users.SystemBrokerProductAccessor;
import org.cyclos.impl.users.SystemMemberOrBrokerProductAccessor;
import org.cyclos.impl.users.SystemMemberProductAccessor;
import org.cyclos.impl.users.SystemProductAccessor;
import org.cyclos.impl.users.SystemUserManagementProductAccessor;
import org.cyclos.impl.users.UserManagementProductAccessor;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.springframework.context.ApplicationContext;

public class SystemProductsAccessor
implements ProductsAccessor {
    private ApplicationContext applicationContext;
    private Network network;
    private List<Product> products;
    private SystemProductAccessor product;
    private SystemAdminProductAccessor admin;
    private SystemUserManagementProductAccessor userManagement;
    private SystemBrokerProductAccessor broker;
    private SystemMemberProductAccessor member;
    private SystemMemberOrBrokerProductAccessor memberOrBroker;
    private Map<UserAccountType, SystemMemberProductAccessor> memberByAccount;
    private EntityManagerHandler entityManagerHandler;

    public SystemProductsAccessor(ApplicationContext applicationContext, Network network) {
        this.applicationContext = applicationContext;
        this.entityManagerHandler = (EntityManagerHandler)applicationContext.getBean(EntityManagerHandler.class);
        this.network = network;
    }

    @Override
    public AdminProductAccessor admin() {
        if (this.admin == null) {
            this.admin = new SystemAdminProductAccessor(this.applicationContext, this.network);
        }
        return this.admin;
    }

    @Override
    public BrokerProductAccessor broker() {
        if (this.broker == null) {
            this.broker = new SystemBrokerProductAccessor(this.applicationContext, this.network);
        }
        return this.broker;
    }

    @Override
    public Collection<? extends Product> getProducts() {
        if (this.products == null) {
            RawEntityManagerHandler rawEntityManagerHandler = (RawEntityManagerHandler)this.applicationContext.getBean(RawEntityManagerHandler.class);
            QProduct qProduct = QProduct.product;
            this.products = ((DBQuery)rawEntityManagerHandler.selectFrom(qProduct).where((Predicate)(this.network == null ? qProduct.network().isNull() : qProduct.network().eq((Object)this.network)))).fetch();
        }
        return this.products;
    }

    @Override
    public List<AccountType> grantedAccountTypes() {
        QAccountType qAccountType = QAccountType.accountType;
        return this.entityManagerHandler.selectFrom(qAccountType).list(qAccountType);
    }

    @Override
    public MemberProductAccessor member() {
        if (this.member == null) {
            this.member = new SystemMemberProductAccessor(this.applicationContext, this.network, null);
        }
        return this.member;
    }

    @Override
    public MemberProductAccessor member(UserAccountType userAccountType) {
        SystemMemberProductAccessor systemMemberProductAccessor;
        if (this.memberByAccount == null) {
            this.memberByAccount = new HashMap<UserAccountType, SystemMemberProductAccessor>();
        }
        if ((systemMemberProductAccessor = this.memberByAccount.get(userAccountType)) == null) {
            systemMemberProductAccessor = new SystemMemberProductAccessor(this.applicationContext, this.network, userAccountType);
            this.memberByAccount.put(userAccountType, systemMemberProductAccessor);
        }
        return systemMemberProductAccessor;
    }

    @Override
    public MemberOrBrokerProductAccessor memberOrBroker() {
        if (this.memberOrBroker == null) {
            this.memberOrBroker = new SystemMemberOrBrokerProductAccessor(this.applicationContext, this.network);
        }
        return this.memberOrBroker;
    }

    @Override
    public ProductAccessor product() {
        if (this.product == null) {
            this.product = new SystemProductAccessor(this.applicationContext, this.network);
        }
        return this.product;
    }

    @Override
    public UserManagementProductAccessor userManagement() {
        if (this.userManagement == null) {
            this.userManagement = new SystemUserManagementProductAccessor(this.applicationContext, this.network);
        }
        return this.userManagement;
    }
}

