/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.List;
import java.util.stream.Stream;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.utils.ParameterVO;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;

public enum UserVariable implements HasMessageKey
{
    DISPLAY,
    GROUP_SET,
    GROUP,
    GROUP_DISPLAY,
    PHONES,
    MOBILE_PHONES,
    MOBILE_PHONE,
    LAND_LINE_PHONES,
    LAND_LINE_PHONE,
    ACCOUNT_NUMBER,
    ACCOUNT_TYPE_ID,
    ACCOUNT_TYPE_NAME,
    ACCOUNT_BALANCE,
    ACCOUNT_AVAILABLE_BALANCE,
    ACCOUNT_CREDIT_LIMIT,
    ACCOUNT_UPPER_CREDIT_LIMIT,
    APPLICATION_NAME,
    APPLICATION_URL,
    DATE,
    TIME,
    DATE_TIME;


    public static void addAccountParameters(List<ParameterVO> list, TranslationHandler translationHandler) {
        String string = "account".toUpperCase() + "_";
        Stream.of(UserVariable.values()).filter(userVariable -> userVariable.name().startsWith(string)).map(userVariable -> UserVariable.toParameter("account." + StringHelper.camelize((String)StringHelper.removeStart((String)userVariable.name(), (String)string)), userVariable.getMessageKey(), translationHandler)).forEach(list::add);
    }

    public static void addAddressParameters(List<ParameterVO> list, TranslationHandler translationHandler) {
        list.add(new ParameterVO(BasicProfileField.ADDRESS.getAlias() + "." + UserAddressDTO.NAME.getName(), translationHandler.message(ContentManagementKeys.StaticContents.VARIABLE_ADDRESS_PREFIX, new Object[]{GeneralKeys.Ui.NAME})));
        Stream.of(AddressFields.values()).map(addressFields -> new ParameterVO(BasicProfileField.ADDRESS.getAlias() + "." + addressFields.internalName(), translationHandler.message(ContentManagementKeys.StaticContents.VARIABLE_ADDRESS_PREFIX, new Object[]{addressFields}))).forEach(list::add);
    }

    public static void addGeneralParameters(List<ParameterVO> list, TranslationHandler translationHandler) {
        list.add(APPLICATION_NAME.toParameter(translationHandler));
        list.add(APPLICATION_URL.toParameter(translationHandler));
        list.add(DATE.toParameter(translationHandler));
        list.add(DATE_TIME.toParameter(translationHandler));
        list.add(TIME.toParameter(translationHandler));
    }

    public static void addOtherProfileParameters(List<ParameterVO> list, TranslationHandler translationHandler) {
        list.add(DISPLAY.toParameter(translationHandler));
        list.add(GROUP_SET.toParameter(translationHandler));
        list.add(GROUP.toParameter(translationHandler));
        list.add(GROUP_DISPLAY.toParameter(translationHandler));
        list.add(PHONES.toParameter(translationHandler));
        list.add(MOBILE_PHONES.toParameter(translationHandler));
        list.add(MOBILE_PHONE.toParameter(translationHandler));
        list.add(LAND_LINE_PHONES.toParameter(translationHandler));
        list.add(LAND_LINE_PHONE.toParameter(translationHandler));
    }

    public static void addProfileParameters(List<ParameterVO> list, TranslationHandler translationHandler) {
        Stream.of(BasicProfileField.values()).filter(basicProfileField -> basicProfileField != BasicProfileField.IMAGE).map(basicProfileField -> new ParameterVO(basicProfileField.getVariableName(), translationHandler.message(basicProfileField.getVariableKey(), new Object[0]))).forEach(list::add);
    }

    public static ParameterVO toParameter(String string, MessageKey messageKey, TranslationHandler translationHandler) {
        return new ParameterVO(string, translationHandler.message(messageKey, new Object[0]));
    }

    public static Pair<UserVariable, String> variable(String string) {
        try {
            if (StringHelper.camelize((String)APPLICATION_URL.name()).toLowerCase().equals(StringHelper.trim((Object)string).toLowerCase())) {
                return Pair.create((Object)((Object)APPLICATION_URL), null);
            }
            return Pair.create((Object)((Object)UserVariable.valueOf(StringHelper.transformCase((String)string, (boolean)true, (char)'_'))), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            List list = StringHelper.splitTrimming((String)string, (String)".");
            if (list.size() != 2) {
                return Pair.ofNulls();
            }
            try {
                string = StringHelper.transformCase((String)("account" + StringHelper.capitalizeFirst((String)((String)list.get(1)))), (boolean)true, (char)'_');
                return Pair.create((Object)((Object)UserVariable.valueOf(string)), (Object)((String)list.get(0)));
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return Pair.ofNulls();
            }
        }
    }

    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return ContentManagementKeys.StaticContents.VARIABLE_DISPLAY;
            }
            case 16: {
                return ContentManagementKeys.StaticContents.VARIABLE_APPLICATION_NAME;
            }
            case 17: {
                return ContentManagementKeys.StaticContents.VARIABLE_APPLICATION_URL;
            }
            case 2: {
                return ContentManagementKeys.StaticContents.VARIABLE_GROUP;
            }
            case 3: {
                return ContentManagementKeys.StaticContents.VARIABLE_GROUP_DISPLAY;
            }
            case 1: {
                return ContentManagementKeys.StaticContents.VARIABLE_GROUP_SET;
            }
            case 8: {
                return ContentManagementKeys.StaticContents.VARIABLE_LAND_LINE_PHONE;
            }
            case 7: {
                return ContentManagementKeys.StaticContents.VARIABLE_LAND_LINE_PHONES;
            }
            case 6: {
                return ContentManagementKeys.StaticContents.VARIABLE_MOBILE_PHONE;
            }
            case 5: {
                return ContentManagementKeys.StaticContents.VARIABLE_MOBILE_PHONES;
            }
            case 4: {
                return ContentManagementKeys.StaticContents.VARIABLE_PHONES;
            }
            case 13: {
                return ContentManagementKeys.StaticContents.VARIABLE_ACCOUNT_AVAILABLE_BALANCE;
            }
            case 12: {
                return ContentManagementKeys.StaticContents.VARIABLE_ACCOUNT_BALANCE;
            }
            case 14: {
                return ContentManagementKeys.StaticContents.VARIABLE_ACCOUNT_CREDIT_LIMIT;
            }
            case 9: {
                return ContentManagementKeys.StaticContents.VARIABLE_ACCOUNT_NUMBER;
            }
            case 10: {
                return ContentManagementKeys.StaticContents.VARIABLE_ACCOUNT_TYPE_ID;
            }
            case 11: {
                return ContentManagementKeys.StaticContents.VARIABLE_ACCOUNT_TYPE_NAME;
            }
            case 15: {
                return ContentManagementKeys.StaticContents.VARIABLE_ACCOUNT_UPPER_CREDIT_LIMIT;
            }
            case 18: {
                return ContentManagementKeys.StaticContents.VARIABLE_DATE;
            }
            case 19: {
                return ContentManagementKeys.StaticContents.VARIABLE_TIME;
            }
            case 20: {
                return ContentManagementKeys.StaticContents.VARIABLE_DATE_TIME;
            }
        }
        return null;
    }

    public ParameterVO toParameter(TranslationHandler translationHandler) {
        return UserVariable.toParameter(StringHelper.camelize((String)this.name()), this.getMessageKey(), translationHandler);
    }
}

