/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users.productresolvers;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProfileFieldComparator;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.users.productresolvers.ProductsResolver;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.BeanWrapper;

public abstract class FromListResolver<T, E>
implements ProductsResolver<T, Void> {
    @Override
    public final T resolve(Collection<Product> collection, String string, Void void_) {
        List<E> list = this.allValues(collection, string);
        return this.toResult(list);
    }

    protected boolean allowNulls() {
        return false;
    }

    protected Collection<E> newCollection() {
        return new HashSet();
    }

    protected abstract T toResult(List<E> var1);

    private List<E> allValues(Collection<Product> collection, String string) {
        Collection collection2 = this.newCollection();
        for (Product product : collection) {
            BeanWrapper beanWrapper = InvocationContext.wrap(product);
            if (!beanWrapper.isReadableProperty(string)) continue;
            Object object = beanWrapper.getPropertyValue(string);
            if (object != null) {
                Iterator iterator = IteratorUtils.getIterator((Object)object);
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    collection2.add(e);
                }
                continue;
            }
            if (!this.allowNulls()) continue;
            collection2.add(null);
        }
        return CollectionHelper.sort(collection2, this.comparator());
    }

    private Comparator<Object> comparator() {
        return Comparator.nullsFirst((object, object2) -> {
            if (object instanceof BigDecimal) {
                return BigDecimalHelper.compareTo((BigDecimal)((BigDecimal)object), (BigDecimal)((BigDecimal)object2));
            }
            if (object instanceof ProfileField) {
                return ProfileFieldComparator.getInstance().compare((ProfileField)object, (ProfileField)object2);
            }
            if (object instanceof Comparable) {
                return ((Comparable)object).compareTo(object2);
            }
            throw new IllegalArgumentException("Cannot compare an element while resolving products");
        });
    }
}

