/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.querydsl.core.types.Path;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cyclos.model.Property;
import org.cyclos.server.utils.PropertyHelper;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

public class BooleanProperties
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final BooleanProperties EMPTY = new BooleanProperties(){
        private static final long serialVersionUID = 1L;
        {
            this.set = Collections.unmodifiableSet(this.set);
        }

        public Object writeReplace() {
            return EmptyBooleanPropertiesHolder.INSTANCE;
        }
    };
    protected Set<String> set = new HashSet<String>();

    public static BooleanProperties empty() {
        return EMPTY;
    }

    public static BooleanProperties from(Map<?, BooleanProperties> map, Object object) {
        BooleanProperties booleanProperties;
        BooleanProperties booleanProperties2 = booleanProperties = map == null ? null : map.get(object);
        if (booleanProperties == null) {
            booleanProperties = EMPTY;
        }
        return booleanProperties;
    }

    public void clear() {
        this.set.clear();
    }

    public void clear(Path<Boolean> path) {
        this.set.remove(PropertyHelper.getPropertyName(path));
    }

    public void clear(Property<Boolean, ?> property) {
        this.set.remove(property.getName());
    }

    public BooleanProperties clone() {
        BooleanProperties booleanProperties = new BooleanProperties();
        booleanProperties.set = new HashSet<String>(this.set);
        return booleanProperties;
    }

    public void fill(Object object) {
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(object);
        this.doFill((BeanWrapper)beanWrapperImpl);
    }

    public Set<String> getProperties() {
        return this.set;
    }

    public <T> T instantiate(Class<T> clazz) {
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(clazz);
        this.doFill((BeanWrapper)beanWrapperImpl);
        return (T)beanWrapperImpl.getWrappedInstance();
    }

    public boolean isSet(Path<Boolean> path) {
        return this.set.contains(PropertyHelper.getPropertyName(path));
    }

    public boolean isSet(Property<Boolean, ?> property) {
        return this.set.contains(property.getName());
    }

    public void set(Path<Boolean> path) {
        this.set.add(PropertyHelper.getPropertyName(path));
    }

    public void set(Property<Boolean, ?> property) {
        this.set.add(property.getName());
    }

    public String toString() {
        return this.set.toString();
    }

    private void doFill(BeanWrapper beanWrapper) {
        for (String string : this.set) {
            beanWrapper.setPropertyValue(string, (Object)true);
        }
    }

    private static class EmptyBooleanPropertiesHolder {
        private static final EmptyBooleanPropertiesHolder INSTANCE = new EmptyBooleanPropertiesHolder();

        private EmptyBooleanPropertiesHolder() {
        }

        public Object readResolve() {
            return BooleanProperties.empty();
        }
    }
}

