/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.system.CustomField;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.utils.CollectionHelper;

public class CustomValuesMap
extends AbstractMap<String, Object> {
    private CustomFieldValueHandler customFieldValueHandler;
    private Map<String, CustomField<?, ?, ?>> customFields;
    private boolean sanitize;
    private Map<String, Object> values;

    public CustomValuesMap(Collection<? extends CustomField<?, ?, ?>> collection, boolean bl) {
        this.customFields = CollectionHelper.orEmpty(collection).stream().collect(Collectors.toMap(ConfigurationEntity::getInternalName, customField -> customField));
        this.sanitize = bl;
        this.values = new HashMap<String, Object>();
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.values.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.values.containsValue(object);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return this.values.equals(object);
    }

    @Override
    public Object get(Object object) {
        return this.values.get(object);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    @Override
    public Object put(String string, Object object) {
        CustomField<?, ?, ?> customField = this.customFields.get(string);
        if (customField == null) {
            throw new IllegalArgumentException("Invalid custom field: " + string);
        }
        object = this.handler().getValue(customField, object, this.sanitize);
        return this.values.put(string, object);
    }

    @Override
    public Object remove(Object object) {
        return this.values.remove(object);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Collection<Object> values() {
        return this.values.values();
    }

    private CustomFieldValueHandler handler() {
        if (this.customFieldValueHandler == null) {
            this.customFieldValueHandler = InvocationContext.bean(CustomFieldValueHandler.class);
        }
        return this.customFieldValueHandler;
    }
}

