/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.passwordtypes.PasswordInputMethod;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;

public class PasswordHelper {
    public static final int SPLIT_PASSWORD_LENGTH = 4;
    public static final String SPLIT_PASSWORD_SEPARATOR = "|";
    public static final String SPLIT_SEQUENCE_SEPARATOR = ",";

    public static List<String> generateVirtualKeyboardSequence(PasswordType passwordType, String string) {
        if (passwordType.getInputMethod() != PasswordInputMethod.VIRTUAL_KEYBOARD) {
            return null;
        }
        int n = passwordType.getLength().getMax();
        String string2 = passwordType.getPossibleCharacters();
        int n2 = (Integer)ObjectHelper.defaultValue((Object)passwordType.getCharactersPerButton(), (Object)1);
        int n3 = passwordType.getNumberOfButtons();
        int n4 = n3 * n2;
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder stringBuilder = new StringBuilder(n2);
        ArrayList<String> arrayList = new ArrayList<String>(n);
        StringBuilder stringBuilder2 = new StringBuilder(string2);
        StringBuilder stringBuilder3 = new StringBuilder(string2.length());
        for (int i = 0; i < n; ++i) {
            int n5;
            stringBuilder3.setLength(0);
            while (stringBuilder3.length() < n4) {
                StringHelper.shuffle((StringBuilder)stringBuilder2, (Random)secureRandom);
                stringBuilder3.append((CharSequence)stringBuilder2);
            }
            stringBuilder3.setLength(n4);
            if (string != null) {
                try {
                    n5 = string.charAt(i);
                    if (stringBuilder3.indexOf(String.valueOf((char)n5)) < 0) {
                        stringBuilder3.setCharAt(secureRandom.nextInt(n4), (char)n5);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            n5 = 0;
            ArrayList<String> arrayList2 = new ArrayList<String>(n3);
            for (int j = 0; j < n3; ++j) {
                stringBuilder.setLength(0);
                for (int k = 0; k < n2; ++k) {
                    stringBuilder.append(stringBuilder3.charAt(n5++));
                }
                arrayList2.add(stringBuilder.toString());
            }
            arrayList.add(CollectionHelper.join(arrayList2, (String)SPLIT_PASSWORD_SEPARATOR));
        }
        return arrayList;
    }

    public static boolean isTooObvious(String string, Collection<String> collection) throws ValidationException {
        boolean bl = CollectionHelper.orEmpty(collection).contains(string) || string.length() < 2;
        boolean bl2 = true;
        boolean bl3 = true;
        if (!bl) {
            char[] cArray = string.toCharArray();
            for (int i = 1; i < cArray.length && (bl2 || bl3); ++i) {
                if (bl2 && cArray[i] - cArray[i - 1] != 1) {
                    bl2 = false;
                }
                if (!bl3 || cArray[i] == cArray[i - 1]) continue;
                bl3 = false;
            }
            bl = bl3 || bl2;
        }
        return bl;
    }
}

