/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.io.Serializable;
import java.util.UUID;
import org.cyclos.model.access.devices.DeviceConfirmationFeedbackPushNotificationData;
import org.cyclos.model.access.identityproviders.IdentityProviderCallbackResult;
import org.cyclos.model.banking.accounts.AccountWithStatusVO;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.utils.PushNotificationEvent;
import org.cyclos.model.utils.PushNotificationEventType;

public class PushNotificationEventContext<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PushNotificationEventType<T> type;
    private Long userId;
    private String sessionToken;
    private String ticketNumber;
    private String deviceConfirmationId;
    private String identityProviderRequestId;
    private Long accountId;

    public static PushNotificationEventContext<AccountWithStatusVO> accountStatus(Long l) {
        PushNotificationEventContext<AccountWithStatusVO> pushNotificationEventContext = new PushNotificationEventContext<AccountWithStatusVO>();
        pushNotificationEventContext.type = PushNotificationEventType.ACCOUNT_STATUS;
        pushNotificationEventContext.accountId = l;
        return pushNotificationEventContext;
    }

    public static PushNotificationEventContext<DeviceConfirmationFeedbackPushNotificationData> deviceConfirmationFeedback(Long l, String string) {
        PushNotificationEventContext<DeviceConfirmationFeedbackPushNotificationData> pushNotificationEventContext = new PushNotificationEventContext<DeviceConfirmationFeedbackPushNotificationData>();
        pushNotificationEventContext.type = PushNotificationEventType.DEVICE_CONFIRMATION_FEEDBACK;
        pushNotificationEventContext.deviceConfirmationId = string;
        pushNotificationEventContext.userId = l;
        return pushNotificationEventContext;
    }

    public static <T> PushNotificationEventContext<T> forEvent(PushNotificationEvent<T> pushNotificationEvent) {
        PushNotificationEventContext<T> pushNotificationEventContext = new PushNotificationEventContext<T>();
        pushNotificationEventContext.type = pushNotificationEvent.getType();
        pushNotificationEventContext.userId = pushNotificationEvent.getToUserId();
        pushNotificationEventContext.sessionToken = pushNotificationEvent.getToSessionToken();
        pushNotificationEventContext.ticketNumber = pushNotificationEvent.getToTokenNumber();
        pushNotificationEventContext.deviceConfirmationId = pushNotificationEvent.getToDeviceConfirmationId();
        return pushNotificationEventContext;
    }

    public static PushNotificationEventContext<IdentityProviderCallbackResult> identityProviderCallback(Long l, String string) {
        PushNotificationEventContext<IdentityProviderCallbackResult> pushNotificationEventContext = new PushNotificationEventContext<IdentityProviderCallbackResult>();
        pushNotificationEventContext.type = PushNotificationEventType.IDENTITY_PROVIDER_CALLBACK;
        pushNotificationEventContext.identityProviderRequestId = string;
        pushNotificationEventContext.userId = l;
        return pushNotificationEventContext;
    }

    public static PushNotificationEventContext<Void> loggedOut(String string) {
        PushNotificationEventContext<Void> pushNotificationEventContext = new PushNotificationEventContext<Void>();
        pushNotificationEventContext.type = PushNotificationEventType.LOGGED_OUT;
        pushNotificationEventContext.sessionToken = string;
        return pushNotificationEventContext;
    }

    public static PushNotificationEventContext<Void> permissionsChanged(String string) {
        PushNotificationEventContext<Void> pushNotificationEventContext = new PushNotificationEventContext<Void>();
        pushNotificationEventContext.type = PushNotificationEventType.PERMISSIONS_CHANGED;
        pushNotificationEventContext.sessionToken = string;
        return pushNotificationEventContext;
    }

    public static PushNotificationEventContext<TicketVO> ticket(Long l, String string) {
        PushNotificationEventContext<TicketVO> pushNotificationEventContext = new PushNotificationEventContext<TicketVO>();
        pushNotificationEventContext.type = PushNotificationEventType.TICKET;
        pushNotificationEventContext.userId = l;
        pushNotificationEventContext.ticketNumber = string;
        return pushNotificationEventContext;
    }

    public static <T> PushNotificationEventContext<T> user(PushNotificationEventType<T> pushNotificationEventType, Long l) {
        PushNotificationEventContext<T> pushNotificationEventContext = new PushNotificationEventContext<T>();
        pushNotificationEventContext.type = pushNotificationEventType;
        pushNotificationEventContext.userId = l;
        return pushNotificationEventContext;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public String getDeviceConfirmationId() {
        return this.deviceConfirmationId;
    }

    public String getIdentityProviderRequestId() {
        return this.identityProviderRequestId;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getTicketNumber() {
        return this.ticketNumber;
    }

    public PushNotificationEventType<T> getType() {
        return this.type;
    }

    public Long getUserId() {
        return this.userId;
    }

    public PushNotificationEvent<T> newEvent(T t) {
        return new PushNotificationEvent(UUID.randomUUID().toString(), this.userId, this.sessionToken, this.ticketNumber, this.deviceConfirmationId, this.identityProviderRequestId, this.accountId, this.type, t);
    }
}

