/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.utils.CollectionHelper;

public class CacheOperation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean clear;
    private Set<Serializable> keys;
    private SerializablePredicate<Serializable> predicate;

    public CacheOperation() {
        this(true, null, null);
    }

    public CacheOperation(SerializablePredicate<Serializable> serializablePredicate) {
        this(false, null, serializablePredicate);
    }

    public CacheOperation(Set<Serializable> set) {
        this(false, set, null);
    }

    private CacheOperation(boolean bl, Set<Serializable> set, SerializablePredicate<Serializable> serializablePredicate) {
        if (!bl && set == null && serializablePredicate == null) {
            throw new IllegalArgumentException("Can't create an evict cache operation for a null keys set and null predicate");
        }
        this.clear = bl;
        this.keys = new HashSet(set == null ? Collections.emptySet() : set);
        this.predicate = serializablePredicate;
    }

    public boolean isForKey(Serializable serializable) {
        return this.clear || this.keys != null && this.keys.contains(serializable) || this.predicate != null && this.predicate.test(serializable);
    }

    public void merge(CacheOperation cacheOperation) {
        if (!this.clear) {
            if (cacheOperation.clear) {
                this.clear = true;
                this.keys = null;
                this.predicate = null;
            } else {
                this.keys.addAll(cacheOperation.keys);
                this.predicate = this.predicate == null ? cacheOperation.predicate : this.predicate.or(cacheOperation.predicate);
            }
        }
    }

    public void run(Cache<? extends Serializable, ?> cache) {
        if (cache == null) {
            return;
        }
        if (this.clear) {
            cache.clear();
        } else if (CollectionHelper.isNotEmpty(this.keys)) {
            cache.evict(this.keys);
        } else if (this.predicate != null) {
            cache.evict(this.predicate);
        }
    }

    public String toString() {
        return "CacheOperation [clear=" + this.clear + ", keys=" + String.valueOf(this.keys) + ", predicate=" + (this.predicate != null) + "]";
    }
}

