/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cache;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.ApplicationContext;

public class EmbeddableAccessorCacheValue
extends AccessorCacheValue {
    private static final long serialVersionUID = 1L;
    private Class<?> objectClass;
    private Map<String, AccessorCacheValue> values;

    public EmbeddableAccessorCacheValue(Object object) {
        this.objectClass = object.getClass();
        this.values = new HashMap<String, AccessorCacheValue>();
        BeanWrapper beanWrapper = InvocationContext.wrap(object);
        for (PropertyDescriptor propertyDescriptor : beanWrapper.getPropertyDescriptors()) {
            if (propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null) continue;
            String string = propertyDescriptor.getName();
            Object object2 = beanWrapper.getPropertyValue(string);
            AccessorCacheValue accessorCacheValue = AccessorCacheValue.create(object2);
            this.values.put(string, accessorCacheValue);
        }
    }

    @Override
    public Object unwrap(ApplicationContext applicationContext) {
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(this.objectClass);
        for (Map.Entry<String, AccessorCacheValue> entry : this.values.entrySet()) {
            beanWrapperImpl.setPropertyValue(entry.getKey(), entry.getValue().unwrap(applicationContext));
        }
        return beanWrapperImpl.getWrappedInstance();
    }
}

