/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.notifications;

import java.util.Date;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.InstallmentTransfer;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.RecurringPayment;
import org.cyclos.entities.banking.RecurringPaymentOccurrence;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.ScheduledPaymentInstallment;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherRedeem;
import org.cyclos.entities.banking.VoucherTopUp;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.utils.notifications.AccountNotification;
import org.cyclos.impl.utils.notifications.DateFormat;
import org.cyclos.impl.utils.notifications.NotificationDateFormat;
import org.cyclos.impl.utils.notifications.OfAmount;
import org.cyclos.impl.utils.notifications.TransactionNumber;
import org.cyclos.impl.utils.notifications.WithDescription;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.messaging.notifications.AccountNotificationType;

public interface AccountNotificationsHandler {
    @AccountNotification(value=AccountNotificationType.ALL_NON_SMS_PERFORMED_PAYMENTS)
    public void allNonSmsPerformedPayments(Transaction var1, CurrencyAmount var2, AccountOwner var3, @WithDescription String var4, @TransactionNumber String var5);

    @AccountNotification(value=AccountNotificationType.AUTHORIZED_PAYMENT_CANCELED)
    public void authorizedPaymentCanceled(Transaction var1, CurrencyAmount var2, AccountOwner var3, @TransactionNumber String var4);

    @AccountNotification(value=AccountNotificationType.AUTHORIZED_PAYMENT_DENIED)
    public void authorizedPaymentDenied(Transaction var1, CurrencyAmount var2, AccountOwner var3, @TransactionNumber String var4);

    @AccountNotification(value=AccountNotificationType.AUTHORIZED_PAYMENT_EXPIRED)
    public void authorizedPaymentExpired(Transaction var1, CurrencyAmount var2, @TransactionNumber String var3);

    @AccountNotification(value=AccountNotificationType.AUTHORIZED_PAYMENT_SUCCEEDED)
    public void authorizedPaymentSucceeded(Transaction var1, CurrencyAmount var2, AccountOwner var3, @TransactionNumber String var4);

    @AccountNotification(value=AccountNotificationType.EXTERNAL_PAYMENT_EXPIRED)
    public void externalPaymentExpired(Transaction var1, Date var2, CurrencyAmount var3, TransferType var4, String var5);

    @AccountNotification(value=AccountNotificationType.EXTERNAL_PAYMENT_PERFORMED_FAILED)
    public void externalPaymentPerformedFailed(Transaction var1, Date var2, CurrencyAmount var3, TransferType var4, String var5);

    @AccountNotification(value=AccountNotificationType.EXTERNAL_PAYMENT_RECEIVED_FAILED)
    public void externalPaymentReceivedFailed(Transaction var1, Date var2, AccountOwner var3, CurrencyAmount var4, TransferType var5);

    @AccountNotification(value=AccountNotificationType.INCOMING_RECURRING_PAYMENT_CANCELED)
    public void incomingRecurringPaymentCanceled(RecurringPayment var1, CurrencyAmount var2, TransferType var3, AccountOwner var4);

    @AccountNotification(value=AccountNotificationType.INCOMING_RECURRING_PAYMENT_FAILED)
    public void incomingRecurringPaymentFailed(RecurringPaymentOccurrence var1, Integer var2, CurrencyAmount var3, TransferType var4, AccountOwner var5);

    @AccountNotification(value=AccountNotificationType.INCOMING_RECURRING_PAYMENT_RECEIVED)
    public void incomingRecurringPaymentReceived(RecurringPayment var1, CurrencyAmount var2, TransferType var3, AccountOwner var4);

    @AccountNotification(value=AccountNotificationType.INCOMING_SCHEDULED_PAYMENT_CANCELED)
    public void incomingScheduledPaymentCanceled(ScheduledPayment var1, CurrencyAmount var2, TransferType var3, AccountOwner var4);

    @AccountNotification(value=AccountNotificationType.INCOMING_SCHEDULED_PAYMENT_FAILED)
    public void incomingScheduledPaymentFailed(ScheduledPaymentInstallment var1, CurrencyAmount var2, TransferType var3, AccountOwner var4);

    @AccountNotification(value=AccountNotificationType.INCOMING_SCHEDULED_PAYMENT_RECEIVED)
    public void incomingScheduledPaymentReceived(ScheduledPayment var1, CurrencyAmount var2, TransferType var3, AccountOwner var4);

    @AccountNotification(value=AccountNotificationType.LIMIT_CHANGE)
    public void limitChange(UserAccount var1, CurrencyAmount var2, CurrencyAmount var3, AccountType var4);

    @AccountNotification(value=AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING)
    public void operatorAuthorizedPaymentApprovedStillPending(Transaction var1, Operator var2, CurrencyAmount var3, BasicUser var4, @TransactionNumber String var5);

    @AccountNotification(value=AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_CANCELED)
    public void operatorAuthorizedPaymentCanceled(Transaction var1, Operator var2, CurrencyAmount var3, BasicUser var4, @TransactionNumber String var5);

    @AccountNotification(value=AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_DENIED)
    public void operatorAuthorizedPaymentDenied(Transaction var1, Operator var2, CurrencyAmount var3, BasicUser var4, @TransactionNumber String var5);

    @AccountNotification(value=AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_EXPIRED)
    public void operatorAuthorizedPaymentExpired(Transaction var1, Operator var2, CurrencyAmount var3, @TransactionNumber String var4);

    @AccountNotification(value=AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED)
    public void operatorAuthorizedPaymentSucceeded(Transaction var1, Operator var2, CurrencyAmount var3, BasicUser var4, @TransactionNumber String var5);

    @AccountNotification(value=AccountNotificationType.OPERATOR_PAYMENT_AWAITING_AUTHORIZATION)
    public void operatorPaymentAwaitingAuthorization(Transaction var1, CurrencyAmount var2, Operator var3, @TransactionNumber String var4);

    @AccountNotification(value=AccountNotificationType.PAYMENT_AWAITING_AUTHORIZATION)
    public void paymentAwaitingAuthorization(Transaction var1, CurrencyAmount var2, AccountOwner var3, @TransactionNumber String var4);

    @AccountNotification(value=AccountNotificationType.PAYMENT_PERFORMED_CHARGED_BACK)
    public void paymentPerformedChargedBack(Transfer var1, CurrencyAmount var2, AccountOwner var3, @TransactionNumber String var4);

    @AccountNotification(value=AccountNotificationType.PAYMENT_RECEIVED)
    public void paymentReceived(Transfer var1, CurrencyAmount var2, AccountOwner var3, @WithDescription String var4, @TransactionNumber String var5);

    @AccountNotification(value=AccountNotificationType.PAYMENT_RECEIVED_CHARGED_BACK)
    public void paymentReceivedChargedBack(Transfer var1, CurrencyAmount var2, AccountOwner var3, @TransactionNumber String var4);

    @AccountNotification(value=AccountNotificationType.PAYMENT_REQUEST_CANCELED)
    public void paymentRequestCanceled(PaymentRequest var1, CurrencyAmount var2, TransferType var3, AccountOwner var4, @TransactionNumber String var5);

    @AccountNotification(value=AccountNotificationType.PAYMENT_REQUEST_DENIED)
    public void paymentRequestDenied(PaymentRequest var1, CurrencyAmount var2, TransferType var3, AccountOwner var4, @TransactionNumber String var5);

    @AccountNotification(value=AccountNotificationType.PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED)
    public void paymentRequestExpirationDateChanged(PaymentRequest var1, CurrencyAmount var2, TransferType var3, AccountOwner var4, Date var5, String var6, @TransactionNumber String var7);

    @AccountNotification(value=AccountNotificationType.PAYMENT_REQUEST_EXPIRED)
    public void paymentRequestExpired(PaymentRequest var1, CurrencyAmount var2, TransferType var3, AccountOwner var4, @TransactionNumber String var5);

    @AccountNotification(value=AccountNotificationType.PAYMENT_REQUEST_PROCESSED)
    public void paymentRequestProcessed(PaymentRequest var1, CurrencyAmount var2, TransferType var3, AccountOwner var4, @TransactionNumber String var5);

    @AccountNotification(value=AccountNotificationType.PAYMENT_REQUEST_RECEIVED)
    public void paymentRequestReceived(PaymentRequest var1, CurrencyAmount var2, TransferType var3, AccountOwner var4, Date var5, String var6, @TransactionNumber String var7);

    @AccountNotification(value=AccountNotificationType.RECURRING_PAYMENT_FAILED)
    public void recurringPaymentFailed(RecurringPaymentOccurrence var1, Integer var2, CurrencyAmount var3, TransferType var4, AccountOwner var5);

    @AccountNotification(value=AccountNotificationType.RECURRING_PAYMENT_OCCURRENCE_PROCESSED)
    public void recurringPaymentOccurrenceProcessed(InstallmentTransfer var1, Integer var2, CurrencyAmount var3, TransferType var4, AccountOwner var5);

    @AccountNotification(value=AccountNotificationType.SCHEDULED_PAYMENT_FAILED)
    public void scheduledPaymentFailed(ScheduledPaymentInstallment var1, CurrencyAmount var2, TransferType var3, AccountOwner var4);

    @AccountNotification(value=AccountNotificationType.SCHEDULED_PAYMENT_INSTALLMENT_PROCESSED)
    public void scheduledPaymentInstallmentProcessed(ScheduledPaymentInstallment var1, Integer var2, CurrencyAmount var3, TransferType var4, AccountOwner var5);

    @AccountNotification(value=AccountNotificationType.SCHEDULED_PAYMENT_REQUEST_FAILED)
    public void scheduledPaymentRequestFailed(PaymentRequest var1, CurrencyAmount var2, TransferType var3, AccountOwner var4);

    @AccountNotification(value=AccountNotificationType.SENT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED)
    public void sentPaymentRequestExpirationDateChanged(PaymentRequest var1, CurrencyAmount var2, TransferType var3, AccountOwner var4, Date var5, String var6, @TransactionNumber String var7);

    @AccountNotification(value=AccountNotificationType.SMS_PERFORMED_PAYMENT)
    public void smsPerformedPayment(Transaction var1, CurrencyAmount var2, AccountOwner var3, @WithDescription String var4, @TransactionNumber String var5);

    @AccountNotification(value=AccountNotificationType.TICKET_WEBHOOK_FAILED)
    public void ticketWebhookFailed(Ticket var1, String var2, CurrencyAmount var3, InternalAccountOwner var4);

    @AccountNotification(value=AccountNotificationType.VOUCHER_ABOUT_TO_EXPIRE)
    public void voucherAboutToExpire(Voucher var1, @OfAmount CurrencyAmount var2, VoucherType var3, @DateFormat(value=NotificationDateFormat.DATE_DIFF) Date var4);

    @AccountNotification(value=AccountNotificationType.VOUCHER_ASSIGNED)
    public void voucherAssigned(Voucher var1, @OfAmount CurrencyAmount var2, VoucherType var3, @DateFormat(value=NotificationDateFormat.DATE_DIFF) Date var4);

    @AccountNotification(value=AccountNotificationType.VOUCHER_EXPIRATION_DATE_CHANGED)
    public void voucherExpirationDateChanged(Voucher var1, @OfAmount CurrencyAmount var2, VoucherType var3, @DateFormat(value=NotificationDateFormat.DATE_TIME) Date var4);

    @AccountNotification(value=AccountNotificationType.VOUCHER_EXPIRED)
    public void voucherExpired(Voucher var1, @OfAmount CurrencyAmount var2, VoucherType var3);

    @AccountNotification(value=AccountNotificationType.VOUCHER_PIN_BLOCKED)
    public void voucherPinBlocked(Voucher var1, @OfAmount CurrencyAmount var2, VoucherType var3, Object var4);

    @AccountNotification(value=AccountNotificationType.VOUCHER_REDEEM)
    public void voucherRedeem(VoucherRedeem var1, CurrencyAmount var2, User var3);

    @AccountNotification(value=AccountNotificationType.VOUCHER_TOP_UP)
    public void voucherTopUp(VoucherTopUp var1, CurrencyAmount var2, User var3);
}

