/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.notifications;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclos.entities.messaging.UserNotificationTypeConverter;
import org.cyclos.impl.utils.notifications.AccountNotification;
import org.cyclos.impl.utils.notifications.BrokeringNotification;
import org.cyclos.impl.utils.notifications.FeedbackAndReferenceNotification;
import org.cyclos.impl.utils.notifications.MarketplaceBuyerNotification;
import org.cyclos.impl.utils.notifications.MarketplaceSellerNotification;
import org.cyclos.impl.utils.notifications.PersonalNotification;
import org.cyclos.model.messaging.notifications.INotificationType;
import org.cyclos.model.messaging.notifications.NotificationRootType;
import org.cyclos.model.messaging.notifications.UserNotificationType;

public class UserNotificationMapping {
    private static final Map<NotificationRootType, Class<UserNotificationType>> CLASSES_BY_ROOT;
    private static final Map<NotificationRootType, List<UserNotificationType>> TYPES_BY_ROOT;
    private static final Map<String, UserNotificationType> TYPES_BY_NAME;
    private static final List<UserNotificationType> ALL_TYPES;

    public static Class<? extends UserNotificationType> classByRoot(NotificationRootType notificationRootType) {
        return CLASSES_BY_ROOT.get(notificationRootType);
    }

    public static UserNotificationType getAnnotatedType(Method method) {
        PersonalNotification personalNotification = method.getAnnotation(PersonalNotification.class);
        if (personalNotification != null) {
            return personalNotification.value();
        }
        AccountNotification accountNotification = method.getAnnotation(AccountNotification.class);
        if (accountNotification != null) {
            return accountNotification.value();
        }
        MarketplaceBuyerNotification marketplaceBuyerNotification = method.getAnnotation(MarketplaceBuyerNotification.class);
        if (marketplaceBuyerNotification != null) {
            return marketplaceBuyerNotification.value();
        }
        MarketplaceSellerNotification marketplaceSellerNotification = method.getAnnotation(MarketplaceSellerNotification.class);
        if (marketplaceSellerNotification != null) {
            return marketplaceSellerNotification.value();
        }
        FeedbackAndReferenceNotification feedbackAndReferenceNotification = method.getAnnotation(FeedbackAndReferenceNotification.class);
        if (feedbackAndReferenceNotification != null) {
            return feedbackAndReferenceNotification.value();
        }
        BrokeringNotification brokeringNotification = method.getAnnotation(BrokeringNotification.class);
        if (brokeringNotification != null) {
            return brokeringNotification.value();
        }
        return null;
    }

    public static UserNotificationType getByName(String string) {
        return TYPES_BY_NAME.get(string);
    }

    public static List<UserNotificationType> list() {
        return ALL_TYPES;
    }

    public static List<UserNotificationType> listByRoot(NotificationRootType notificationRootType) {
        return TYPES_BY_ROOT.get(notificationRootType);
    }

    static {
        Map map = INotificationType.Mapping.get();
        EnumMap<NotificationRootType, Class> enumMap = new EnumMap<NotificationRootType, Class>(NotificationRootType.class);
        EnumMap<NotificationRootType, ImmutableList> enumMap2 = new EnumMap<NotificationRootType, ImmutableList>(NotificationRootType.class);
        HashMap hashMap = new HashMap();
        ArrayList arrayList = new ArrayList();
        for (NotificationRootType notificationRootType : NotificationRootType.values()) {
            Class clazz = (Class)map.get(notificationRootType.name());
            if (clazz == null) {
                throw new IllegalStateException("No mapping provided for root type " + String.valueOf(notificationRootType));
            }
            EnumSet enumSet = EnumSet.allOf(clazz);
            enumMap.put(notificationRootType, clazz);
            enumMap2.put(notificationRootType, ImmutableList.copyOf(enumSet));
            enumSet.forEach(userNotificationType -> hashMap.put(userNotificationType.name(), userNotificationType));
            arrayList.addAll(enumSet);
        }
        CLASSES_BY_ROOT = ImmutableMap.copyOf(enumMap);
        TYPES_BY_ROOT = ImmutableMap.copyOf(enumMap2);
        TYPES_BY_NAME = ImmutableMap.copyOf(hashMap);
        ALL_TYPES = ImmutableList.copyOf(arrayList);
        UserNotificationTypeConverter.register(UserNotificationMapping::getByName);
    }
}

