/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.persistence;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionBase;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.utils.coercion.CoercionHelper;

public abstract class CustomProjection<T>
extends ExpressionBase<T>
implements FactoryExpression<T> {
    private static final long serialVersionUID = 1L;
    private Map<Expression<?>, Integer> mappings = new LinkedHashMap();
    private Object[] args;

    public CustomProjection(Class<T> clazz) {
        super(clazz);
    }

    public <R, C> R accept(Visitor<R, C> visitor, C c) {
        return (R)visitor.visit((FactoryExpression)this, c);
    }

    public final List<Expression<?>> getArgs() {
        Set<Expression<?>> set = this.mappings.keySet();
        return new ArrayList(set);
    }

    public final T newInstance(Object ... objectArray) {
        this.args = objectArray;
        return this.instantiate();
    }

    protected void add(Expression<?> ... expressionArray) {
        int n = this.mappings.size();
        for (Expression<?> expression : expressionArray) {
            Integer n2;
            if ((n2 = this.mappings.put(expression, n++)) == null) continue;
            throw new IllegalStateException("Query projection expression already added: " + String.valueOf(expression));
        }
    }

    protected <E> E get(Expression<E> expression) {
        Integer n = this.mappings.get(expression);
        if (n == null) {
            throw new IllegalStateException("Unmapped projection expression: " + String.valueOf(expression));
        }
        return (E)CoercionHelper.coerce((Class)expression.getType(), (Object)this.args[n]);
    }

    protected SessionData getSessionData() {
        return InvocationContext.getSessionData();
    }

    protected boolean has(Expression<?> expression) {
        return this.mappings.containsKey(expression);
    }

    protected abstract T instantiate();
}

