/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.persistence;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import com.querydsl.jpa.impl.JPAProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.QueryParameters;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.eclipse.persistence.queries.DatabaseQuery;

public class DBQuery<T>
extends AbstractJPAQuery<T, DBQuery<T>> {
    private static final long serialVersionUID = 1L;
    private final ConversionHandler conversionHandler;
    private final SessionData sessionData;

    public DBQuery(EntityManager entityManager, JPQLTemplates jPQLTemplates, ConversionHandler conversionHandler, SessionData sessionData) {
        this(entityManager, jPQLTemplates, (QueryMetadata)new DefaultQueryMetadata(), conversionHandler, sessionData);
    }

    private DBQuery(EntityManager entityManager, JPQLTemplates jPQLTemplates, QueryMetadata queryMetadata, ConversionHandler conversionHandler, SessionData sessionData) {
        super(entityManager, jPQLTemplates, queryMetadata);
        this.conversionHandler = conversionHandler;
        this.sessionData = sessionData;
    }

    public DBQuery<T> clone(EntityManager entityManager) {
        return this.clone(entityManager, JPAProvider.getTemplates((EntityManager)entityManager));
    }

    public DBQuery<T> clone(EntityManager entityManager, JPQLTemplates jPQLTemplates) {
        DBQuery<T> dBQuery = new DBQuery<T>(entityManager, jPQLTemplates, this.getMetadata().clone(), this.conversionHandler, this.sessionData);
        dBQuery.clone(this);
        return dBQuery;
    }

    @Deprecated
    public int count() {
        return (int)this.fetchCount();
    }

    public int count(NumberPath<?> numberPath) {
        return ((Long)this.select((Expression<U>)((Expression)numberPath.count())).fetchOne()).intValue();
    }

    public CloseableIterator<T> export() {
        this.offset(0L);
        this.limit(this.getSessionData().getConfiguration().getMaxResults());
        return CloseableIteratorHelper.lazy(() -> super.iterate());
    }

    public <RT> CloseableIterator<RT> export(Class<RT> clazz, Expression<?> expression) {
        return this.conversionHandler.convertIterator(clazz, this.export((Expression<RT>)expression));
    }

    public CloseableIterator<Tuple> export(Expression<?> ... expressionArray) {
        return this.select(expressionArray).export();
    }

    public <RT> CloseableIterator<RT> export(Expression<RT> expression) {
        return this.select((Expression<U>)((Expression)expression)).export();
    }

    @Deprecated
    public DBQuery<T> fetchJoin() {
        return (DBQuery)super.fetchJoin();
    }

    public Set<T> fetchSet() {
        return CollectionHelper.asSet((Iterable)this.fetch());
    }

    public SessionData getSessionData() {
        return this.sessionData;
    }

    public boolean hasEmptyResults() {
        return !this.hasResults();
    }

    public boolean hasResults() {
        return this.select((Expression<U>)((Expression)Expressions.ONE)).fetchFirst() != null;
    }

    @Deprecated
    public DBQuery<T> ignoreMaxResults() {
        return this;
    }

    public DBQuery<T> innerFetchHint(Path<?> ... pathArray) {
        this.setHint("eclipselink.join-fetch", Stream.of(pathArray).map(path -> path.getMetadata().getName()).collect(Collectors.joining(".")));
        return this;
    }

    @Deprecated
    public boolean isIgnoreMaxResults() {
        return false;
    }

    public CloseableIterator<T> iterate() {
        return CloseableIteratorHelper.lazy(() -> super.iterate());
    }

    public <RT> CloseableIterator<RT> iterate(Class<RT> clazz, Expression<?> expression) {
        return this.conversionHandler.convertIterator(clazz, this.iterate((Expression<RT>)expression));
    }

    public CloseableIterator<Tuple> iterate(Expression<?> ... expressionArray) {
        return this.select(expressionArray).iterate();
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> expression) {
        return this.select((Expression<U>)((Expression)expression)).iterate();
    }

    public DBQuery<T> leftFetchHint(Path<?> ... pathArray) {
        this.setHint("eclipselink.left-join-fetch", Stream.of(pathArray).map(path -> path.getMetadata().getName()).collect(Collectors.joining(".")));
        return this;
    }

    public <RT> List<RT> list(Class<RT> clazz, Expression<?> expression) {
        return this.conversionHandler.convertList(clazz, this.list((Expression<RT>)expression));
    }

    public List<Tuple> list(Expression<?> ... expressionArray) {
        return this.select(expressionArray).fetch();
    }

    public <RT> List<RT> list(Expression<RT> expression) {
        return this.select((Expression<U>)((Expression)expression)).fetch();
    }

    public <K, V> Map<K, V> map(Expression<K> expression, Expression<V> expression2) {
        return this.list(expression, expression2).stream().collect(Collectors.toMap(tuple -> tuple.get(expression), tuple -> tuple.get(expression2), (object, object2) -> object2, LinkedHashMap::new));
    }

    public <RT> Page<RT> page(Class<RT> clazz, Integer n, Integer n2, boolean bl, Expression<?> expression) {
        return this.conversionHandler.convertPage(clazz, (Iterable<?>)this.page(n, n2, bl, expression));
    }

    public <RT> Page<RT> page(Class<RT> clazz, QueryParameters queryParameters, Expression<?> expression) {
        Page<?> page = this.page(queryParameters, expression);
        return this.conversionHandler.convertPage(clazz, (Iterable<?>)page);
    }

    public <RT> Page<RT> page(Integer n, Integer n2, boolean bl, Expression<RT> expression) {
        return QueryHelper.page(this, this.sessionData, n, n2, bl, expression);
    }

    public <RT> Page<RT> page(QueryParameters queryParameters, Expression<RT> expression) {
        return QueryHelper.page(this, this.sessionData, queryParameters, expression);
    }

    public <RT> RT requiredUniqueResult(Class<RT> clazz, Expression<?> expression) throws EntityNotFoundException {
        return this.conversionHandler.convert(clazz, this.requiredUniqueResult(expression));
    }

    public <RT> RT requiredUniqueResult(Expression<RT> expression) throws EntityNotFoundException {
        RT RT = this.singleResult(expression);
        if (RT == null) {
            if (SimpleEntity.class.isAssignableFrom(expression.getType())) {
                throw new EntityNotFoundException(expression.getType());
            }
            throw new EntityNotFoundException();
        }
        return RT;
    }

    public DBQuery<Tuple> select(Expression<?> ... expressionArray) {
        this.queryMixin.setProjection(expressionArray);
        return this;
    }

    public <U> DBQuery<U> select(Expression<U> expression) {
        this.queryMixin.setProjection(expression);
        return this;
    }

    public <RT> Set<RT> set(Class<RT> clazz, Expression<?> expression) {
        return this.conversionHandler.convertSet(clazz, this.list((Expression<RT>)expression));
    }

    public Set<Tuple> set(Expression<?> ... expressionArray) {
        return CollectionHelper.asSet(this.list(expressionArray));
    }

    public <RT> Set<RT> set(Expression<RT> expression) {
        return CollectionHelper.asSet(this.list(expression));
    }

    @Deprecated
    public void setIgnoreMaxResults(boolean bl) {
    }

    public <RT> RT singleResult(Class<RT> clazz, Expression<?> expression) {
        return this.conversionHandler.convert(clazz, this.singleResult((Expression<RT>)expression));
    }

    public Tuple singleResult(Expression<?> ... expressionArray) {
        return (Tuple)this.select(expressionArray).fetchFirst();
    }

    public <RT> RT singleResult(Expression<RT> expression) {
        return (RT)this.select((Expression<U>)((Expression)expression)).fetchFirst();
    }

    public Stream<T> stream() {
        return CollectionHelper.asStream(this.iterate());
    }

    public Stream<Tuple> stream(Expression<?> ... expressionArray) {
        return CollectionHelper.asStream(this.select(expressionArray).iterate());
    }

    public <RT> Stream<RT> stream(Expression<RT> expression) {
        return CollectionHelper.asStream(this.select((Expression<U>)((Expression)expression)).iterate());
    }

    protected Query createQuery(QueryModifiers queryModifiers, boolean bl) {
        String string;
        QueryMetadata queryMetadata = this.getMetadata();
        ArrayList<OrderSpecifier> arrayList = new ArrayList<OrderSpecifier>(queryMetadata.getOrderBy());
        String string2 = string = queryMetadata.getProjection() == null ? "" : queryMetadata.getProjection().toString();
        if (string.contains("count(") || string.contains("min(") || string.contains("max(") || string.contains("avg(")) {
            this.getMetadata().clearOrderBy();
        }
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create((Multimap)this.hints);
        this.hints.clear();
        Query query = super.createQuery(queryModifiers, bl);
        DatabaseQuery databaseQuery = (DatabaseQuery)query.unwrap(DatabaseQuery.class);
        boolean bl2 = databaseQuery.isObjectLevelReadQuery() && !databaseQuery.isReportQuery();
        for (Map.Entry entry : linkedHashMultimap.entries()) {
            boolean bl3;
            boolean bl4 = bl3 = "eclipselink.join-fetch".equals(entry.getKey()) || "eclipselink.left-join-fetch".equals(entry.getKey());
            if (bl3 && !bl2) continue;
            query.setHint((String)entry.getKey(), entry.getValue());
        }
        this.hints.putAll((Multimap)linkedHashMultimap);
        arrayList.forEach(arg_0 -> ((QueryMetadata)queryMetadata).addOrderBy(arg_0));
        return query;
    }
}

