/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.system.PaymentPrincipalsConfiguration;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.entities.users.User;
import org.cyclos.impl.users.LocateUserOption;
import org.cyclos.impl.users.UserLocatorHandler;
import org.cyclos.impl.utils.sms.InboundSmsParameterException;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;

public class SmsParameterProcessor {
    private final UserLocatorHandler userLocatorHandler;
    private final SmsOperationConfiguration operationConfiguration;
    private final List<String> params;
    private int cursor;

    public SmsParameterProcessor(UserLocatorHandler userLocatorHandler, SmsOperationConfiguration smsOperationConfiguration, List<String> list) {
        this.userLocatorHandler = userLocatorHandler;
        this.operationConfiguration = smsOperationConfiguration;
        this.params = (List)ObjectHelper.defaultValue(list, Collections.emptyList());
        this.cursor = -1;
    }

    public boolean hasNext() {
        return this.cursor + 1 < this.params.size();
    }

    public BigDecimal nextAmount(Object object, int n) throws InboundSmsParameterException {
        BigDecimal bigDecimal = this.nextDecimal(object);
        if (BigDecimalHelper.isNegativeOrZero((BigDecimal)BigDecimalHelper.round((BigDecimal)bigDecimal, (int)n))) {
            throw new InboundSmsParameterException(object, this.cursor - 1, String.valueOf(bigDecimal));
        }
        return bigDecimal;
    }

    public BigDecimal nextDecimal(Object object) throws InboundSmsParameterException {
        String string = this.nextString(object).replaceAll("\\,", ".");
        try {
            return new BigDecimal(string);
        }
        catch (Exception exception) {
            throw new InboundSmsParameterException(object, this.cursor - 1, string);
        }
    }

    public int nextInt(Object object) throws InboundSmsParameterException {
        String string = this.nextString(object);
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new InboundSmsParameterException(object, this.cursor - 1);
        }
    }

    public String nextString(Object object) throws InboundSmsParameterException {
        ++this.cursor;
        if (this.cursor >= this.params.size()) {
            throw new InboundSmsParameterException(object, this.cursor);
        }
        return this.params.get(this.cursor);
    }

    public User nextUser(Object object) throws InboundSmsParameterException {
        return this.doNextUser(object, null, null);
    }

    public User nextUserForPayment(Object object) throws InboundSmsParameterException {
        PaymentPrincipalsConfiguration paymentPrincipalsConfiguration = this.operationConfiguration.getChannelConfiguration().getPayment();
        return this.doNextUser(object, paymentPrincipalsConfiguration.getPrincipalTypes(), paymentPrincipalsConfiguration.getDefaultPrincipalType());
    }

    public String remaining(Object object, String string) throws InboundSmsParameterException {
        ++this.cursor;
        if (this.cursor >= this.params.size()) {
            throw new InboundSmsParameterException(object, this.cursor);
        }
        List<String> list = this.params.subList(this.cursor, this.params.size());
        this.cursor = this.params.size();
        return StringHelper.join(list, (String)string);
    }

    private User doNextUser(Object object, Collection<PrincipalType> collection, PrincipalType principalType) {
        String string = this.nextString(object);
        try {
            UserLocatorVO userLocatorVO = new UserLocatorVO();
            userLocatorVO.setPrincipal(string);
            return this.userLocatorHandler.locate(userLocatorVO, EnumSet.of(LocateUserOption.IGNORE_HIDDEN), collection, principalType).getUser();
        }
        catch (Exception exception) {
            if (object instanceof MessageKey) {
                throw new InboundSmsParameterException(object, this.cursor - 1, string);
            }
            throw new IllegalArgumentException("Unexpected paramIdentifier: " + String.valueOf(object));
        }
    }
}

