/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation;

import com.querydsl.core.types.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.system.CustomField;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.utils.RestBeanPropertyMapping;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.CustomFieldPropertyAccess;
import org.cyclos.impl.utils.validation.EntityPropertyAccess;
import org.cyclos.impl.utils.validation.GeneralValidation;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.TextValidationError;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.validations.PropertyValidations;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.Bean;
import org.cyclos.model.ValidationException;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.TranslationMessageSpecification;
import org.cyclos.utils.ValidationResult;

public class Validator {
    private static final Logger LOG = LogManager.getLogger(Validator.class);
    private Map<Class<? extends GeneralValidation>, GeneralValidation> generalValidations = new LinkedHashMap<Class<? extends GeneralValidation>, GeneralValidation>();
    private Map<Object, Property> properties = new LinkedHashMap<Object, Property>();
    private Map<PropertyAccess, Validator> nested;
    private String propertyNamePrefix;
    private String propertyDisplayPrefix;

    public Property customField(CustomField<?, ?, ?> customField, CustomFieldValueHandler customFieldValueHandler) {
        return this.propertyInternal(new CustomFieldPropertyAccess(customField, customFieldValueHandler, true), customField);
    }

    public Property customField(CustomField<?, ?, ?> customField, Object object, CustomFieldValueHandler customFieldValueHandler) {
        return this.propertyInternal(new CustomFieldPropertyAccess(customField, object, customFieldValueHandler, true), customField);
    }

    public Validator general(GeneralValidation generalValidation) {
        this.generalValidations.put(generalValidation.getClass(), generalValidation);
        return this;
    }

    public Collection<GeneralValidation> getGeneralValidations() {
        return this.generalValidations.values();
    }

    public String getPropertyDisplayPrefix() {
        return this.propertyDisplayPrefix;
    }

    public String getPropertyNamePrefix() {
        return this.propertyNamePrefix;
    }

    public boolean hasPropertyValidationFor(CustomField<?, ?, ?> customField) {
        return this.properties.containsKey(customField);
    }

    public boolean hasValidationFor(org.cyclos.model.Property<?, ?> property) {
        return this.properties.containsKey(property.getName());
    }

    public boolean hasValidationFor(Path<?> path) {
        return this.properties.containsKey(PropertyHelper.getPropertyName(path));
    }

    public Validator nested(org.cyclos.model.Property<?, ?> property, Validator validator) {
        return this.nested(new BeanPropertyAccess(property), validator);
    }

    public Validator nested(PropertyAccess propertyAccess, Validator validator) {
        if (this.nested == null) {
            this.nested = new LinkedHashMap<PropertyAccess, Validator>();
        }
        this.nested.put(propertyAccess, validator);
        String string = propertyAccess.getPropertyName();
        if (this.propertyNamePrefix == null) {
            validator.setPropertyNamePrefix(string);
        } else {
            validator.setPropertyNamePrefix(this.propertyNamePrefix + "." + string);
        }
        return this;
    }

    public Property property(org.cyclos.model.Property<?, ?> property, MessageKey messageKey) {
        return this.propertyInternal(new BeanPropertyAccess(property), messageKey);
    }

    public Property property(org.cyclos.model.Property<?, ?> property, NamedEntity namedEntity) {
        return this.propertyInternal(new BeanPropertyAccess(property), namedEntity);
    }

    public Property property(org.cyclos.model.Property<?, ?> property, String string) {
        return this.propertyInternal(new BeanPropertyAccess(property), string);
    }

    public Property property(org.cyclos.model.Property<?, ?> property, TranslationMessageSpecification translationMessageSpecification) {
        return this.propertyInternal(new BeanPropertyAccess(property), translationMessageSpecification);
    }

    public Property property(Path<?> path, MessageKey messageKey) {
        return this.propertyInternal(new EntityPropertyAccess(path), messageKey);
    }

    public Property property(Path<?> path, NamedEntity namedEntity) {
        return this.propertyInternal(new EntityPropertyAccess(path), namedEntity);
    }

    public Property property(Path<?> path, TranslationMessageSpecification translationMessageSpecification) {
        return this.propertyInternal(new EntityPropertyAccess(path), translationMessageSpecification);
    }

    public Property property(PropertyAccess propertyAccess, MessageKey messageKey) {
        return this.propertyInternal(propertyAccess, messageKey);
    }

    public Property property(PropertyAccess propertyAccess, NamedEntity namedEntity) {
        return this.propertyInternal(propertyAccess, namedEntity);
    }

    public Property property(PropertyAccess propertyAccess, String string) {
        return this.propertyInternal(propertyAccess, string);
    }

    public Property property(PropertyAccess propertyAccess, Supplier<Object> supplier) {
        return this.propertyInternal(propertyAccess, supplier);
    }

    public Property property(PropertyAccess propertyAccess, TranslationMessageSpecification translationMessageSpecification) {
        return this.propertyInternal(propertyAccess, translationMessageSpecification);
    }

    public void setPropertyDisplayPrefix(String string) {
        this.propertyDisplayPrefix = string;
    }

    public void setPropertyNamePrefix(String string) {
        this.propertyNamePrefix = string;
    }

    public void validate(RestBeanPropertyMapping restBeanPropertyMapping, FormatterImpl formatterImpl, Object object) throws ValidationException {
        ValidationResult validationResult = new ValidationResult();
        this.appendValidation(restBeanPropertyMapping, formatterImpl, validationResult, object);
        validationResult.throwIfHasErrors();
    }

    protected boolean appendPropertyValidations(RestBeanPropertyMapping restBeanPropertyMapping, FormatterImpl formatterImpl, ValidationResult validationResult, Property property, Object object) {
        org.cyclos.model.Property<?, Bean> property2;
        Collection<PropertyValidation> collection;
        boolean bl = false;
        Object object2 = property.getIdentifier();
        Object object3 = null;
        try {
            object3 = property.getValue(object);
            collection = property.getValidations();
        }
        catch (Exception exception) {
            property2 = formatterImpl.getCyclosProperties().isDumpAllErrors() ? Level.ERROR : Level.DEBUG;
            LOG.log((Level)property2, "Exception while validating property " + String.valueOf(property) + " of " + String.valueOf(object), (Throwable)exception);
            collection = Collections.singleton(PropertyValidations.invalid(true, ValidationErrors.invalid()));
        }
        PropertyAccess propertyAccess = property.getAccess();
        property2 = null;
        if (propertyAccess instanceof BeanPropertyAccess) {
            property2 = ((BeanPropertyAccess)propertyAccess).getBeanProperty();
        }
        String string = null;
        for (PropertyValidation propertyValidation : collection) {
            Object object4;
            ValidationError validationError = propertyValidation.validate(object, property.getValidationIdentifier(), object3);
            if (validationError == null) continue;
            if (string == null) {
                string = this.resolveDisplayName(formatterImpl, property, object);
            }
            bl = true;
            String string2 = this.resolvePropertyMessage(formatterImpl, string, validationError);
            if (object2 instanceof CustomField) {
                object4 = (CustomField)object2;
                validationResult.addCustomFieldError(ModelHelper.unqualifyInternalName((String)object4.getInternalName()), string2);
                continue;
            }
            object4 = (String)object2;
            if (restBeanPropertyMapping != null && property2 != null && object instanceof Bean && InvocationContext.getSessionData().isRest()) {
                object4 = restBeanPropertyMapping.restProperty(property2, (Bean)object);
            }
            if (StringHelper.isNotBlank((Object)this.propertyNamePrefix)) {
                object4 = this.propertyNamePrefix + "." + (String)object4;
            }
            validationResult.addPropertyError((String)object4, string2);
        }
        return bl;
    }

    protected boolean appendValidation(RestBeanPropertyMapping restBeanPropertyMapping, FormatterImpl formatterImpl, ValidationResult validationResult, Object object) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        boolean bl = false;
        for (GeneralValidation object6 : this.getGeneralValidations()) {
            object5 = object6.validate(object);
            if (object5 == null) continue;
            object4 = this.resolveGeneralMessage(formatterImpl, (ValidationError)((Object)object5));
            validationResult.addGeneralError((String)object4);
            bl = true;
        }
        for (Property property : this.properties.values()) {
            if (this.appendPropertyValidations(restBeanPropertyMapping, formatterImpl, validationResult, property, object)) {
                bl = true;
            }
            if ((object5 = property.getNestedProperties()).isEmpty() || (object4 = property.getValue(object)) == null) continue;
            object3 = object5.iterator();
            while (object3.hasNext()) {
                object2 = (Property)object3.next();
                if (!this.appendPropertyValidations(restBeanPropertyMapping, formatterImpl, validationResult, (Property)object2, object4)) continue;
                bl = true;
            }
        }
        if (this.nested != null) {
            block3: for (Map.Entry entry : this.nested.entrySet()) {
                object5 = (PropertyAccess)entry.getKey();
                object4 = object5.get(object);
                object3 = (Validator)entry.getValue();
                object2 = IteratorUtils.getIterator((Object)object4);
                while (object2.hasNext()) {
                    Object e = object2.next();
                    if (!((Validator)object3).appendValidation(restBeanPropertyMapping, formatterImpl, validationResult, e)) continue;
                    bl = true;
                    continue block3;
                }
            }
        }
        return bl;
    }

    protected Property propertyInternal(PropertyAccess propertyAccess, Object object) {
        Object object2 = propertyAccess.getIdentifier();
        Property property = this.properties.get(object2);
        if (property == null) {
            property = new Property(propertyAccess, object);
            this.properties.put(object2, property);
        }
        return property;
    }

    protected String resolveDisplayName(FormatterImpl formatterImpl, Property property, Object object) {
        Object object2;
        Object object3 = ObjectHelper.defaultValue((Object)property.getDisplay(), (Object)property.getIdentifier());
        String string = formatterImpl.format(object3);
        Property property2 = property.getParent();
        if (property2 != null) {
            String string2 = this.resolveDisplayName(formatterImpl, property2, object);
            object2 = string2 + " (" + string + ")";
        } else {
            object2 = string;
        }
        if (this.propertyDisplayPrefix != null) {
            object2 = this.propertyDisplayPrefix + (String)object2;
        }
        return object2;
    }

    protected String resolveGeneralMessage(FormatterImpl formatterImpl, ValidationError validationError) {
        return formatterImpl.getTranslationHandler().message(validationError.getKey(), validationError.getArguments());
    }

    protected String resolvePropertyMessage(FormatterImpl formatterImpl, String string, ValidationError validationError) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        if (validationError.getArguments() != null) {
            CollectionUtils.addAll(arrayList, (Object[])validationError.getArguments());
        }
        Object[] objectArray = arrayList.toArray();
        if (validationError instanceof TextValidationError) {
            String string2 = ((TextValidationError)validationError).getText();
            return MessageFormat.format(string2, objectArray);
        }
        return formatterImpl.getTranslationHandler().message(validationError.getFormat(), validationError.getKey(), objectArray);
    }
}

