/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation.validations;

import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.utils.StringHelper;

public class PhoneValidation
implements PropertyValidation {
    private final ConfigurationAccessor configuration;
    private final PhoneNature expectedNature;

    public PhoneValidation(ConfigurationAccessor configurationAccessor, PhoneNature phoneNature) {
        this.configuration = configurationAccessor;
        this.expectedNature = phoneNature;
    }

    @Override
    public ValidationError validate(Object object, Object object2, Object object3) {
        String string = StringHelper.trimToNull((Object)object3);
        if (string == null) {
            return null;
        }
        boolean bl = InvocationContext.bean(PhoneNumberHandler.class).isValid(string, this.configuration, this.expectedNature);
        return bl ? null : this.getValidationError();
    }

    protected ValidationError getValidationError() {
        if (this.expectedNature == PhoneNature.LANDLINE) {
            return ValidationErrors.notLandlinePhone();
        }
        if (this.expectedNature == PhoneNature.MOBILE) {
            return ValidationErrors.notMobilePhone();
        }
        return ValidationErrors.invalid();
    }
}

