/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation.validations;

import java.math.BigDecimal;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.model.utils.ICurrencyAmount;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.utils.BigDecimalHelper;

public class SignalValidation
extends BasePropertyValidation {
    private final boolean positive;
    private final boolean allowZero;
    private final Integer scale;

    public SignalValidation(boolean bl, boolean bl2, Integer n, ValidationError validationError) {
        super(validationError);
        this.positive = bl;
        this.allowZero = bl2;
        this.scale = n;
    }

    @Override
    protected boolean isValid(Object object, Object object2, Object object3) {
        if (object3 instanceof BigDecimal) {
            BigDecimal bigDecimal = this.scale == null ? (BigDecimal)object3 : BigDecimalHelper.round((BigDecimal)((BigDecimal)object3), (int)this.scale);
            return this.allowZero && BigDecimalHelper.isZero((BigDecimal)bigDecimal) || this.positive && BigDecimalHelper.isPositive((BigDecimal)bigDecimal) || !this.positive && BigDecimalHelper.isNegative((BigDecimal)bigDecimal);
        }
        if (object3 instanceof Number) {
            return this.isValid(object, object2, new BigDecimal(((Number)object3).doubleValue()));
        }
        if (object3 instanceof ITimeInterval) {
            ITimeInterval iTimeInterval = (ITimeInterval)object3;
            return this.isValid(object, object2, iTimeInterval.getAmount());
        }
        if (object3 instanceof ICurrencyAmount) {
            ICurrencyAmount iCurrencyAmount = (ICurrencyAmount)object3;
            return this.isValid(object, object2, iCurrencyAmount.getAmount());
        }
        return false;
    }
}

