/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation.validations;

import org.cyclos.impl.utils.validation.TextValidationError;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.validations.RangeOptionalType;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.utils.MessageKey;

public class ValidationErrors {
    private static final ValidationError EMAIL = new ValidationError(GeneralKeys.Errors.EMAIL);
    private static final ValidationError INVALID = new ValidationError(GeneralKeys.Errors.INVALID);
    private static final ValidationError FUTURE_DATE = new ValidationError(GeneralKeys.Errors.FUTURE_DATE);
    private static final ValidationError PAST_DATE = new ValidationError(GeneralKeys.Errors.PAST_DATE);
    private static final ValidationError RANGE_OPTIONAL_LIMITS = new ValidationError(GeneralKeys.Errors.RANGE_OPTIONAL_LIMITS);
    private static final ValidationError RANGE_ONE_LIMIT_REQUIRED = new ValidationError(GeneralKeys.Errors.RANGE_ONE_LIMIT_REQUIRED);
    private static final ValidationError RANGE_BOTH_LIMITS_REQUIRED = new ValidationError(GeneralKeys.Errors.RANGE_BOTH_LIMITS_REQUIRED);
    private static final ValidationError PERIOD = new ValidationError(GeneralKeys.Errors.PERIOD);
    private static final ValidationError POSITIVE_OR_ZERO = new ValidationError(GeneralKeys.Errors.POSITIVE_OR_ZERO);
    private static final ValidationError POSITIVE_NON_ZERO = new ValidationError(GeneralKeys.Errors.POSITIVE_NON_ZERO);
    private static final ValidationError NEGATIVE_OR_ZERO = new ValidationError(GeneralKeys.Errors.NEGATIVE_OR_ZERO);
    private static final ValidationError NEGATIVE_NON_ZERO = new ValidationError(GeneralKeys.Errors.NEGATIVE_NON_ZERO);
    private static final ValidationError REQUIRED = new ValidationError(GeneralKeys.Errors.REQUIRED);
    private static final ValidationError UNIQUE = new ValidationError(GeneralKeys.Errors.UNIQUE);
    private static final ValidationError URL = new ValidationError(GeneralKeys.Errors.URL);
    private static final ValidationError CYCLE = new ValidationError(GeneralKeys.Errors.CYCLE);
    private static final ValidationError COLOR = new ValidationError(GeneralKeys.Errors.COLOR);
    private static final ValidationError NOT_LANDLINE_PHONE = new ValidationError(GeneralKeys.Errors.NOT_LANDLINE_PHONE);
    private static final ValidationError NOT_MOBILE_PHONE = new ValidationError(GeneralKeys.Errors.NOT_MOBILE_PHONE);
    private static final ValidationError NO_URL = new ValidationError(GeneralKeys.Errors.NO_URL);

    public static ValidationError child(MessageKey messageKey) {
        return new ValidationError(GeneralKeys.Errors.MISSING_PARENT, messageKey);
    }

    public static ValidationError color() {
        return COLOR;
    }

    public static ValidationError cycle() {
        return CYCLE;
    }

    public static ValidationError email() {
        return EMAIL;
    }

    public static ValidationError fixedLength(int n) {
        return new ValidationError(GeneralKeys.Errors.FIXED_LENGTH, n);
    }

    public static ValidationError futureDate() {
        return FUTURE_DATE;
    }

    public static ValidationError greaterEquals(Comparable<?> comparable) {
        return new ValidationError(GeneralKeys.Errors.GREATER_EQUALS, comparable);
    }

    public static ValidationError greaterThan(Comparable<?> comparable) {
        return new ValidationError(GeneralKeys.Errors.GREATER_THAN, comparable);
    }

    public static ValidationError invalid() {
        return INVALID;
    }

    public static ValidationError invalid(String string) {
        return new ValidationError(GeneralKeys.Errors.INVALID, string);
    }

    public static ValidationError lessEquals(Comparable<?> comparable) {
        return new ValidationError(GeneralKeys.Errors.LESS_EQUALS, comparable);
    }

    public static ValidationError lessThan(Comparable<?> comparable) {
        return new ValidationError(GeneralKeys.Errors.LESS_THAN, comparable);
    }

    public static ValidationError maxElements(int n) {
        return new ValidationError(GeneralKeys.Errors.MAX_ELEMENTS, n);
    }

    public static ValidationError maxLength(int n) {
        return new ValidationError(GeneralKeys.Errors.MAX_LENGTH, n);
    }

    public static ValidationError maxWordSize(int n) {
        return new ValidationError(GeneralKeys.Errors.MAX_WORD_SIZE, n);
    }

    public static ValidationError minElements(int n) {
        return new ValidationError(GeneralKeys.Errors.MIN_ELEMENTS, n);
    }

    public static ValidationError minLength(int n) {
        return new ValidationError(GeneralKeys.Errors.MIN_LENGTH, n);
    }

    public static ValidationError minMaskPlaceholders(int n) {
        return new ValidationError(GeneralKeys.Errors.MIN_MASK_PLACEHOLDERS, n, "#09aAlLuUcC?_");
    }

    public static ValidationError negativeNonZero() {
        return NEGATIVE_NON_ZERO;
    }

    public static ValidationError negativeOrZero() {
        return NEGATIVE_OR_ZERO;
    }

    public static ValidationError notLandlinePhone() {
        return NOT_LANDLINE_PHONE;
    }

    public static ValidationError notMobilePhone() {
        return NOT_MOBILE_PHONE;
    }

    public static ValidationError noUrl() {
        return NO_URL;
    }

    public static ValidationError pastDate() {
        return PAST_DATE;
    }

    public static ValidationError period() {
        return PERIOD;
    }

    public static ValidationError positiveNonZero() {
        return POSITIVE_NON_ZERO;
    }

    public static ValidationError positiveOrZero() {
        return POSITIVE_OR_ZERO;
    }

    public static ValidationError range(boolean bl) {
        return bl ? RANGE_OPTIONAL_LIMITS : RANGE_BOTH_LIMITS_REQUIRED;
    }

    public static ValidationError range(RangeOptionalType rangeOptionalType) {
        switch (rangeOptionalType) {
            case BOTH_OPTIONAL: {
                return RANGE_OPTIONAL_LIMITS;
            }
            case ONE_REQUIRED: {
                return RANGE_ONE_LIMIT_REQUIRED;
            }
            case BOTH_REQUIRED: {
                return RANGE_BOTH_LIMITS_REQUIRED;
            }
        }
        throw new IllegalStateException();
    }

    public static ValidationError required() {
        return REQUIRED;
    }

    public static TextValidationError text(String string) {
        return new TextValidationError(string);
    }

    public static ValidationError unique() {
        return UNIQUE;
    }

    public static ValidationError url() {
        return URL;
    }
}

