/*
 * Decompiled with CFR 0.152.
 */
package cn.danielw.fop;

import cn.danielw.fop.ObjectPool;

public class Poolable<T>
implements AutoCloseable {
    private final T object;
    private ObjectPool<T> pool;
    private final int partition;
    private long lastAccessTs;

    public Poolable(T t, ObjectPool<T> pool, int partition) {
        this.object = t;
        this.pool = pool;
        this.partition = partition;
        this.lastAccessTs = System.currentTimeMillis();
    }

    public T getObject() {
        return this.object;
    }

    public ObjectPool<T> getPool() {
        return this.pool;
    }

    public int getPartition() {
        return this.partition;
    }

    public void returnObject() {
        this.pool.returnObject(this);
    }

    public long getLastAccessTs() {
        return this.lastAccessTs;
    }

    public void setLastAccessTs(long lastAccessTs) {
        this.lastAccessTs = lastAccessTs;
    }

    @Override
    public void close() {
        this.returnObject();
    }
}

