/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.access;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.UserChannel;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="channels", indexes={@Index(name="ix_channel_internal_name", columnList="internal_name")})
public class Channel
extends ConfigurationEntity
implements DefinesNetwork,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id", nullable=true)
    private Network network;
    @OneToMany(mappedBy="channel", cascade={CascadeType.REMOVE})
    private Set<ChannelConfiguration> channelConfigurations = new HashSet<ChannelConfiguration>();
    @OneToMany(mappedBy="channel", cascade={CascadeType.REMOVE})
    private Set<UserChannel> users;
    @ManyToMany(mappedBy="channels")
    private Set<PaymentTransferType> paymentTypes;
    @ManyToMany(mappedBy="channels")
    private Set<CustomOperation> customOperations;
    @OneToMany(mappedBy="channel", cascade={CascadeType.REMOVE})
    private Set<Pin> pins;
    static final long serialVersionUID = -5586857516564948691L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.CHANNEL;
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public boolean isAllowOperations() {
        return this.isMain() || this.isService();
    }

    public boolean isCustom() {
        return BuiltInChannel.getByInternalName((String)this.getInternalName()) == null;
    }

    public boolean isEasyInvoice() {
        return BuiltInChannel.EASY_INVOICE.getInternalName().equals(this.getInternalName());
    }

    public boolean isMain() {
        return BuiltInChannel.MAIN.getInternalName().equals(this.getInternalName());
    }

    public boolean isMobile() {
        return BuiltInChannel.MOBILE.getInternalName().equals(this.getInternalName());
    }

    public boolean isOidc() {
        return BuiltInChannel.OIDC.getInternalName().equals(this.getInternalName());
    }

    public boolean isPay() {
        return this.isEasyInvoice() || this.isTicket();
    }

    public boolean isPos() {
        return BuiltInChannel.POS.getInternalName().equals(this.getInternalName());
    }

    public boolean isService() {
        return this.isMobile() || this.isWebServices() || this.isCustom();
    }

    public boolean isSms() {
        return BuiltInChannel.SMS.getInternalName().equals(this.getInternalName());
    }

    public boolean isStateful() {
        return this.isMain() || this.isService() || this.isPay();
    }

    public boolean isStateless() {
        return this.isSms() || this.isPos() || this.isOidc() || this.isService();
    }

    public boolean isTicket() {
        return BuiltInChannel.TICKET.getInternalName().equals(this.getInternalName());
    }

    public boolean isWebServices() {
        return BuiltInChannel.WEB_SERVICES.getInternalName().equals(this.getInternalName());
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Channel();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "channelConfigurations") {
            return this.channelConfigurations;
        }
        if (string == "customOperations") {
            return this.customOperations;
        }
        if (string == "pins") {
            return this.pins;
        }
        if (string == "paymentTypes") {
            return this.paymentTypes;
        }
        if (string == "users") {
            return this.users;
        }
        if (string == "network") {
            return this.network;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "channelConfigurations") {
            this.channelConfigurations = (Set)object;
            return;
        }
        if (string == "customOperations") {
            this.customOperations = (Set)object;
            return;
        }
        if (string == "pins") {
            this.pins = (Set)object;
            return;
        }
        if (string == "paymentTypes") {
            this.paymentTypes = (Set)object;
            return;
        }
        if (string == "users") {
            this.users = (Set)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_channelConfigurations() {
        this._persistence_checkFetched("channelConfigurations");
        return this.channelConfigurations;
    }

    public void _persistence_set_channelConfigurations(Set set) {
        this._persistence_checkFetchedForSet("channelConfigurations");
        this._persistence_propertyChange("channelConfigurations", this.channelConfigurations, set);
        this.channelConfigurations = set;
    }

    public Set _persistence_get_customOperations() {
        this._persistence_checkFetched("customOperations");
        return this.customOperations;
    }

    public void _persistence_set_customOperations(Set set) {
        this._persistence_checkFetchedForSet("customOperations");
        this._persistence_propertyChange("customOperations", this.customOperations, set);
        this.customOperations = set;
    }

    public Set _persistence_get_pins() {
        this._persistence_checkFetched("pins");
        return this.pins;
    }

    public void _persistence_set_pins(Set set) {
        this._persistence_checkFetchedForSet("pins");
        this._persistence_propertyChange("pins", this.pins, set);
        this.pins = set;
    }

    public Set _persistence_get_paymentTypes() {
        this._persistence_checkFetched("paymentTypes");
        return this.paymentTypes;
    }

    public void _persistence_set_paymentTypes(Set set) {
        this._persistence_checkFetchedForSet("paymentTypes");
        this._persistence_propertyChange("paymentTypes", this.paymentTypes, set);
        this.paymentTypes = set;
    }

    public Set _persistence_get_users() {
        this._persistence_checkFetched("users");
        return this.users;
    }

    public void _persistence_set_users(Set set) {
        this._persistence_checkFetchedForSet("users");
        this._persistence_propertyChange("users", this.users, set);
        this.users = set;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }
}

