/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.access;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.NFCTokenPrincipalType;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TokenPrincipalType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="NFC")
public class NFCToken
extends Token
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Basic(fetch=FetchType.LAZY)
    @Column(name="app_master_key")
    private byte[] amk;
    @Basic(fetch=FetchType.LAZY)
    @Column(name="app_master_key_iv")
    private byte[] amk_iv;
    @Basic(fetch=FetchType.LAZY)
    @Column(name="operational_key")
    private byte[] operationalKey;
    @Basic(fetch=FetchType.LAZY)
    @Column(name="operational_key_iv")
    private byte[] operationalKeyIv;
    @Basic(fetch=FetchType.LAZY)
    @Column(name="challenge")
    private byte[] challenge;
    @Basic
    @Column(name="label", nullable=true, length=50)
    @ReadOnlyFromDTO(onInsert=false)
    private String label;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="challenge_expiration", nullable=true)
    private Date challengeExpiration;
    static final long serialVersionUID = 859061665526080437L;

    public byte[] getAppMasterKey() {
        return this._persistence_get_amk();
    }

    public byte[] getAppMasterKeyIv() {
        return this._persistence_get_amk_iv();
    }

    public byte[] getChallenge() {
        return this._persistence_get_challenge();
    }

    public Date getChallengeExpiration() {
        return this._persistence_get_challengeExpiration();
    }

    public String getLabel() {
        return this._persistence_get_label();
    }

    public byte[] getOperationalKey() {
        return this._persistence_get_operationalKey();
    }

    public byte[] getOperationalKeyIv() {
        return this._persistence_get_operationalKeyIv();
    }

    @Override
    public String getPrincipal() {
        return null;
    }

    @Override
    public NFCTokenPrincipalType getType() {
        return (NFCTokenPrincipalType)super.getType();
    }

    public byte[] resetChallenge() {
        byte[] byArray = this._persistence_get_challenge();
        this.setChallenge(null);
        this.setChallengeExpiration(null);
        return byArray;
    }

    public void setAppMasterKey(byte[] byArray) {
        this._persistence_set_amk(byArray);
    }

    public void setAppMasterKeyIv(byte[] byArray) {
        this._persistence_set_amk_iv(byArray);
    }

    public void setChallenge(byte[] byArray) {
        this._persistence_set_challenge(byArray);
    }

    public void setChallengeExpiration(Date date) {
        this._persistence_set_challengeExpiration(date);
    }

    public void setLabel(String string) {
        this._persistence_set_label(string);
    }

    public void setOperationalKey(byte[] byArray) {
        this._persistence_set_operationalKey(byArray);
    }

    public void setOperationalKeyIv(byte[] byArray) {
        this._persistence_set_operationalKeyIv(byArray);
    }

    @Override
    public void setType(TokenPrincipalType tokenPrincipalType) {
        if (!(tokenPrincipalType instanceof NFCTokenPrincipalType)) {
            throw new IllegalArgumentException("Invalid token principal type for NFC token: " + tokenPrincipalType.getClass().getName());
        }
        super.setType(tokenPrincipalType);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new NFCToken();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "operationalKey") {
            return this.operationalKey;
        }
        if (string == "amk_iv") {
            return this.amk_iv;
        }
        if (string == "challengeExpiration") {
            return this.challengeExpiration;
        }
        if (string == "operationalKeyIv") {
            return this.operationalKeyIv;
        }
        if (string == "challenge") {
            return this.challenge;
        }
        if (string == "label") {
            return this.label;
        }
        if (string == "amk") {
            return this.amk;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "operationalKey") {
            this.operationalKey = (byte[])object;
            return;
        }
        if (string == "amk_iv") {
            this.amk_iv = (byte[])object;
            return;
        }
        if (string == "challengeExpiration") {
            this.challengeExpiration = (Date)object;
            return;
        }
        if (string == "operationalKeyIv") {
            this.operationalKeyIv = (byte[])object;
            return;
        }
        if (string == "challenge") {
            this.challenge = (byte[])object;
            return;
        }
        if (string == "label") {
            this.label = (String)object;
            return;
        }
        if (string == "amk") {
            this.amk = (byte[])object;
            return;
        }
        super._persistence_set(string, object);
    }

    public byte[] _persistence_get_operationalKey() {
        this._persistence_checkFetched("operationalKey");
        return this.operationalKey;
    }

    public void _persistence_set_operationalKey(byte[] byArray) {
        this._persistence_checkFetchedForSet("operationalKey");
        this._persistence_propertyChange("operationalKey", this.operationalKey, byArray);
        this.operationalKey = byArray;
    }

    public byte[] _persistence_get_amk_iv() {
        this._persistence_checkFetched("amk_iv");
        return this.amk_iv;
    }

    public void _persistence_set_amk_iv(byte[] byArray) {
        this._persistence_checkFetchedForSet("amk_iv");
        this._persistence_propertyChange("amk_iv", this.amk_iv, byArray);
        this.amk_iv = byArray;
    }

    public Date _persistence_get_challengeExpiration() {
        this._persistence_checkFetched("challengeExpiration");
        return this.challengeExpiration;
    }

    public void _persistence_set_challengeExpiration(Date date) {
        this._persistence_checkFetchedForSet("challengeExpiration");
        this._persistence_propertyChange("challengeExpiration", this.challengeExpiration, date);
        this.challengeExpiration = date;
    }

    public byte[] _persistence_get_operationalKeyIv() {
        this._persistence_checkFetched("operationalKeyIv");
        return this.operationalKeyIv;
    }

    public void _persistence_set_operationalKeyIv(byte[] byArray) {
        this._persistence_checkFetchedForSet("operationalKeyIv");
        this._persistence_propertyChange("operationalKeyIv", this.operationalKeyIv, byArray);
        this.operationalKeyIv = byArray;
    }

    public byte[] _persistence_get_challenge() {
        this._persistence_checkFetched("challenge");
        return this.challenge;
    }

    public void _persistence_set_challenge(byte[] byArray) {
        this._persistence_checkFetchedForSet("challenge");
        this._persistence_propertyChange("challenge", this.challenge, byArray);
        this.challenge = byArray;
    }

    public String _persistence_get_label() {
        this._persistence_checkFetched("label");
        return this.label;
    }

    public void _persistence_set_label(String string) {
        this._persistence_checkFetchedForSet("label");
        this._persistence_propertyChange("label", this.label, string);
        this.label = string;
    }

    public byte[] _persistence_get_amk() {
        this._persistence_checkFetched("amk");
        return this.amk;
    }

    public void _persistence_set_amk(byte[] byArray) {
        this._persistence_checkFetchedForSet("amk");
        this._persistence_propertyChange("amk", this.amk, byArray);
        this.amk = byArray;
    }
}

