/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.access;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.cyclos.entities.access.BaseOidcClient;
import org.cyclos.entities.access.OidcClientAccessor;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.ImageOwner;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.OidcClientImage;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.access.oidcclients.OidcClientNature;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="STATIC")
public class OidcClient
extends BaseOidcClient
implements ImageOwner<OidcClient, OidcClientImage>,
OidcClientAccessor,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ElementCollection
    @Column(name="scope")
    @Enumerated(value=EnumType.STRING)
    @CollectionTable(name="oidc_clients_scopes", joinColumns={@JoinColumn(name="client_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"client_id", "scope"})})
    private Set<Scope> scopes = new HashSet<Scope>();
    @ManyToMany
    @JoinTable(name="oidc_clients_accounts", joinColumns={@JoinColumn(name="client_id")}, inverseJoinColumns={@JoinColumn(name="account_type_id")})
    private Set<UserAccountType> accounts = new HashSet<UserAccountType>();
    @ManyToMany
    @JoinTable(name="oidc_clients_payments", joinColumns={@JoinColumn(name="client_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> payments = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="oidc_clients_tickets", joinColumns={@JoinColumn(name="client_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> tickets = new HashSet<PaymentTransferType>();
    @Basic
    @Column(name="single_payment_per_consent")
    private Boolean singlePaymentPerConsent;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="acc_token_exp_amount")), @AttributeOverride(name="field", column=@Column(name="acc_token_exp_field"))})
    private TimeInterval accessTokenExpiration;
    @Basic
    @Lob
    @Column(name="redirect_uris")
    private String redirectUris;
    @Basic
    @Column(name="website")
    private String website;
    @Basic
    @Column(name="privacy_policy_url")
    private String privacyPolicyUrl;
    @Basic
    @Column(name="terms_of_service_url")
    private String termsOfServiceUrl;
    @OneToMany(mappedBy="oidcClient")
    private Set<OidcClientImage> images;
    @Transient
    private TempImage uploadedImage;
    static final long serialVersionUID = -9135743077035716009L;

    @Override
    public TimeInterval getAccessTokenExpiration() {
        return this._persistence_get_accessTokenExpiration();
    }

    @Override
    public Set<UserAccountType> getAccounts() {
        return this._persistence_get_accounts();
    }

    @Override
    public OidcClientImage getImage() {
        return (OidcClientImage)CollectionHelper.first((Iterable)this._persistence_get_images());
    }

    @Override
    public OidcClientNature getNature() {
        return OidcClientNature.STATIC;
    }

    @Override
    public Set<PaymentTransferType> getPayments() {
        return this._persistence_get_payments();
    }

    @Override
    public Set<Scope> getScopes() {
        return this._persistence_get_scopes();
    }

    @Override
    public Set<PaymentTransferType> getTickets() {
        return this._persistence_get_tickets();
    }

    public TempImage getUploadedImage() {
        return this.uploadedImage;
    }

    @Override
    public boolean isSinglePaymentPerConsent() {
        return Boolean.TRUE.equals(this._persistence_get_singlePaymentPerConsent());
    }

    public void setAccessTokenExpiration(TimeInterval timeInterval) {
        this._persistence_set_accessTokenExpiration(timeInterval);
    }

    public void setAccounts(Set<UserAccountType> set) {
        this._persistence_set_accounts(set);
    }

    @Override
    public void setImage(OidcClientImage oidcClientImage) {
        this._persistence_set_images(CollectionHelper.asSet((Object[])new OidcClientImage[]{oidcClientImage}));
    }

    public void setPayments(Set<PaymentTransferType> set) {
        this._persistence_set_payments(set);
    }

    public void setScopes(Set<Scope> set) {
        this._persistence_set_scopes(set);
    }

    public void setSinglePaymentPerConsent(boolean bl) {
        this._persistence_set_singlePaymentPerConsent(bl);
    }

    public void setTickets(Set<PaymentTransferType> set) {
        this._persistence_set_tickets(set);
    }

    public void setUploadedImage(TempImage tempImage) {
        this.uploadedImage = tempImage;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new OidcClient();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "images") {
            return this.images;
        }
        if (string == "tickets") {
            return this.tickets;
        }
        if (string == "accessTokenExpiration") {
            return this.accessTokenExpiration;
        }
        if (string == "payments") {
            return this.payments;
        }
        if (string == "scopes") {
            return this.scopes;
        }
        if (string == "accounts") {
            return this.accounts;
        }
        if (string == "singlePaymentPerConsent") {
            return this.singlePaymentPerConsent;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "images") {
            this.images = (Set)object;
            return;
        }
        if (string == "tickets") {
            this.tickets = (Set)object;
            return;
        }
        if (string == "accessTokenExpiration") {
            this.accessTokenExpiration = (TimeInterval)object;
            return;
        }
        if (string == "payments") {
            this.payments = (Set)object;
            return;
        }
        if (string == "scopes") {
            this.scopes = (Set)object;
            return;
        }
        if (string == "accounts") {
            this.accounts = (Set)object;
            return;
        }
        if (string == "singlePaymentPerConsent") {
            this.singlePaymentPerConsent = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_images() {
        this._persistence_checkFetched("images");
        return this.images;
    }

    public void _persistence_set_images(Set set) {
        this._persistence_checkFetchedForSet("images");
        this._persistence_propertyChange("images", this.images, set);
        this.images = set;
    }

    public Set _persistence_get_tickets() {
        this._persistence_checkFetched("tickets");
        return this.tickets;
    }

    public void _persistence_set_tickets(Set set) {
        this._persistence_checkFetchedForSet("tickets");
        this._persistence_propertyChange("tickets", this.tickets, set);
        this.tickets = set;
    }

    public TimeInterval _persistence_get_accessTokenExpiration() {
        this._persistence_checkFetched("accessTokenExpiration");
        return this.accessTokenExpiration;
    }

    public void _persistence_set_accessTokenExpiration(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("accessTokenExpiration");
        this._persistence_propertyChange("accessTokenExpiration", this.accessTokenExpiration, timeInterval);
        this.accessTokenExpiration = timeInterval;
    }

    public Set _persistence_get_payments() {
        this._persistence_checkFetched("payments");
        return this.payments;
    }

    public void _persistence_set_payments(Set set) {
        this._persistence_checkFetchedForSet("payments");
        this._persistence_propertyChange("payments", this.payments, set);
        this.payments = set;
    }

    public Set _persistence_get_scopes() {
        this._persistence_checkFetched("scopes");
        return this.scopes;
    }

    public void _persistence_set_scopes(Set set) {
        this._persistence_checkFetchedForSet("scopes");
        this._persistence_propertyChange("scopes", this.scopes, set);
        this.scopes = set;
    }

    public Set _persistence_get_accounts() {
        this._persistence_checkFetched("accounts");
        return this.accounts;
    }

    public void _persistence_set_accounts(Set set) {
        this._persistence_checkFetchedForSet("accounts");
        this._persistence_propertyChange("accounts", this.accounts, set);
        this.accounts = set;
    }

    public Boolean _persistence_get_singlePaymentPerConsent() {
        this._persistence_checkFetched("singlePaymentPerConsent");
        return this.singlePaymentPerConsent;
    }

    public void _persistence_set_singlePaymentPerConsent(Boolean bl) {
        this._persistence_checkFetchedForSet("singlePaymentPerConsent");
        this._persistence_propertyChange("singlePaymentPerConsent", this.singlePaymentPerConsent, bl);
        this.singlePaymentPerConsent = bl;
    }
}

