/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.access.BaseOidcClient;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.entities.banking.InternalTransaction;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.TransactionAuthorization;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.TransactionFeedback;
import org.cyclos.entities.users.User;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationType;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
public abstract class BasePayment
extends InternalTransaction
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oidc_client_id")
    private BaseOidcClient oidcClient;
    @OneToMany(mappedBy="transaction")
    private Set<TransactionFeedback> feedbacks;
    @Basic
    @Column(name="transaction_feedback_reminder_notified")
    private Boolean feedbackReminderNotified = false;
    @Basic
    @Column(name="transaction_feedback_expiration_reminder_notified")
    private Boolean feedbackExpirationReminderNotified = false;
    @Basic
    @Column(name="transaction_feedback_expiration_notified")
    private Boolean feedbackExpirationNotified = false;
    @OneToMany(mappedBy="transaction", cascade={CascadeType.REMOVE})
    @OrderBy(value="date desc")
    private List<TransactionAuthorization> authorizations = new ArrayList<TransactionAuthorization>();
    @OneToMany(mappedBy="transaction")
    private Set<PaymentRequest> paymentRequests;
    static final long serialVersionUID = 497124539902083625L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_oidcClient_vh;

    public List<TransactionAuthorization> getAuthorizations() {
        return this._persistence_get_authorizations();
    }

    public TransactionAuthorizationStatus getAuthorizationStatus() {
        return this._persistence_get_authorizationStatus() == TransactionAuthorizationStatus.NA ? null : this._persistence_get_authorizationStatus();
    }

    public TransactionAuthorizationType getAuthorizationType() {
        return this._persistence_get_authorizationType() == TransactionAuthorizationType.NA ? null : this._persistence_get_authorizationType();
    }

    public PaymentCreationType getCreationType() {
        return this._persistence_get_creationType();
    }

    public TransactionFeedback getFeedback() {
        return (TransactionFeedback)CollectionHelper.first((Iterable)this._persistence_get_feedbacks());
    }

    public Boolean getFeedbackExpirationNotified() {
        return this._persistence_get_feedbackExpirationNotified();
    }

    public Boolean getFeedbackExpirationReminderNotified() {
        return this._persistence_get_feedbackExpirationReminderNotified();
    }

    public Boolean getFeedbackReminderNotified() {
        return this._persistence_get_feedbackReminderNotified();
    }

    public AuthorizationLevel getNextAuthorizationLevel() {
        return this._persistence_get_nextAuthorizationLevel();
    }

    public BaseOidcClient getOidcClient() {
        return this._persistence_get_oidcClient();
    }

    public PaymentRequest getPaymentRequest() {
        return (PaymentRequest)CollectionHelper.first((Iterable)this._persistence_get_paymentRequests());
    }

    public PaymentTransferType getPaymentType() {
        return (PaymentTransferType)this.getType();
    }

    @Override
    public Date getProcessDate() {
        TransactionAuthorizationStatus transactionAuthorizationStatus = this.getAuthorizationStatus();
        if (transactionAuthorizationStatus == null) {
            return this.getDate();
        }
        if (transactionAuthorizationStatus != TransactionAuthorizationStatus.AUTHORIZED) {
            return null;
        }
        return ((TransactionAuthorization)CollectionHelper.first((Iterable)this._persistence_get_authorizations())).getDate();
    }

    public Operator getReceivedBy() {
        return this._persistence_get_receivedBy();
    }

    @Override
    public BasicUser getReceiver() {
        User user = this.getToUser();
        if (this._persistence_get_receivedBy() != null && this._persistence_get_receivedBy().getUser().equals(user)) {
            return this._persistence_get_receivedBy();
        }
        return user;
    }

    public boolean isAuthorized() {
        return this._persistence_get_authorizationStatus() == TransactionAuthorizationStatus.NA || this._persistence_get_authorizationStatus() == TransactionAuthorizationStatus.AUTHORIZED;
    }

    public boolean isPendingAuthorization() {
        return this._persistence_get_authorizationStatus() == TransactionAuthorizationStatus.PENDING_AUTHORIZATION;
    }

    public boolean isReceived() {
        return this._persistence_get_creationType() != null && this._persistence_get_creationType().isInverse();
    }

    public void setAuthorizations(List<TransactionAuthorization> list) {
        this._persistence_set_authorizations(list);
    }

    public void setAuthorizationStatus(TransactionAuthorizationStatus transactionAuthorizationStatus) {
        this._persistence_set_authorizationStatus((TransactionAuthorizationStatus)ObjectHelper.defaultValue((Object)transactionAuthorizationStatus, (Object)TransactionAuthorizationStatus.NA));
    }

    public void setAuthorizationType(TransactionAuthorizationType transactionAuthorizationType) {
        this._persistence_set_authorizationType((TransactionAuthorizationType)ObjectHelper.defaultValue((Object)transactionAuthorizationType, (Object)TransactionAuthorizationType.NA));
    }

    public void setCreationType(PaymentCreationType paymentCreationType) {
        this._persistence_set_creationType(paymentCreationType);
    }

    public void setFeedback(TransactionFeedback transactionFeedback) {
        this._persistence_set_feedbacks(CollectionHelper.asSet((Object[])new TransactionFeedback[]{transactionFeedback}));
    }

    public void setFeedbackExpirationNotified(Boolean bl) {
        this._persistence_set_feedbackExpirationNotified(bl);
    }

    public void setFeedbackExpirationReminderNotified(Boolean bl) {
        this._persistence_set_feedbackExpirationReminderNotified(bl);
    }

    public void setFeedbackReminderNotified(Boolean bl) {
        this._persistence_set_feedbackReminderNotified(bl);
    }

    public void setNextAuthorizationLevel(AuthorizationLevel authorizationLevel) {
        this._persistence_set_nextAuthorizationLevel(authorizationLevel);
    }

    public void setOidcClient(BaseOidcClient baseOidcClient) {
        this._persistence_set_oidcClient(baseOidcClient);
    }

    public void setPaymentRequest(PaymentRequest paymentRequest) {
        this._persistence_set_paymentRequests(CollectionHelper.asSet((Object[])new PaymentRequest[]{paymentRequest}));
    }

    public void setPaymentType(PaymentTransferType paymentTransferType) {
        this.setType(paymentTransferType);
    }

    public void setReceivedBy(Operator operator) {
        this._persistence_set_receivedBy(operator);
    }

    @Override
    public void setType(TransferType transferType) {
        if (transferType != null && !(transferType instanceof PaymentTransferType)) {
            throw new IllegalArgumentException("Invalid type. Expected: " + PaymentTransferType.class.getName());
        }
        super.setType(transferType);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_oidcClient_vh != null) {
            this._persistence_oidcClient_vh = (WeavedAttributeValueHolderInterface)this._persistence_oidcClient_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new BasePayment();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "feedbackReminderNotified") {
            return this.feedbackReminderNotified;
        }
        if (string == "paymentRequests") {
            return this.paymentRequests;
        }
        if (string == "authorizations") {
            return this.authorizations;
        }
        if (string == "feedbackExpirationReminderNotified") {
            return this.feedbackExpirationReminderNotified;
        }
        if (string == "feedbackExpirationNotified") {
            return this.feedbackExpirationNotified;
        }
        if (string == "feedbacks") {
            return this.feedbacks;
        }
        if (string == "oidcClient") {
            return this.oidcClient;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "feedbackReminderNotified") {
            this.feedbackReminderNotified = (Boolean)object;
            return;
        }
        if (string == "paymentRequests") {
            this.paymentRequests = (Set)object;
            return;
        }
        if (string == "authorizations") {
            this.authorizations = (List)object;
            return;
        }
        if (string == "feedbackExpirationReminderNotified") {
            this.feedbackExpirationReminderNotified = (Boolean)object;
            return;
        }
        if (string == "feedbackExpirationNotified") {
            this.feedbackExpirationNotified = (Boolean)object;
            return;
        }
        if (string == "feedbacks") {
            this.feedbacks = (Set)object;
            return;
        }
        if (string == "oidcClient") {
            this.oidcClient = (BaseOidcClient)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Boolean _persistence_get_feedbackReminderNotified() {
        this._persistence_checkFetched("feedbackReminderNotified");
        return this.feedbackReminderNotified;
    }

    public void _persistence_set_feedbackReminderNotified(Boolean bl) {
        this._persistence_checkFetchedForSet("feedbackReminderNotified");
        this._persistence_propertyChange("feedbackReminderNotified", this.feedbackReminderNotified, bl);
        this.feedbackReminderNotified = bl;
    }

    public Set _persistence_get_paymentRequests() {
        this._persistence_checkFetched("paymentRequests");
        return this.paymentRequests;
    }

    public void _persistence_set_paymentRequests(Set set) {
        this._persistence_checkFetchedForSet("paymentRequests");
        this._persistence_propertyChange("paymentRequests", this.paymentRequests, set);
        this.paymentRequests = set;
    }

    public List _persistence_get_authorizations() {
        this._persistence_checkFetched("authorizations");
        return this.authorizations;
    }

    public void _persistence_set_authorizations(List list) {
        this._persistence_checkFetchedForSet("authorizations");
        this._persistence_propertyChange("authorizations", this.authorizations, list);
        this.authorizations = list;
    }

    public Boolean _persistence_get_feedbackExpirationReminderNotified() {
        this._persistence_checkFetched("feedbackExpirationReminderNotified");
        return this.feedbackExpirationReminderNotified;
    }

    public void _persistence_set_feedbackExpirationReminderNotified(Boolean bl) {
        this._persistence_checkFetchedForSet("feedbackExpirationReminderNotified");
        this._persistence_propertyChange("feedbackExpirationReminderNotified", this.feedbackExpirationReminderNotified, bl);
        this.feedbackExpirationReminderNotified = bl;
    }

    public Boolean _persistence_get_feedbackExpirationNotified() {
        this._persistence_checkFetched("feedbackExpirationNotified");
        return this.feedbackExpirationNotified;
    }

    public void _persistence_set_feedbackExpirationNotified(Boolean bl) {
        this._persistence_checkFetchedForSet("feedbackExpirationNotified");
        this._persistence_propertyChange("feedbackExpirationNotified", this.feedbackExpirationNotified, bl);
        this.feedbackExpirationNotified = bl;
    }

    public Set _persistence_get_feedbacks() {
        this._persistence_checkFetched("feedbacks");
        return this.feedbacks;
    }

    public void _persistence_set_feedbacks(Set set) {
        this._persistence_checkFetchedForSet("feedbacks");
        this._persistence_propertyChange("feedbacks", this.feedbacks, set);
        this.feedbacks = set;
    }

    protected void _persistence_initialize_oidcClient_vh() {
        if (this._persistence_oidcClient_vh == null) {
            this._persistence_oidcClient_vh = new ValueHolder((Object)this.oidcClient);
            this._persistence_oidcClient_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_oidcClient_vh() {
        BaseOidcClient baseOidcClient;
        this._persistence_initialize_oidcClient_vh();
        if ((this._persistence_oidcClient_vh.isCoordinatedWithProperty() || this._persistence_oidcClient_vh.isNewlyWeavedValueHolder()) && (baseOidcClient = this._persistence_get_oidcClient()) != this._persistence_oidcClient_vh.getValue()) {
            this._persistence_set_oidcClient(baseOidcClient);
        }
        return this._persistence_oidcClient_vh;
    }

    public void _persistence_set_oidcClient_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_oidcClient_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BaseOidcClient baseOidcClient = this._persistence_get_oidcClient();
            if (baseOidcClient != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_oidcClient((BaseOidcClient)object);
            }
        } else {
            this.oidcClient = null;
        }
    }

    public BaseOidcClient _persistence_get_oidcClient() {
        this._persistence_checkFetched("oidcClient");
        this._persistence_initialize_oidcClient_vh();
        this.oidcClient = (BaseOidcClient)this._persistence_oidcClient_vh.getValue();
        return this.oidcClient;
    }

    public void _persistence_set_oidcClient(BaseOidcClient baseOidcClient) {
        this._persistence_checkFetchedForSet("oidcClient");
        this._persistence_initialize_oidcClient_vh();
        this.oidcClient = (BaseOidcClient)this._persistence_oidcClient_vh.getValue();
        this._persistence_propertyChange("oidcClient", this.oidcClient, baseOidcClient);
        this.oidcClient = baseOidcClient;
        this._persistence_oidcClient_vh.setValue((Object)baseOidcClient);
    }
}

