/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import org.cyclos.entities.EntityFormatter;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.BuiltinPrincipalTypeResolver;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;

public interface IUserAccount
extends IAccount,
UserPrincipal {
    @Override
    default public AccessClient getAccessClient() {
        return null;
    }

    @Override
    default public UserAccountType getAccountType() {
        return this.getType();
    }

    @Override
    default public BasicUser getBasicUser() {
        return this.getUser();
    }

    @Override
    default public UserCustomFieldValue getCustomFieldValue() {
        return null;
    }

    @Override
    default public MobilePhone getMobilePhone() {
        return null;
    }

    default public Date getNegativeSince() {
        return null;
    }

    default public User getOwner() {
        return this.getUser();
    }

    public BigDecimal getPaymentAmountLimit();

    public BigDecimal getPaymentAmountPerDayLimit();

    public BigDecimal getPaymentAmountPerMonthLimit();

    public BigDecimal getPaymentAmountPerWeekLimit();

    public BigDecimal getPaymentAmountPerYearLimit();

    @Override
    default public String getPrincipal() {
        return EntityFormatter.get().formatAccountNumber(this);
    }

    @Override
    default public PrincipalType getPrincipalType() {
        return BuiltinPrincipalTypeResolver.resolve(ExistingBuiltInPrincipalType.ACCOUNT_NUMBER);
    }

    @Override
    default public Token getToken() {
        return null;
    }

    @Override
    default public TrustedDevice getTrustedDevice() {
        return null;
    }

    @Override
    public UserAccountType getType();

    public User getUser();

    public boolean isActive();

    default public boolean isCreditLimitFromProduct() {
        return this.getCreditLimit() == null;
    }

    public boolean isUpperCreditLimitFromProduct();

    public void setActive(boolean var1);
}

