/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.util.Collections;
import java.util.Set;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.PaymentTransfer;
import org.cyclos.entities.banking.VoucherPack;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.utils.Location;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="PAYMENT")
public class Payment
extends BasePayment
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @OneToMany(mappedBy="transaction")
    private Set<PaymentTransfer> transfers;
    @OneToMany(mappedBy="buy")
    private Set<VoucherPack> boughtVoucherPacks;
    @Transient
    private boolean sendNotifications = true;
    static final long serialVersionUID = 2313383471653658644L;

    public VoucherPack getBoughtVoucherPack() {
        if (!this.isFromUser() || !this.isToSystem()) {
            return null;
        }
        return (VoucherPack)CollectionHelper.first((Iterable)this._persistence_get_boughtVoucherPacks());
    }

    @Override
    public Location getLocation() {
        return Location.PAYMENT;
    }

    @Override
    public TransactionNature getNature() {
        return TransactionNature.PAYMENT;
    }

    public PaymentTransfer getTransfer() {
        return (PaymentTransfer)CollectionHelper.first((Iterable)this._persistence_get_transfers());
    }

    public Long getTransferId() {
        return SimpleEntity.id(this.getTransfer());
    }

    public boolean isSendNotifications() {
        return this.sendNotifications;
    }

    public void setBoughtVoucherPack(VoucherPack voucherPack) {
        this._persistence_set_boughtVoucherPacks(voucherPack == null ? Collections.emptySet() : Collections.singleton(voucherPack));
    }

    public void setSendNotifications(boolean bl) {
        this.sendNotifications = bl;
    }

    public void setTransfer(PaymentTransfer paymentTransfer) {
        this._persistence_set_transfers(this._persistence_get_transfers() == null ? Collections.emptySet() : Collections.singleton(paymentTransfer));
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Payment();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "boughtVoucherPacks") {
            return this.boughtVoucherPacks;
        }
        if (string == "transfers") {
            return this.transfers;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "boughtVoucherPacks") {
            this.boughtVoucherPacks = (Set)object;
            return;
        }
        if (string == "transfers") {
            this.transfers = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_boughtVoucherPacks() {
        this._persistence_checkFetched("boughtVoucherPacks");
        return this.boughtVoucherPacks;
    }

    public void _persistence_set_boughtVoucherPacks(Set set) {
        this._persistence_checkFetchedForSet("boughtVoucherPacks");
        this._persistence_propertyChange("boughtVoucherPacks", this.boughtVoucherPacks, set);
        this.boughtVoucherPacks = set;
    }

    public Set _persistence_get_transfers() {
        this._persistence_checkFetched("transfers");
        return this.transfers;
    }

    public void _persistence_set_transfers(Set set) {
        this._persistence_checkFetchedForSet("transfers");
        this._persistence_propertyChange("transfers", this.transfers, set);
        this.transfers = set;
    }
}

