/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.util.Date;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.HasExpirationDate;
import org.cyclos.entities.banking.InternalTransaction;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.banking.transactions.HasTransactionStatus;
import org.cyclos.model.banking.transactions.PaymentRequestStatus;
import org.cyclos.model.banking.transactions.SchedulingType;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.utils.Location;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="PAYMENT_REQUEST")
public class PaymentRequest
extends InternalTransaction
implements HasTransactionStatus<PaymentRequestStatus>,
HasExpirationDate,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Basic
    @Lob
    @Column(name="expiration_date_comments")
    private String expirationDateComments;
    @Basic
    @Lob
    @Column(name="comments")
    private String comments;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="scheduling")
    private SchedulingType scheduling;
    @Basic
    @Column(name="sms_code")
    private String smsCode;
    @Basic
    @Column(name="first_scheduling_immediate")
    private Boolean firstSchedulingIsImmediate;
    @Basic
    @Column(name="scheduling_count")
    private Integer schedulingCount;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="occurrence_interval_amount")), @AttributeOverride(name="field", column=@Column(name="occurrence_interval_field"))})
    private TimeInterval occurrenceInterval;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="process_date")
    private Date processDate;
    static final long serialVersionUID = 3305024369640643325L;

    public String getComments() {
        return this._persistence_get_comments();
    }

    @Override
    public Date getExpirationDate() {
        return this._persistence_get_expirationDate();
    }

    public String getExpirationDateComments() {
        return this._persistence_get_expirationDateComments();
    }

    @Override
    public Location getLocation() {
        return Location.PAYMENT_REQUEST;
    }

    @Override
    public TransactionNature getNature() {
        return TransactionNature.PAYMENT_REQUEST;
    }

    public TimeInterval getOccurrenceInterval() {
        return this._persistence_get_occurrenceInterval();
    }

    @Override
    public Date getProcessDate() {
        return this._persistence_get_processDate() != null ? this._persistence_get_processDate() : (this._persistence_get_transaction() == null ? null : this._persistence_get_transaction().getDate());
    }

    public SchedulingType getScheduling() {
        return this._persistence_get_scheduling();
    }

    public Integer getSchedulingCount() {
        return this._persistence_get_schedulingCount();
    }

    public String getSmsCode() {
        return this._persistence_get_smsCode();
    }

    public PaymentRequestStatus getStatus() {
        return PaymentRequestStatus.valueOf((String)this._persistence_get_status());
    }

    public BasePayment getTransaction() {
        return (BasePayment)this._persistence_get_transaction();
    }

    public boolean isFirstSchedulingIsImmediate() {
        return Boolean.TRUE.equals(this._persistence_get_firstSchedulingIsImmediate());
    }

    public void setComments(String string) {
        this._persistence_set_comments(string);
    }

    @Override
    public void setExpirationDate(Date date) {
        this._persistence_set_expirationDate(date);
    }

    public void setExpirationDateComments(String string) {
        this._persistence_set_expirationDateComments(string);
    }

    public void setFirstSchedulingIsImmediate(Boolean bl) {
        this._persistence_set_firstSchedulingIsImmediate(bl);
    }

    public void setOccurrenceInterval(TimeInterval timeInterval) {
        this._persistence_set_occurrenceInterval(timeInterval);
    }

    public void setProcessDate(Date date) {
        this._persistence_set_processDate(date);
    }

    public void setScheduling(SchedulingType schedulingType) {
        this._persistence_set_scheduling(schedulingType);
    }

    public void setSchedulingCount(Integer n) {
        this._persistence_set_schedulingCount(n);
    }

    public void setSmsCode(String string) {
        this._persistence_set_smsCode(string);
    }

    public void setStatus(PaymentRequestStatus paymentRequestStatus) {
        this._persistence_set_status(paymentRequestStatus.name());
    }

    public void setTransaction(BasePayment basePayment) {
        this._persistence_set_transaction(basePayment);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new PaymentRequest();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "comments") {
            return this.comments;
        }
        if (string == "smsCode") {
            return this.smsCode;
        }
        if (string == "schedulingCount") {
            return this.schedulingCount;
        }
        if (string == "processDate") {
            return this.processDate;
        }
        if (string == "scheduling") {
            return this.scheduling;
        }
        if (string == "firstSchedulingIsImmediate") {
            return this.firstSchedulingIsImmediate;
        }
        if (string == "expirationDateComments") {
            return this.expirationDateComments;
        }
        if (string == "occurrenceInterval") {
            return this.occurrenceInterval;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "comments") {
            this.comments = (String)object;
            return;
        }
        if (string == "smsCode") {
            this.smsCode = (String)object;
            return;
        }
        if (string == "schedulingCount") {
            this.schedulingCount = (Integer)object;
            return;
        }
        if (string == "processDate") {
            this.processDate = (Date)object;
            return;
        }
        if (string == "scheduling") {
            this.scheduling = (SchedulingType)object;
            return;
        }
        if (string == "firstSchedulingIsImmediate") {
            this.firstSchedulingIsImmediate = (Boolean)object;
            return;
        }
        if (string == "expirationDateComments") {
            this.expirationDateComments = (String)object;
            return;
        }
        if (string == "occurrenceInterval") {
            this.occurrenceInterval = (TimeInterval)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_comments() {
        this._persistence_checkFetched("comments");
        return this.comments;
    }

    public void _persistence_set_comments(String string) {
        this._persistence_checkFetchedForSet("comments");
        this._persistence_propertyChange("comments", this.comments, string);
        this.comments = string;
    }

    public String _persistence_get_smsCode() {
        this._persistence_checkFetched("smsCode");
        return this.smsCode;
    }

    public void _persistence_set_smsCode(String string) {
        this._persistence_checkFetchedForSet("smsCode");
        this._persistence_propertyChange("smsCode", this.smsCode, string);
        this.smsCode = string;
    }

    public Integer _persistence_get_schedulingCount() {
        this._persistence_checkFetched("schedulingCount");
        return this.schedulingCount;
    }

    public void _persistence_set_schedulingCount(Integer n) {
        this._persistence_checkFetchedForSet("schedulingCount");
        this._persistence_propertyChange("schedulingCount", this.schedulingCount, n);
        this.schedulingCount = n;
    }

    public Date _persistence_get_processDate() {
        this._persistence_checkFetched("processDate");
        return this.processDate;
    }

    public void _persistence_set_processDate(Date date) {
        this._persistence_checkFetchedForSet("processDate");
        this._persistence_propertyChange("processDate", this.processDate, date);
        this.processDate = date;
    }

    public SchedulingType _persistence_get_scheduling() {
        this._persistence_checkFetched("scheduling");
        return this.scheduling;
    }

    public void _persistence_set_scheduling(SchedulingType schedulingType) {
        this._persistence_checkFetchedForSet("scheduling");
        this._persistence_propertyChange("scheduling", this.scheduling, schedulingType);
        this.scheduling = schedulingType;
    }

    public Boolean _persistence_get_firstSchedulingIsImmediate() {
        this._persistence_checkFetched("firstSchedulingIsImmediate");
        return this.firstSchedulingIsImmediate;
    }

    public void _persistence_set_firstSchedulingIsImmediate(Boolean bl) {
        this._persistence_checkFetchedForSet("firstSchedulingIsImmediate");
        this._persistence_propertyChange("firstSchedulingIsImmediate", this.firstSchedulingIsImmediate, bl);
        this.firstSchedulingIsImmediate = bl;
    }

    public String _persistence_get_expirationDateComments() {
        this._persistence_checkFetched("expirationDateComments");
        return this.expirationDateComments;
    }

    public void _persistence_set_expirationDateComments(String string) {
        this._persistence_checkFetchedForSet("expirationDateComments");
        this._persistence_propertyChange("expirationDateComments", this.expirationDateComments, string);
        this.expirationDateComments = string;
    }

    public TimeInterval _persistence_get_occurrenceInterval() {
        this._persistence_checkFetched("occurrenceInterval");
        return this.occurrenceInterval;
    }

    public void _persistence_set_occurrenceInterval(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("occurrenceInterval");
        this._persistence_propertyChange("occurrenceInterval", this.occurrenceInterval, timeInterval);
        this.occurrenceInterval = timeInterval;
    }
}

