/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.util.Date;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import org.cyclos.entities.banking.HasExpirationDate;
import org.cyclos.entities.banking.InternalTransaction;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.TicketAmountReservation;
import org.cyclos.entities.users.User;
import org.cyclos.model.banking.transactions.HasTransactionStatus;
import org.cyclos.model.banking.transactions.TicketStatus;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.utils.Location;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="TICKET")
public class Ticket
extends InternalTransaction
implements HasTransactionStatus<TicketStatus>,
HasExpirationDate,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="ticket_number")
    private String ticketNumber;
    @Basic
    @Column(name="success_url")
    private String successUrl;
    @Basic
    @Column(name="cancel_url")
    private String cancelUrl;
    @Basic
    @Column(name="success_webhook_url")
    private String successWebhookUrl;
    @Basic
    @Column(name="ticket_order_id")
    private String orderId;
    @OneToMany(mappedBy="transaction")
    private Set<TicketAmountReservation> amountReservations;
    static final long serialVersionUID = -3016339464081630847L;

    public Set<TicketAmountReservation> getAmountReservations() {
        return this._persistence_get_amountReservations();
    }

    public String getCancelUrl() {
        return this._persistence_get_cancelUrl();
    }

    @Override
    public Date getExpirationDate() {
        return this._persistence_get_expirationDate();
    }

    @Override
    public Location getLocation() {
        return Location.TICKET;
    }

    @Override
    public TransactionNature getNature() {
        return TransactionNature.TICKET;
    }

    public String getOrderId() {
        return this._persistence_get_orderId();
    }

    public User getPayee() {
        return this.getToUser();
    }

    public User getPayer() {
        return this.getFromUser();
    }

    public Payment getPayment() {
        return (Payment)this._persistence_get_transaction();
    }

    public TicketStatus getPersistedStatus() {
        return TicketStatus.valueOf((String)this._persistence_get_status());
    }

    @Override
    public Date getProcessDate() {
        return this._persistence_get_transaction() == null ? null : this._persistence_get_transaction().getDate();
    }

    public TicketStatus getStatus() {
        TicketStatus ticketStatus = this.getPersistedStatus();
        if (ticketStatus == TicketStatus.OPEN && this._persistence_get_expirationDate() != null && this._persistence_get_expirationDate().before(new Date())) {
            return TicketStatus.EXPIRED;
        }
        return ticketStatus;
    }

    public String getSuccessUrl() {
        return this._persistence_get_successUrl();
    }

    public String getSuccessWebhookUrl() {
        return this._persistence_get_successWebhookUrl();
    }

    public String getTicketNumber() {
        return this._persistence_get_ticketNumber();
    }

    public void setAmountReservations(Set<TicketAmountReservation> set) {
        this._persistence_set_amountReservations(set);
    }

    public void setCancelUrl(String string) {
        this._persistence_set_cancelUrl(string);
    }

    @Override
    public void setExpirationDate(Date date) {
        this._persistence_set_expirationDate(date);
    }

    public void setOrderId(String string) {
        this._persistence_set_orderId(string);
    }

    public void setPayment(Payment payment) {
        this._persistence_set_transaction(payment);
    }

    public void setStatus(TicketStatus ticketStatus) {
        this._persistence_set_status(ticketStatus.name());
    }

    public void setSuccessUrl(String string) {
        this._persistence_set_successUrl(string);
    }

    public void setSuccessWebhookUrl(String string) {
        this._persistence_set_successWebhookUrl(string);
    }

    public void setTicketNumber(String string) {
        this._persistence_set_ticketNumber(string);
    }

    public boolean shouldBeApproved() {
        return StringHelper.isNotBlank((Object)this.getSuccessUrl()) || StringHelper.isNotBlank((Object)this.getSuccessWebhookUrl());
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Ticket();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "successWebhookUrl") {
            return this.successWebhookUrl;
        }
        if (string == "ticketNumber") {
            return this.ticketNumber;
        }
        if (string == "cancelUrl") {
            return this.cancelUrl;
        }
        if (string == "amountReservations") {
            return this.amountReservations;
        }
        if (string == "orderId") {
            return this.orderId;
        }
        if (string == "successUrl") {
            return this.successUrl;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "successWebhookUrl") {
            this.successWebhookUrl = (String)object;
            return;
        }
        if (string == "ticketNumber") {
            this.ticketNumber = (String)object;
            return;
        }
        if (string == "cancelUrl") {
            this.cancelUrl = (String)object;
            return;
        }
        if (string == "amountReservations") {
            this.amountReservations = (Set)object;
            return;
        }
        if (string == "orderId") {
            this.orderId = (String)object;
            return;
        }
        if (string == "successUrl") {
            this.successUrl = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_successWebhookUrl() {
        this._persistence_checkFetched("successWebhookUrl");
        return this.successWebhookUrl;
    }

    public void _persistence_set_successWebhookUrl(String string) {
        this._persistence_checkFetchedForSet("successWebhookUrl");
        this._persistence_propertyChange("successWebhookUrl", this.successWebhookUrl, string);
        this.successWebhookUrl = string;
    }

    public String _persistence_get_ticketNumber() {
        this._persistence_checkFetched("ticketNumber");
        return this.ticketNumber;
    }

    public void _persistence_set_ticketNumber(String string) {
        this._persistence_checkFetchedForSet("ticketNumber");
        this._persistence_propertyChange("ticketNumber", this.ticketNumber, string);
        this.ticketNumber = string;
    }

    public String _persistence_get_cancelUrl() {
        this._persistence_checkFetched("cancelUrl");
        return this.cancelUrl;
    }

    public void _persistence_set_cancelUrl(String string) {
        this._persistence_checkFetchedForSet("cancelUrl");
        this._persistence_propertyChange("cancelUrl", this.cancelUrl, string);
        this.cancelUrl = string;
    }

    public Set _persistence_get_amountReservations() {
        this._persistence_checkFetched("amountReservations");
        return this.amountReservations;
    }

    public void _persistence_set_amountReservations(Set set) {
        this._persistence_checkFetchedForSet("amountReservations");
        this._persistence_propertyChange("amountReservations", this.amountReservations, set);
        this.amountReservations = set;
    }

    public String _persistence_get_orderId() {
        this._persistence_checkFetched("orderId");
        return this.orderId;
    }

    public void _persistence_set_orderId(String string) {
        this._persistence_checkFetchedForSet("orderId");
        this._persistence_propertyChange("orderId", this.orderId, string);
        this.orderId = string;
    }

    public String _persistence_get_successUrl() {
        this._persistence_checkFetched("successUrl");
        return this.successUrl;
    }

    public void _persistence_set_successUrl(String string) {
        this._persistence_checkFetchedForSet("successUrl");
        this._persistence_propertyChange("successUrl", this.successUrl, string);
        this.successUrl = string;
    }
}

