/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.cyclos.entities.ProcessableForProxying;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.HasCurrencyAmount;
import org.cyclos.entities.banking.SystemAccount;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.users.User;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.HasTransactionNumber;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;

public interface Trans
extends HasTransactionNumber,
HasCurrencyAmount,
ProcessableForProxying {
    public AccessClient getAccessClient();

    default public BigDecimal getActualAmount(InternalAccountOwner internalAccountOwner) {
        if (this.isDebit(internalAccountOwner)) {
            return this.getAmount().negate();
        }
        return this.getAmount();
    }

    public BigDecimal getAmount();

    public Channel getChannel();

    public Set<TransactionCustomFieldValue> getCustomValues();

    default public Set<TransactionCustomFieldValue> getCustomValuesForExport() {
        return this.getCustomValues();
    }

    public Date getDate();

    public Account getFrom();

    public String getFromName();

    default public InternalAccountOwner getFromOwner() {
        Account account = this.getFrom();
        return account == null ? null : account.getOwner();
    }

    default public Object getFromOwnerOrType() {
        Account account = this.getFrom();
        if (account == null) {
            return null;
        }
        if (account instanceof UserAccount) {
            return account.getOwner();
        }
        return account.getType();
    }

    default public AccountType getFromType() {
        Account account = this.getFrom();
        return account == null ? null : account.getType();
    }

    default public User getFromUser() {
        return (User)ObjectHelper.ifType((Object)this.getFromOwner(), User.class);
    }

    default public Account getRelatedAccount(InternalAccountOwner internalAccountOwner) {
        return this.isDebit(internalAccountOwner) ? this.getTo() : this.getFrom();
    }

    default public AccountOwner getRelatedOwner(InternalAccountOwner internalAccountOwner) {
        return this.isDebit(internalAccountOwner) ? this.getToOwner() : this.getFromOwner();
    }

    public Account getTo();

    public String getToName();

    default public AccountOwner getToOwner() {
        Account account = this.getTo();
        return account == null ? null : account.getOwner();
    }

    default public Object getToOwnerOrType() {
        Account account = this.getTo();
        if (account == null) {
            return null;
        }
        if (account instanceof UserAccount) {
            return account.getOwner();
        }
        return account.getType();
    }

    default public AccountType getToType() {
        Account account = this.getTo();
        return account == null ? null : account.getType();
    }

    default public User getToUser() {
        return (User)ObjectHelper.ifType((Object)this.getToOwner(), User.class);
    }

    default public String getTransactionNumberOrId() {
        return (String)ObjectHelper.defaultValue((Object)this.getTransactionNumber(), () -> StringHelper.trimToNull((Object)this.getId()));
    }

    public TransferType getType();

    default public boolean isDebit(InternalAccountOwner internalAccountOwner) {
        return internalAccountOwner != null && internalAccountOwner.equals((Object)this.getFromOwner()) && !internalAccountOwner.equals((Object)this.getToOwner());
    }

    default public boolean isFromSystem() {
        return this.getFrom() instanceof SystemAccount;
    }

    default public boolean isFromUser() {
        return !this.isFromSystem();
    }

    default public boolean isToSystem() {
        return this.getTo() instanceof SystemAccount;
    }

    default public boolean isToUser() {
        return !this.isToSystem();
    }
}

