/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.MaxScale;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.model.banking.transferfees.TransferFeeChargeMode;
import org.cyclos.model.banking.transferfees.TransferFeeConfigurationMode;
import org.cyclos.model.banking.transferfees.TransferFeeSubject;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.system.scripts.CustomScriptUsedInType;
import org.cyclos.model.system.scripts.UsesScript;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="transfer_fees")
@Cacheable(value=true)
public class TransferFee
extends ConfigurationEntity
implements HasCurrency,
UsesScript,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="enabled")
    private boolean enabled;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="configuration_mode", nullable=false)
    private TransferFeeConfigurationMode configurationMode;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="charge_mode")
    private TransferFeeChargeMode chargeMode;
    @Basic
    @Column(name="amount")
    @MaxScale
    private BigDecimal amount;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="custom_script_id")
    private CustomScript customScript;
    @Basic
    @Lob
    @Column(name="custom_script_parameters")
    private String customScriptParameters;
    @Basic
    @Column(name="deduct_amount")
    private boolean deductAmount;
    @OwnerEntity
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="original_transfer_type_id", nullable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private TransferType originalTransferType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="generated_transfer_type_id")
    private GeneratedTransferType generatedTransferType;
    @Basic
    @Column(name="other_currency")
    private Boolean otherCurrency;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="payer")
    private TransferFeeSubject payer = TransferFeeSubject.SOURCE;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="payer_user_id")
    private User payerUser;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="receiver")
    private TransferFeeSubject receiver = TransferFeeSubject.SYSTEM;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="receiver_user_id")
    private User receiverUser;
    @ManyToMany
    @JoinTable(name="groups_from_transaction_fees", joinColumns={@JoinColumn(name="transaction_fee_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> fromGroups = new HashSet<BasicGroup>();
    @ManyToMany
    @JoinTable(name="groups_to_transaction_fees", joinColumns={@JoinColumn(name="transaction_fee_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> toGroups = new HashSet<BasicGroup>();
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="min", column=@Column(name="higher_than_amount_value")), @AttributeOverride(name="max", column=@Column(name="lower_than_amount_value"))})
    @CurrencyScale
    private DecimalRange amountRange;
    static final long serialVersionUID = -7197734476097682762L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_generatedTransferType_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_receiverUser_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_customScript_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_originalTransferType_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_payerUser_vh;

    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    public DecimalRange getAmountRange() {
        return this._persistence_get_amountRange();
    }

    public TransferFeeChargeMode getChargeMode() {
        return this._persistence_get_chargeMode();
    }

    public TransferFeeConfigurationMode getConfigurationMode() {
        return this._persistence_get_configurationMode();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_originalTransferType().getCurrency();
    }

    public CustomScript getCustomScript() {
        return this._persistence_get_customScript();
    }

    public String getCustomScriptParameters() {
        return this._persistence_get_customScriptParameters();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.TRANSFER_FEES;
    }

    public Set<BasicGroup> getFromGroups() {
        return this._persistence_get_fromGroups();
    }

    public GeneratedTransferType getGeneratedTransferType() {
        return this._persistence_get_generatedTransferType();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_originalTransferType().getNetwork();
    }

    public TransferType getOriginalTransferType() {
        return this._persistence_get_originalTransferType();
    }

    public Boolean getOtherCurrency() {
        return this._persistence_get_otherCurrency();
    }

    public TransferFeeSubject getPayer() {
        return this._persistence_get_payer();
    }

    public User getPayerUser() {
        return this._persistence_get_payerUser();
    }

    public TransferFeeSubject getReceiver() {
        return this._persistence_get_receiver();
    }

    public User getReceiverUser() {
        return this._persistence_get_receiverUser();
    }

    public CustomScriptUsedInType getScriptUsedInType() {
        return CustomScriptUsedInType.TRANSFER_FEE;
    }

    public Set<BasicGroup> getToGroups() {
        return this._persistence_get_toGroups();
    }

    public boolean isDeductAmount() {
        return this._persistence_get_deductAmount();
    }

    public boolean isEnabled() {
        return this._persistence_get_enabled();
    }

    public void setAmount(BigDecimal bigDecimal) {
        this._persistence_set_amount(bigDecimal);
    }

    public void setAmountRange(DecimalRange decimalRange) {
        this._persistence_set_amountRange(decimalRange);
    }

    public void setChargeMode(TransferFeeChargeMode transferFeeChargeMode) {
        this._persistence_set_chargeMode(transferFeeChargeMode);
    }

    public void setConfigurationMode(TransferFeeConfigurationMode transferFeeConfigurationMode) {
        this._persistence_set_configurationMode(transferFeeConfigurationMode);
    }

    public void setCustomScript(CustomScript customScript) {
        this._persistence_set_customScript(customScript);
    }

    public void setCustomScriptParameters(String string) {
        this._persistence_set_customScriptParameters(string);
    }

    public void setDeductAmount(boolean bl) {
        this._persistence_set_deductAmount(bl);
    }

    public void setEnabled(boolean bl) {
        this._persistence_set_enabled(bl);
    }

    public void setFromGroups(Set<BasicGroup> set) {
        this._persistence_set_fromGroups(set);
    }

    public void setGeneratedTransferType(GeneratedTransferType generatedTransferType) {
        this._persistence_set_generatedTransferType(generatedTransferType);
    }

    public void setOriginalTransferType(TransferType transferType) {
        this._persistence_set_originalTransferType(transferType);
    }

    public void setOtherCurrency(Boolean bl) {
        this._persistence_set_otherCurrency(bl);
    }

    public void setPayer(TransferFeeSubject transferFeeSubject) {
        this._persistence_set_payer(transferFeeSubject);
    }

    public void setPayerUser(User user) {
        this._persistence_set_payerUser(user);
    }

    public void setReceiver(TransferFeeSubject transferFeeSubject) {
        this._persistence_set_receiver(transferFeeSubject);
    }

    public void setReceiverUser(User user) {
        this._persistence_set_receiverUser(user);
    }

    public void setToGroups(Set<BasicGroup> set) {
        this._persistence_set_toGroups(set);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_generatedTransferType_vh != null) {
            this._persistence_generatedTransferType_vh = (WeavedAttributeValueHolderInterface)this._persistence_generatedTransferType_vh.clone();
        }
        if (this._persistence_receiverUser_vh != null) {
            this._persistence_receiverUser_vh = (WeavedAttributeValueHolderInterface)this._persistence_receiverUser_vh.clone();
        }
        if (this._persistence_customScript_vh != null) {
            this._persistence_customScript_vh = (WeavedAttributeValueHolderInterface)this._persistence_customScript_vh.clone();
        }
        if (this._persistence_originalTransferType_vh != null) {
            this._persistence_originalTransferType_vh = (WeavedAttributeValueHolderInterface)this._persistence_originalTransferType_vh.clone();
        }
        if (this._persistence_payerUser_vh != null) {
            this._persistence_payerUser_vh = (WeavedAttributeValueHolderInterface)this._persistence_payerUser_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TransferFee();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "generatedTransferType") {
            return this.generatedTransferType;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "customScriptParameters") {
            return this.customScriptParameters;
        }
        if (string == "receiver") {
            return this.receiver;
        }
        if (string == "receiverUser") {
            return this.receiverUser;
        }
        if (string == "deductAmount") {
            return this.deductAmount;
        }
        if (string == "payer") {
            return this.payer;
        }
        if (string == "enabled") {
            return this.enabled;
        }
        if (string == "configurationMode") {
            return this.configurationMode;
        }
        if (string == "otherCurrency") {
            return this.otherCurrency;
        }
        if (string == "customScript") {
            return this.customScript;
        }
        if (string == "toGroups") {
            return this.toGroups;
        }
        if (string == "chargeMode") {
            return this.chargeMode;
        }
        if (string == "fromGroups") {
            return this.fromGroups;
        }
        if (string == "amountRange") {
            return this.amountRange;
        }
        if (string == "originalTransferType") {
            return this.originalTransferType;
        }
        if (string == "payerUser") {
            return this.payerUser;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "generatedTransferType") {
            this.generatedTransferType = (GeneratedTransferType)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "customScriptParameters") {
            this.customScriptParameters = (String)object;
            return;
        }
        if (string == "receiver") {
            this.receiver = (TransferFeeSubject)object;
            return;
        }
        if (string == "receiverUser") {
            this.receiverUser = (User)object;
            return;
        }
        if (string == "deductAmount") {
            this.deductAmount = (Boolean)object;
            return;
        }
        if (string == "payer") {
            this.payer = (TransferFeeSubject)object;
            return;
        }
        if (string == "enabled") {
            this.enabled = (Boolean)object;
            return;
        }
        if (string == "configurationMode") {
            this.configurationMode = (TransferFeeConfigurationMode)object;
            return;
        }
        if (string == "otherCurrency") {
            this.otherCurrency = (Boolean)object;
            return;
        }
        if (string == "customScript") {
            this.customScript = (CustomScript)object;
            return;
        }
        if (string == "toGroups") {
            this.toGroups = (Set)object;
            return;
        }
        if (string == "chargeMode") {
            this.chargeMode = (TransferFeeChargeMode)object;
            return;
        }
        if (string == "fromGroups") {
            this.fromGroups = (Set)object;
            return;
        }
        if (string == "amountRange") {
            this.amountRange = (DecimalRange)object;
            return;
        }
        if (string == "originalTransferType") {
            this.originalTransferType = (TransferType)object;
            return;
        }
        if (string == "payerUser") {
            this.payerUser = (User)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_generatedTransferType_vh() {
        if (this._persistence_generatedTransferType_vh == null) {
            this._persistence_generatedTransferType_vh = new ValueHolder((Object)this.generatedTransferType);
            this._persistence_generatedTransferType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_generatedTransferType_vh() {
        GeneratedTransferType generatedTransferType;
        this._persistence_initialize_generatedTransferType_vh();
        if ((this._persistence_generatedTransferType_vh.isCoordinatedWithProperty() || this._persistence_generatedTransferType_vh.isNewlyWeavedValueHolder()) && (generatedTransferType = this._persistence_get_generatedTransferType()) != this._persistence_generatedTransferType_vh.getValue()) {
            this._persistence_set_generatedTransferType(generatedTransferType);
        }
        return this._persistence_generatedTransferType_vh;
    }

    public void _persistence_set_generatedTransferType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_generatedTransferType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            GeneratedTransferType generatedTransferType = this._persistence_get_generatedTransferType();
            if (generatedTransferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_generatedTransferType((GeneratedTransferType)object);
            }
        } else {
            this.generatedTransferType = null;
        }
    }

    public GeneratedTransferType _persistence_get_generatedTransferType() {
        this._persistence_checkFetched("generatedTransferType");
        this._persistence_initialize_generatedTransferType_vh();
        this.generatedTransferType = (GeneratedTransferType)this._persistence_generatedTransferType_vh.getValue();
        return this.generatedTransferType;
    }

    public void _persistence_set_generatedTransferType(GeneratedTransferType generatedTransferType) {
        this._persistence_checkFetchedForSet("generatedTransferType");
        this._persistence_initialize_generatedTransferType_vh();
        this.generatedTransferType = (GeneratedTransferType)this._persistence_generatedTransferType_vh.getValue();
        this._persistence_propertyChange("generatedTransferType", this.generatedTransferType, generatedTransferType);
        this.generatedTransferType = generatedTransferType;
        this._persistence_generatedTransferType_vh.setValue((Object)generatedTransferType);
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, bigDecimal);
        this.amount = bigDecimal;
    }

    public String _persistence_get_customScriptParameters() {
        this._persistence_checkFetched("customScriptParameters");
        return this.customScriptParameters;
    }

    public void _persistence_set_customScriptParameters(String string) {
        this._persistence_checkFetchedForSet("customScriptParameters");
        this._persistence_propertyChange("customScriptParameters", this.customScriptParameters, string);
        this.customScriptParameters = string;
    }

    public TransferFeeSubject _persistence_get_receiver() {
        this._persistence_checkFetched("receiver");
        return this.receiver;
    }

    public void _persistence_set_receiver(TransferFeeSubject transferFeeSubject) {
        this._persistence_checkFetchedForSet("receiver");
        this._persistence_propertyChange("receiver", this.receiver, transferFeeSubject);
        this.receiver = transferFeeSubject;
    }

    protected void _persistence_initialize_receiverUser_vh() {
        if (this._persistence_receiverUser_vh == null) {
            this._persistence_receiverUser_vh = new ValueHolder((Object)this.receiverUser);
            this._persistence_receiverUser_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_receiverUser_vh() {
        User user;
        this._persistence_initialize_receiverUser_vh();
        if ((this._persistence_receiverUser_vh.isCoordinatedWithProperty() || this._persistence_receiverUser_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_receiverUser()) != this._persistence_receiverUser_vh.getValue()) {
            this._persistence_set_receiverUser(user);
        }
        return this._persistence_receiverUser_vh;
    }

    public void _persistence_set_receiverUser_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_receiverUser_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_receiverUser();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_receiverUser((User)object);
            }
        } else {
            this.receiverUser = null;
        }
    }

    public User _persistence_get_receiverUser() {
        this._persistence_checkFetched("receiverUser");
        this._persistence_initialize_receiverUser_vh();
        this.receiverUser = (User)this._persistence_receiverUser_vh.getValue();
        return this.receiverUser;
    }

    public void _persistence_set_receiverUser(User user) {
        this._persistence_checkFetchedForSet("receiverUser");
        this._persistence_initialize_receiverUser_vh();
        this.receiverUser = (User)this._persistence_receiverUser_vh.getValue();
        this._persistence_propertyChange("receiverUser", this.receiverUser, user);
        this.receiverUser = user;
        this._persistence_receiverUser_vh.setValue((Object)user);
    }

    public boolean _persistence_get_deductAmount() {
        this._persistence_checkFetched("deductAmount");
        return this.deductAmount;
    }

    public void _persistence_set_deductAmount(boolean bl) {
        this._persistence_checkFetchedForSet("deductAmount");
        this._persistence_propertyChange("deductAmount", new Boolean(this.deductAmount), new Boolean(bl));
        this.deductAmount = bl;
    }

    public TransferFeeSubject _persistence_get_payer() {
        this._persistence_checkFetched("payer");
        return this.payer;
    }

    public void _persistence_set_payer(TransferFeeSubject transferFeeSubject) {
        this._persistence_checkFetchedForSet("payer");
        this._persistence_propertyChange("payer", this.payer, transferFeeSubject);
        this.payer = transferFeeSubject;
    }

    public boolean _persistence_get_enabled() {
        this._persistence_checkFetched("enabled");
        return this.enabled;
    }

    public void _persistence_set_enabled(boolean bl) {
        this._persistence_checkFetchedForSet("enabled");
        this._persistence_propertyChange("enabled", new Boolean(this.enabled), new Boolean(bl));
        this.enabled = bl;
    }

    public TransferFeeConfigurationMode _persistence_get_configurationMode() {
        this._persistence_checkFetched("configurationMode");
        return this.configurationMode;
    }

    public void _persistence_set_configurationMode(TransferFeeConfigurationMode transferFeeConfigurationMode) {
        this._persistence_checkFetchedForSet("configurationMode");
        this._persistence_propertyChange("configurationMode", this.configurationMode, transferFeeConfigurationMode);
        this.configurationMode = transferFeeConfigurationMode;
    }

    public Boolean _persistence_get_otherCurrency() {
        this._persistence_checkFetched("otherCurrency");
        return this.otherCurrency;
    }

    public void _persistence_set_otherCurrency(Boolean bl) {
        this._persistence_checkFetchedForSet("otherCurrency");
        this._persistence_propertyChange("otherCurrency", this.otherCurrency, bl);
        this.otherCurrency = bl;
    }

    protected void _persistence_initialize_customScript_vh() {
        if (this._persistence_customScript_vh == null) {
            this._persistence_customScript_vh = new ValueHolder((Object)this.customScript);
            this._persistence_customScript_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_customScript_vh() {
        CustomScript customScript;
        this._persistence_initialize_customScript_vh();
        if ((this._persistence_customScript_vh.isCoordinatedWithProperty() || this._persistence_customScript_vh.isNewlyWeavedValueHolder()) && (customScript = this._persistence_get_customScript()) != this._persistence_customScript_vh.getValue()) {
            this._persistence_set_customScript(customScript);
        }
        return this._persistence_customScript_vh;
    }

    public void _persistence_set_customScript_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_customScript_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomScript customScript = this._persistence_get_customScript();
            if (customScript != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_customScript((CustomScript)object);
            }
        } else {
            this.customScript = null;
        }
    }

    public CustomScript _persistence_get_customScript() {
        this._persistence_checkFetched("customScript");
        this._persistence_initialize_customScript_vh();
        this.customScript = (CustomScript)this._persistence_customScript_vh.getValue();
        return this.customScript;
    }

    public void _persistence_set_customScript(CustomScript customScript) {
        this._persistence_checkFetchedForSet("customScript");
        this._persistence_initialize_customScript_vh();
        this.customScript = (CustomScript)this._persistence_customScript_vh.getValue();
        this._persistence_propertyChange("customScript", this.customScript, customScript);
        this.customScript = customScript;
        this._persistence_customScript_vh.setValue((Object)customScript);
    }

    public Set _persistence_get_toGroups() {
        this._persistence_checkFetched("toGroups");
        return this.toGroups;
    }

    public void _persistence_set_toGroups(Set set) {
        this._persistence_checkFetchedForSet("toGroups");
        this._persistence_propertyChange("toGroups", this.toGroups, set);
        this.toGroups = set;
    }

    public TransferFeeChargeMode _persistence_get_chargeMode() {
        this._persistence_checkFetched("chargeMode");
        return this.chargeMode;
    }

    public void _persistence_set_chargeMode(TransferFeeChargeMode transferFeeChargeMode) {
        this._persistence_checkFetchedForSet("chargeMode");
        this._persistence_propertyChange("chargeMode", this.chargeMode, transferFeeChargeMode);
        this.chargeMode = transferFeeChargeMode;
    }

    public Set _persistence_get_fromGroups() {
        this._persistence_checkFetched("fromGroups");
        return this.fromGroups;
    }

    public void _persistence_set_fromGroups(Set set) {
        this._persistence_checkFetchedForSet("fromGroups");
        this._persistence_propertyChange("fromGroups", this.fromGroups, set);
        this.fromGroups = set;
    }

    public DecimalRange _persistence_get_amountRange() {
        this._persistence_checkFetched("amountRange");
        return this.amountRange;
    }

    public void _persistence_set_amountRange(DecimalRange decimalRange) {
        this._persistence_checkFetchedForSet("amountRange");
        this._persistence_propertyChange("amountRange", this.amountRange, decimalRange);
        this.amountRange = decimalRange;
    }

    protected void _persistence_initialize_originalTransferType_vh() {
        if (this._persistence_originalTransferType_vh == null) {
            this._persistence_originalTransferType_vh = new ValueHolder((Object)this.originalTransferType);
            this._persistence_originalTransferType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_originalTransferType_vh() {
        TransferType transferType;
        this._persistence_initialize_originalTransferType_vh();
        if ((this._persistence_originalTransferType_vh.isCoordinatedWithProperty() || this._persistence_originalTransferType_vh.isNewlyWeavedValueHolder()) && (transferType = this._persistence_get_originalTransferType()) != this._persistence_originalTransferType_vh.getValue()) {
            this._persistence_set_originalTransferType(transferType);
        }
        return this._persistence_originalTransferType_vh;
    }

    public void _persistence_set_originalTransferType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_originalTransferType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            TransferType transferType = this._persistence_get_originalTransferType();
            if (transferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_originalTransferType((TransferType)object);
            }
        } else {
            this.originalTransferType = null;
        }
    }

    public TransferType _persistence_get_originalTransferType() {
        this._persistence_checkFetched("originalTransferType");
        this._persistence_initialize_originalTransferType_vh();
        this.originalTransferType = (TransferType)this._persistence_originalTransferType_vh.getValue();
        return this.originalTransferType;
    }

    public void _persistence_set_originalTransferType(TransferType transferType) {
        this._persistence_checkFetchedForSet("originalTransferType");
        this._persistence_initialize_originalTransferType_vh();
        this.originalTransferType = (TransferType)this._persistence_originalTransferType_vh.getValue();
        this._persistence_propertyChange("originalTransferType", this.originalTransferType, transferType);
        this.originalTransferType = transferType;
        this._persistence_originalTransferType_vh.setValue((Object)transferType);
    }

    protected void _persistence_initialize_payerUser_vh() {
        if (this._persistence_payerUser_vh == null) {
            this._persistence_payerUser_vh = new ValueHolder((Object)this.payerUser);
            this._persistence_payerUser_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_payerUser_vh() {
        User user;
        this._persistence_initialize_payerUser_vh();
        if ((this._persistence_payerUser_vh.isCoordinatedWithProperty() || this._persistence_payerUser_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_payerUser()) != this._persistence_payerUser_vh.getValue()) {
            this._persistence_set_payerUser(user);
        }
        return this._persistence_payerUser_vh;
    }

    public void _persistence_set_payerUser_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_payerUser_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_payerUser();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_payerUser((User)object);
            }
        } else {
            this.payerUser = null;
        }
    }

    public User _persistence_get_payerUser() {
        this._persistence_checkFetched("payerUser");
        this._persistence_initialize_payerUser_vh();
        this.payerUser = (User)this._persistence_payerUser_vh.getValue();
        return this.payerUser;
    }

    public void _persistence_set_payerUser(User user) {
        this._persistence_checkFetchedForSet("payerUser");
        this._persistence_initialize_payerUser_vh();
        this.payerUser = (User)this._persistence_payerUser_vh.getValue();
        this._persistence_propertyChange("payerUser", this.payerUser, user);
        this.payerUser = user;
        this._persistence_payerUser_vh.setValue((Object)user);
    }
}

