/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.MaxScale;
import org.cyclos.utils.BigDecimalHelper;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;

@Embeddable
public class TransferSummary
implements Cloneable,
PersistenceWeaved,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    @Basic
    @Column(name="count")
    private Integer count;
    @Basic
    @Column(name="amount")
    @MaxScale
    private BigDecimal amount;
    static final long serialVersionUID = -1041328635818042917L;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public TransferSummary() {
        this.count = 0;
        this.amount = BigDecimal.ZERO;
    }

    public TransferSummary(Integer n, BigDecimal bigDecimal) {
        this.count = 0;
        this.amount = BigDecimal.ZERO;
        this.setCount(n);
        this.setAmount(bigDecimal);
    }

    public TransferSummary(long l, BigDecimal bigDecimal) {
        this((Integer)((int)l), bigDecimal);
    }

    public TransferSummary add(BigDecimal bigDecimal) {
        return this.add(1, bigDecimal);
    }

    public TransferSummary add(Integer n, BigDecimal bigDecimal) {
        bigDecimal = BigDecimalHelper.zeroWhenNull((BigDecimal)bigDecimal);
        return new TransferSummary((long)(this._persistence_get_count() + n), this._persistence_get_amount().add(bigDecimal));
    }

    public TransferSummary add(TransferSummary transferSummary) {
        return this.add(transferSummary.getCount(), transferSummary.getAmount());
    }

    public TransferSummary clone() {
        try {
            return (TransferSummary)((TransferSummary)super.clone())._persistence_post_clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    public BigDecimal getAverage() {
        return this._persistence_get_count() == 0 ? BigDecimal.ZERO : this._persistence_get_amount().divide(new BigDecimal(this._persistence_get_count()));
    }

    public Integer getCount() {
        return this._persistence_get_count();
    }

    public void setAmount(BigDecimal bigDecimal) {
        this._persistence_set_amount(BigDecimalHelper.zeroWhenNull((BigDecimal)bigDecimal));
    }

    public void setCount(Integer n) {
        this._persistence_set_count(n == null ? 0 : n);
    }

    public TransferSummary subtract(BigDecimal bigDecimal) {
        return this.subtract(1, bigDecimal);
    }

    public TransferSummary subtract(Integer n, BigDecimal bigDecimal) {
        bigDecimal = BigDecimalHelper.zeroWhenNull((BigDecimal)bigDecimal);
        return this.add(-n.intValue(), bigDecimal.negate());
    }

    public TransferSummary subtract(TransferSummary transferSummary) {
        return this.subtract(transferSummary.getCount(), transferSummary.getAmount());
    }

    public String toString() {
        return "count: " + this.getCount() + " - total amount: " + String.valueOf(this.getAmount());
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TransferSummary(persistenceObject);
    }

    public TransferSummary(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "amount") {
            return this.amount;
        }
        if (string == "count") {
            return this.count;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "count") {
            this.count = (Integer)object;
            return;
        }
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, bigDecimal);
        this.amount = bigDecimal;
    }

    public Integer _persistence_get_count() {
        this._persistence_checkFetched("count");
        return this.count;
    }

    public void _persistence_set_count(Integer n) {
        this._persistence_checkFetchedForSet("count");
        this._persistence_propertyChange("count", this.count, n);
        this.count = n;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

