/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountPaymentAmountLimitLog;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.IUserAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.User;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="USER")
public class UserAccount
extends Account
implements IUserAccount,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="payment_amount_limit")
    @CurrencyScale
    private BigDecimal paymentAmountLimit;
    @Basic
    @Column(name="payment_amount_per_day_limit")
    @CurrencyScale
    private BigDecimal paymentAmountPerDayLimit;
    @Basic
    @Column(name="payment_amount_per_week_limit")
    @CurrencyScale
    private BigDecimal paymentAmountPerWeekLimit;
    @Basic
    @Column(name="payment_amount_per_month_limit")
    @CurrencyScale
    private BigDecimal paymentAmountPerMonthLimit;
    @Basic
    @Column(name="payment_amount_per_year_limit")
    @CurrencyScale
    private BigDecimal paymentAmountPerYearLimit;
    @Basic
    @Column(name="upper_credit_limit_from_product")
    protected Boolean upperCreditLimitFromProduct = true;
    @OneToMany(mappedBy="account", cascade={CascadeType.REMOVE})
    @OrderBy(value="modifiedAt DESC")
    private List<AccountPaymentAmountLimitLog> accountPaymentAmountLimitLog = new ArrayList<AccountPaymentAmountLimitLog>();
    @Basic
    @Column(name="active")
    private Boolean active;
    static final long serialVersionUID = 8849337970822486340L;

    public UserAccount() {
    }

    public UserAccount(IUserAccount iUserAccount) {
        this();
        this.setUser(iUserAccount.getUser());
        this.setType(iUserAccount.getType());
        this.setNumber(iUserAccount.getNumber());
        this.setActive(iUserAccount.isActive());
        this.setCreditLimit(iUserAccount.getCreditLimit());
        this.setUpperCreditLimit(iUserAccount.getUpperCreditLimit());
        this.setUpperCreditLimitFromProduct(iUserAccount.isUpperCreditLimitFromProduct());
        if (iUserAccount instanceof UserAccount) {
            UserAccount userAccount = (UserAccount)iUserAccount;
            this.setCreationDate(userAccount.getCreationDate());
            this.setNegativeSince(userAccount.getNegativeSince());
        }
    }

    public UserAccount(Long l, User user, UserAccountType userAccountType, String string, Date date, boolean bl, Date date2, BigDecimal bigDecimal, BigDecimal bigDecimal2, boolean bl2) {
        this.setId(l);
        this.setUser(user);
        this.setType(userAccountType);
        this.setCreationDate(date);
        this.setNumber(string);
        this.setNegativeSince(date2);
        this.setActive(bl);
        this.setCreditLimit(bigDecimal);
        this.setUpperCreditLimit(bigDecimal2);
        this.setUpperCreditLimitFromProduct(bl2);
    }

    public UserAccount(User user, UserAccountType userAccountType) {
        this.setUser(user);
        this.setType(userAccountType);
        this.setActive(true);
    }

    public List<AccountPaymentAmountLimitLog> getAccountPaymentAmountLimitLog() {
        return this._persistence_get_accountPaymentAmountLimitLog();
    }

    @Override
    public UserAccountType getAccountType() {
        return this.getType();
    }

    @Override
    public AccountTypeNature getNature() {
        return AccountTypeNature.USER;
    }

    @Override
    public BigDecimal getPaymentAmountLimit() {
        return this._persistence_get_paymentAmountLimit();
    }

    @Override
    public BigDecimal getPaymentAmountPerDayLimit() {
        return this._persistence_get_paymentAmountPerDayLimit();
    }

    @Override
    public BigDecimal getPaymentAmountPerMonthLimit() {
        return this._persistence_get_paymentAmountPerMonthLimit();
    }

    @Override
    public BigDecimal getPaymentAmountPerWeekLimit() {
        return this._persistence_get_paymentAmountPerWeekLimit();
    }

    @Override
    public BigDecimal getPaymentAmountPerYearLimit() {
        return this._persistence_get_paymentAmountPerYearLimit();
    }

    @Override
    public UserAccountType getType() {
        return (UserAccountType)super.getType();
    }

    @Override
    public User getUser() {
        return this._persistence_get_user();
    }

    @Override
    public boolean isActive() {
        return this._persistence_get_active() == null || this._persistence_get_active() != false;
    }

    public boolean isPaymentAmountLimitFromProduct() {
        return this._persistence_get_paymentAmountLimit() == null;
    }

    public boolean isPaymentAmountPerDayLimitFromProduct() {
        return this._persistence_get_paymentAmountPerDayLimit() == null;
    }

    public boolean isPaymentAmountPerMonthLimitFromProduct() {
        return this._persistence_get_paymentAmountPerMonthLimit() == null;
    }

    public boolean isPaymentAmountPerWeekLimitFromProduct() {
        return this._persistence_get_paymentAmountPerWeekLimit() == null;
    }

    public boolean isPaymentAmountPerYearLimitFromProduct() {
        return this._persistence_get_paymentAmountPerYearLimit() == null;
    }

    @Override
    public boolean isUpperCreditLimitFromProduct() {
        return Boolean.TRUE.equals(this._persistence_get_upperCreditLimitFromProduct());
    }

    @Override
    public void setActive(boolean bl) {
        this._persistence_set_active(bl);
    }

    public void setPaymentAmountLimit(BigDecimal bigDecimal) {
        this._persistence_set_paymentAmountLimit(bigDecimal);
    }

    public void setPaymentAmountPerDayLimit(BigDecimal bigDecimal) {
        this._persistence_set_paymentAmountPerDayLimit(bigDecimal);
    }

    public void setPaymentAmountPerMonthLimit(BigDecimal bigDecimal) {
        this._persistence_set_paymentAmountPerMonthLimit(bigDecimal);
    }

    public void setPaymentAmountPerWeekLimit(BigDecimal bigDecimal) {
        this._persistence_set_paymentAmountPerWeekLimit(bigDecimal);
    }

    public void setPaymentAmountPerYearLimit(BigDecimal bigDecimal) {
        this._persistence_set_paymentAmountPerYearLimit(bigDecimal);
    }

    @Override
    public void setType(AccountType accountType) {
        if (accountType != null && !(accountType instanceof UserAccountType)) {
            throw new IllegalArgumentException("a userAccount may only have a userAccountType");
        }
        super.setType(accountType);
    }

    public void setUpperCreditLimitFromProduct(boolean bl) {
        this._persistence_set_upperCreditLimitFromProduct(bl);
    }

    public void setUser(User user) {
        this._persistence_set_user(user);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new UserAccount();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "paymentAmountPerWeekLimit") {
            return this.paymentAmountPerWeekLimit;
        }
        if (string == "paymentAmountPerYearLimit") {
            return this.paymentAmountPerYearLimit;
        }
        if (string == "upperCreditLimitFromProduct") {
            return this.upperCreditLimitFromProduct;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "paymentAmountPerDayLimit") {
            return this.paymentAmountPerDayLimit;
        }
        if (string == "paymentAmountLimit") {
            return this.paymentAmountLimit;
        }
        if (string == "accountPaymentAmountLimitLog") {
            return this.accountPaymentAmountLimitLog;
        }
        if (string == "paymentAmountPerMonthLimit") {
            return this.paymentAmountPerMonthLimit;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "paymentAmountPerWeekLimit") {
            this.paymentAmountPerWeekLimit = (BigDecimal)object;
            return;
        }
        if (string == "paymentAmountPerYearLimit") {
            this.paymentAmountPerYearLimit = (BigDecimal)object;
            return;
        }
        if (string == "upperCreditLimitFromProduct") {
            this.upperCreditLimitFromProduct = (Boolean)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "paymentAmountPerDayLimit") {
            this.paymentAmountPerDayLimit = (BigDecimal)object;
            return;
        }
        if (string == "paymentAmountLimit") {
            this.paymentAmountLimit = (BigDecimal)object;
            return;
        }
        if (string == "accountPaymentAmountLimitLog") {
            this.accountPaymentAmountLimitLog = (List)object;
            return;
        }
        if (string == "paymentAmountPerMonthLimit") {
            this.paymentAmountPerMonthLimit = (BigDecimal)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public BigDecimal _persistence_get_paymentAmountPerWeekLimit() {
        this._persistence_checkFetched("paymentAmountPerWeekLimit");
        return this.paymentAmountPerWeekLimit;
    }

    public void _persistence_set_paymentAmountPerWeekLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("paymentAmountPerWeekLimit");
        this._persistence_propertyChange("paymentAmountPerWeekLimit", this.paymentAmountPerWeekLimit, bigDecimal);
        this.paymentAmountPerWeekLimit = bigDecimal;
    }

    public BigDecimal _persistence_get_paymentAmountPerYearLimit() {
        this._persistence_checkFetched("paymentAmountPerYearLimit");
        return this.paymentAmountPerYearLimit;
    }

    public void _persistence_set_paymentAmountPerYearLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("paymentAmountPerYearLimit");
        this._persistence_propertyChange("paymentAmountPerYearLimit", this.paymentAmountPerYearLimit, bigDecimal);
        this.paymentAmountPerYearLimit = bigDecimal;
    }

    public Boolean _persistence_get_upperCreditLimitFromProduct() {
        this._persistence_checkFetched("upperCreditLimitFromProduct");
        return this.upperCreditLimitFromProduct;
    }

    public void _persistence_set_upperCreditLimitFromProduct(Boolean bl) {
        this._persistence_checkFetchedForSet("upperCreditLimitFromProduct");
        this._persistence_propertyChange("upperCreditLimitFromProduct", this.upperCreditLimitFromProduct, bl);
        this.upperCreditLimitFromProduct = bl;
    }

    public Boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(Boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", this.active, bl);
        this.active = bl;
    }

    public BigDecimal _persistence_get_paymentAmountPerDayLimit() {
        this._persistence_checkFetched("paymentAmountPerDayLimit");
        return this.paymentAmountPerDayLimit;
    }

    public void _persistence_set_paymentAmountPerDayLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("paymentAmountPerDayLimit");
        this._persistence_propertyChange("paymentAmountPerDayLimit", this.paymentAmountPerDayLimit, bigDecimal);
        this.paymentAmountPerDayLimit = bigDecimal;
    }

    public BigDecimal _persistence_get_paymentAmountLimit() {
        this._persistence_checkFetched("paymentAmountLimit");
        return this.paymentAmountLimit;
    }

    public void _persistence_set_paymentAmountLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("paymentAmountLimit");
        this._persistence_propertyChange("paymentAmountLimit", this.paymentAmountLimit, bigDecimal);
        this.paymentAmountLimit = bigDecimal;
    }

    public List _persistence_get_accountPaymentAmountLimitLog() {
        this._persistence_checkFetched("accountPaymentAmountLimitLog");
        return this.accountPaymentAmountLimitLog;
    }

    public void _persistence_set_accountPaymentAmountLimitLog(List list) {
        this._persistence_checkFetchedForSet("accountPaymentAmountLimitLog");
        this._persistence_propertyChange("accountPaymentAmountLimitLog", this.accountPaymentAmountLimitLog, list);
        this.accountPaymentAmountLimitLog = list;
    }

    public BigDecimal _persistence_get_paymentAmountPerMonthLimit() {
        this._persistence_checkFetched("paymentAmountPerMonthLimit");
        return this.paymentAmountPerMonthLimit;
    }

    public void _persistence_set_paymentAmountPerMonthLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("paymentAmountPerMonthLimit");
        this._persistence_propertyChange("paymentAmountPerMonthLimit", this.paymentAmountPerMonthLimit, bigDecimal);
        this.paymentAmountPerMonthLimit = bigDecimal;
    }
}

