/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.banking.AccountFeeLog;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrencyAmount;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.User;
import org.cyclos.model.banking.accountfees.UserAccountFeeStatus;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="user_account_fee_logs", indexes={@Index(columnList="status"), @Index(name="ix_user_account_fee_logs_users", unique=true, columnList="account_fee_log_id, user_id")})
public class UserAccountFeeLog
extends NetworkedEntity
implements HasCurrencyAmount,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", nullable=false)
    private User user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="account_fee_log_id", nullable=false)
    private AccountFeeLog accountFeeLog;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="date")
    private Date date;
    @Basic
    @Column(name="amount")
    @CurrencyScale
    private BigDecimal amount;
    @Basic
    @Column(name="recharge_attempt", nullable=false)
    private int rechargeAttempt;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", nullable=false)
    private UserAccountFeeStatus status;
    @Basic
    @Lob
    @Column(name="error_details")
    private String errorDetails;
    static final long serialVersionUID = 773780958626576876L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_accountFeeLog_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_user_vh;

    public AccountFeeLog getAccountFeeLog() {
        return this._persistence_get_accountFeeLog();
    }

    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_accountFeeLog().getCurrency();
    }

    public Date getDate() {
        return this._persistence_get_date();
    }

    public String getErrorDetails() {
        return this._persistence_get_errorDetails();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_accountFeeLog().getNetwork();
    }

    public int getRechargeAttempt() {
        return this._persistence_get_rechargeAttempt();
    }

    public UserAccountFeeStatus getStatus() {
        return this._persistence_get_status();
    }

    public User getUser() {
        return this._persistence_get_user();
    }

    public void setAccountFeeLog(AccountFeeLog accountFeeLog) {
        this._persistence_set_accountFeeLog(accountFeeLog);
    }

    public void setAmount(BigDecimal bigDecimal) {
        this._persistence_set_amount(bigDecimal);
    }

    public void setDate(Date date) {
        this._persistence_set_date(date);
    }

    public void setErrorDetails(String string) {
        this._persistence_set_errorDetails(string);
    }

    public void setRechargeAttempt(int n) {
        this._persistence_set_rechargeAttempt(n);
    }

    public void setStatus(UserAccountFeeStatus userAccountFeeStatus) {
        this._persistence_set_status(userAccountFeeStatus);
    }

    public void setUser(User user) {
        this._persistence_set_user(user);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_accountFeeLog_vh != null) {
            this._persistence_accountFeeLog_vh = (WeavedAttributeValueHolderInterface)this._persistence_accountFeeLog_vh.clone();
        }
        if (this._persistence_user_vh != null) {
            this._persistence_user_vh = (WeavedAttributeValueHolderInterface)this._persistence_user_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new UserAccountFeeLog();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "accountFeeLog") {
            return this.accountFeeLog;
        }
        if (string == "rechargeAttempt") {
            return this.rechargeAttempt;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "status") {
            return this.status;
        }
        if (string == "errorDetails") {
            return this.errorDetails;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (Date)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "accountFeeLog") {
            this.accountFeeLog = (AccountFeeLog)object;
            return;
        }
        if (string == "rechargeAttempt") {
            this.rechargeAttempt = (Integer)object;
            return;
        }
        if (string == "user") {
            this.user = (User)object;
            return;
        }
        if (string == "status") {
            this.status = (UserAccountFeeStatus)object;
            return;
        }
        if (string == "errorDetails") {
            this.errorDetails = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(Date date) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, date);
        this.date = date;
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, bigDecimal);
        this.amount = bigDecimal;
    }

    protected void _persistence_initialize_accountFeeLog_vh() {
        if (this._persistence_accountFeeLog_vh == null) {
            this._persistence_accountFeeLog_vh = new ValueHolder((Object)this.accountFeeLog);
            this._persistence_accountFeeLog_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_accountFeeLog_vh() {
        AccountFeeLog accountFeeLog;
        this._persistence_initialize_accountFeeLog_vh();
        if ((this._persistence_accountFeeLog_vh.isCoordinatedWithProperty() || this._persistence_accountFeeLog_vh.isNewlyWeavedValueHolder()) && (accountFeeLog = this._persistence_get_accountFeeLog()) != this._persistence_accountFeeLog_vh.getValue()) {
            this._persistence_set_accountFeeLog(accountFeeLog);
        }
        return this._persistence_accountFeeLog_vh;
    }

    public void _persistence_set_accountFeeLog_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_accountFeeLog_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AccountFeeLog accountFeeLog = this._persistence_get_accountFeeLog();
            if (accountFeeLog != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_accountFeeLog((AccountFeeLog)object);
            }
        } else {
            this.accountFeeLog = null;
        }
    }

    public AccountFeeLog _persistence_get_accountFeeLog() {
        this._persistence_checkFetched("accountFeeLog");
        this._persistence_initialize_accountFeeLog_vh();
        this.accountFeeLog = (AccountFeeLog)this._persistence_accountFeeLog_vh.getValue();
        return this.accountFeeLog;
    }

    public void _persistence_set_accountFeeLog(AccountFeeLog accountFeeLog) {
        this._persistence_checkFetchedForSet("accountFeeLog");
        this._persistence_initialize_accountFeeLog_vh();
        this.accountFeeLog = (AccountFeeLog)this._persistence_accountFeeLog_vh.getValue();
        this._persistence_propertyChange("accountFeeLog", this.accountFeeLog, accountFeeLog);
        this.accountFeeLog = accountFeeLog;
        this._persistence_accountFeeLog_vh.setValue((Object)accountFeeLog);
    }

    public int _persistence_get_rechargeAttempt() {
        this._persistence_checkFetched("rechargeAttempt");
        return this.rechargeAttempt;
    }

    public void _persistence_set_rechargeAttempt(int n) {
        this._persistence_checkFetchedForSet("rechargeAttempt");
        this._persistence_propertyChange("rechargeAttempt", new Integer(this.rechargeAttempt), new Integer(n));
        this.rechargeAttempt = n;
    }

    protected void _persistence_initialize_user_vh() {
        if (this._persistence_user_vh == null) {
            this._persistence_user_vh = new ValueHolder((Object)this.user);
            this._persistence_user_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_user_vh() {
        User user;
        this._persistence_initialize_user_vh();
        if ((this._persistence_user_vh.isCoordinatedWithProperty() || this._persistence_user_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_user()) != this._persistence_user_vh.getValue()) {
            this._persistence_set_user(user);
        }
        return this._persistence_user_vh;
    }

    public void _persistence_set_user_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_user_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_user();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_user((User)object);
            }
        } else {
            this.user = null;
        }
    }

    public User _persistence_get_user() {
        this._persistence_checkFetched("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        return this.user;
    }

    public void _persistence_set_user(User user) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        this._persistence_propertyChange("user", this.user, user);
        this.user = user;
        this._persistence_user_vh.setValue((Object)user);
    }

    public UserAccountFeeStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(UserAccountFeeStatus userAccountFeeStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, userAccountFeeStatus);
        this.status = userAccountFeeStatus;
    }

    public String _persistence_get_errorDetails() {
        this._persistence_checkFetched("errorDetails");
        return this.errorDetails;
    }

    public void _persistence_set_errorDetails(String string) {
        this._persistence_checkFetchedForSet("errorDetails");
        this._persistence_propertyChange("errorDetails", this.errorDetails, string);
        this.errorDetails = string;
    }
}

