/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.ProductVoucher;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationAmount;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationStatus;
import org.cyclos.model.banking.voucherconfigurations.VoucherPinOnActivation;
import org.cyclos.model.banking.voucherconfigurations.VoucherPinUsage;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.utils.ObjectHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="voucher_configurations")
@Cacheable(value=true)
public class VoucherConfiguration
extends ConfigurationEntity
implements HasCurrency,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO(onInsert=false)
    @JoinColumn(name="currency_id", nullable=false)
    private Currency currency;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="redeem_type_id", nullable=false)
    private PaymentTransferType redeemType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="buy_type_id")
    private PaymentTransferType buyType;
    @Basic
    @Column(name="reserve_amount")
    private Boolean reserveAmount;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="refund_type_id")
    private PaymentTransferType refundType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="topup_type_id")
    private PaymentTransferType topUpType;
    @Basic
    @Column(name="mask", nullable=false)
    private String mask;
    @Basic
    @Column(name="show_qr_code")
    private Boolean showQrCode;
    @Basic
    @Column(name="show_plain_token")
    private Boolean showPlainToken;
    @Basic
    @Column(name="account_name")
    private String accountName;
    @Basic
    @Column(name="days_before_expiration_to_notify")
    private Integer daysBeforeExpirationToNotify;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="pin_usage", nullable=false)
    private VoucherPinUsage pinUsage;
    @Basic
    @Column(name="pin_length")
    private Integer pinLength;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="generation_status")
    private VoucherGenerationStatus generationStatus;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="generation_amount", nullable=false)
    private VoucherGenerationAmount generationAmount;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="pin_on_activation", nullable=false)
    private VoucherPinOnActivation pinOnActivation;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="activation_amount")), @AttributeOverride(name="field", column=@Column(name="activation_field"))})
    private TimeInterval activationInterval;
    @ManyToMany(mappedBy="accessibleVoucherConfigurations")
    private Set<AdminProduct> accessibleOnProducts;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    private Set<ProductVoucher> productVouchers;
    static final long serialVersionUID = 2828209880155562983L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_refundType_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_redeemType_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_topUpType_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_currency_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_buyType_vh;

    public String getAccountName() {
        return this._persistence_get_accountName();
    }

    public TimeInterval getActivationInterval() {
        return this._persistence_get_activationInterval();
    }

    public PaymentTransferType getBuyType() {
        return this._persistence_get_buyType();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_currency();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.VOUCHER_CONFIGURATIONS;
    }

    public Integer getDaysBeforeExpirationToNotify() {
        return this._persistence_get_daysBeforeExpirationToNotify();
    }

    public VoucherGenerationAmount getGenerationAmount() {
        return this._persistence_get_generationAmount();
    }

    public VoucherGenerationStatus getGenerationStatus() {
        return this._persistence_get_generationStatus();
    }

    public String getMask() {
        return this._persistence_get_mask();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_currency().getNetwork();
    }

    public Integer getPinLength() {
        return (Integer)ObjectHelper.defaultValue((Object)this._persistence_get_pinLength(), (Object)4);
    }

    public VoucherPinOnActivation getPinOnActivation() {
        return this._persistence_get_pinOnActivation();
    }

    public VoucherPinUsage getPinUsage() {
        return this._persistence_get_pinUsage();
    }

    public PaymentTransferType getRedeemType() {
        return this._persistence_get_redeemType();
    }

    public PaymentTransferType getRefundType() {
        return this._persistence_get_refundType();
    }

    public PaymentTransferType getTopUpType() {
        return this._persistence_get_topUpType();
    }

    public boolean isReserveAmount() {
        return Boolean.TRUE.equals(this._persistence_get_reserveAmount());
    }

    public boolean isShowPlainToken() {
        return Boolean.TRUE.equals(this._persistence_get_showPlainToken());
    }

    public boolean isShowQrCode() {
        return Boolean.TRUE.equals(this._persistence_get_showQrCode());
    }

    public void setAccountName(String string) {
        this._persistence_set_accountName(string);
    }

    public void setActivationInterval(TimeInterval timeInterval) {
        this._persistence_set_activationInterval(timeInterval);
    }

    public void setBuyType(PaymentTransferType paymentTransferType) {
        this._persistence_set_buyType(paymentTransferType);
    }

    public void setCurrency(Currency currency) {
        this._persistence_set_currency(currency);
    }

    public void setDaysBeforeExpirationToNotify(Integer n) {
        this._persistence_set_daysBeforeExpirationToNotify(n);
    }

    public void setGenerationAmount(VoucherGenerationAmount voucherGenerationAmount) {
        this._persistence_set_generationAmount(voucherGenerationAmount);
    }

    public void setGenerationStatus(VoucherGenerationStatus voucherGenerationStatus) {
        this._persistence_set_generationStatus(voucherGenerationStatus);
    }

    public void setMask(String string) {
        this._persistence_set_mask(string);
    }

    public void setPinLength(Integer n) {
        this._persistence_set_pinLength(n);
    }

    public void setPinOnActivation(VoucherPinOnActivation voucherPinOnActivation) {
        this._persistence_set_pinOnActivation(voucherPinOnActivation);
    }

    public void setPinUsage(VoucherPinUsage voucherPinUsage) {
        this._persistence_set_pinUsage(voucherPinUsage);
    }

    public void setRedeemType(PaymentTransferType paymentTransferType) {
        this._persistence_set_redeemType(paymentTransferType);
    }

    public void setRefundType(PaymentTransferType paymentTransferType) {
        this._persistence_set_refundType(paymentTransferType);
    }

    public void setReserveAmount(boolean bl) {
        this._persistence_set_reserveAmount(bl);
    }

    public void setShowPlainToken(boolean bl) {
        this._persistence_set_showPlainToken(bl);
    }

    public void setShowQrCode(boolean bl) {
        this._persistence_set_showQrCode(bl);
    }

    public void setTopUpType(PaymentTransferType paymentTransferType) {
        this._persistence_set_topUpType(paymentTransferType);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_refundType_vh != null) {
            this._persistence_refundType_vh = (WeavedAttributeValueHolderInterface)this._persistence_refundType_vh.clone();
        }
        if (this._persistence_redeemType_vh != null) {
            this._persistence_redeemType_vh = (WeavedAttributeValueHolderInterface)this._persistence_redeemType_vh.clone();
        }
        if (this._persistence_topUpType_vh != null) {
            this._persistence_topUpType_vh = (WeavedAttributeValueHolderInterface)this._persistence_topUpType_vh.clone();
        }
        if (this._persistence_currency_vh != null) {
            this._persistence_currency_vh = (WeavedAttributeValueHolderInterface)this._persistence_currency_vh.clone();
        }
        if (this._persistence_buyType_vh != null) {
            this._persistence_buyType_vh = (WeavedAttributeValueHolderInterface)this._persistence_buyType_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new VoucherConfiguration();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "showPlainToken") {
            return this.showPlainToken;
        }
        if (string == "accountName") {
            return this.accountName;
        }
        if (string == "pinUsage") {
            return this.pinUsage;
        }
        if (string == "reserveAmount") {
            return this.reserveAmount;
        }
        if (string == "daysBeforeExpirationToNotify") {
            return this.daysBeforeExpirationToNotify;
        }
        if (string == "activationInterval") {
            return this.activationInterval;
        }
        if (string == "refundType") {
            return this.refundType;
        }
        if (string == "generationStatus") {
            return this.generationStatus;
        }
        if (string == "redeemType") {
            return this.redeemType;
        }
        if (string == "topUpType") {
            return this.topUpType;
        }
        if (string == "pinLength") {
            return this.pinLength;
        }
        if (string == "showQrCode") {
            return this.showQrCode;
        }
        if (string == "accessibleOnProducts") {
            return this.accessibleOnProducts;
        }
        if (string == "generationAmount") {
            return this.generationAmount;
        }
        if (string == "currency") {
            return this.currency;
        }
        if (string == "buyType") {
            return this.buyType;
        }
        if (string == "pinOnActivation") {
            return this.pinOnActivation;
        }
        if (string == "productVouchers") {
            return this.productVouchers;
        }
        if (string == "mask") {
            return this.mask;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "showPlainToken") {
            this.showPlainToken = (Boolean)object;
            return;
        }
        if (string == "accountName") {
            this.accountName = (String)object;
            return;
        }
        if (string == "pinUsage") {
            this.pinUsage = (VoucherPinUsage)object;
            return;
        }
        if (string == "reserveAmount") {
            this.reserveAmount = (Boolean)object;
            return;
        }
        if (string == "daysBeforeExpirationToNotify") {
            this.daysBeforeExpirationToNotify = (Integer)object;
            return;
        }
        if (string == "activationInterval") {
            this.activationInterval = (TimeInterval)object;
            return;
        }
        if (string == "refundType") {
            this.refundType = (PaymentTransferType)object;
            return;
        }
        if (string == "generationStatus") {
            this.generationStatus = (VoucherGenerationStatus)object;
            return;
        }
        if (string == "redeemType") {
            this.redeemType = (PaymentTransferType)object;
            return;
        }
        if (string == "topUpType") {
            this.topUpType = (PaymentTransferType)object;
            return;
        }
        if (string == "pinLength") {
            this.pinLength = (Integer)object;
            return;
        }
        if (string == "showQrCode") {
            this.showQrCode = (Boolean)object;
            return;
        }
        if (string == "accessibleOnProducts") {
            this.accessibleOnProducts = (Set)object;
            return;
        }
        if (string == "generationAmount") {
            this.generationAmount = (VoucherGenerationAmount)object;
            return;
        }
        if (string == "currency") {
            this.currency = (Currency)object;
            return;
        }
        if (string == "buyType") {
            this.buyType = (PaymentTransferType)object;
            return;
        }
        if (string == "pinOnActivation") {
            this.pinOnActivation = (VoucherPinOnActivation)object;
            return;
        }
        if (string == "productVouchers") {
            this.productVouchers = (Set)object;
            return;
        }
        if (string == "mask") {
            this.mask = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Boolean _persistence_get_showPlainToken() {
        this._persistence_checkFetched("showPlainToken");
        return this.showPlainToken;
    }

    public void _persistence_set_showPlainToken(Boolean bl) {
        this._persistence_checkFetchedForSet("showPlainToken");
        this._persistence_propertyChange("showPlainToken", this.showPlainToken, bl);
        this.showPlainToken = bl;
    }

    public String _persistence_get_accountName() {
        this._persistence_checkFetched("accountName");
        return this.accountName;
    }

    public void _persistence_set_accountName(String string) {
        this._persistence_checkFetchedForSet("accountName");
        this._persistence_propertyChange("accountName", this.accountName, string);
        this.accountName = string;
    }

    public VoucherPinUsage _persistence_get_pinUsage() {
        this._persistence_checkFetched("pinUsage");
        return this.pinUsage;
    }

    public void _persistence_set_pinUsage(VoucherPinUsage voucherPinUsage) {
        this._persistence_checkFetchedForSet("pinUsage");
        this._persistence_propertyChange("pinUsage", this.pinUsage, voucherPinUsage);
        this.pinUsage = voucherPinUsage;
    }

    public Boolean _persistence_get_reserveAmount() {
        this._persistence_checkFetched("reserveAmount");
        return this.reserveAmount;
    }

    public void _persistence_set_reserveAmount(Boolean bl) {
        this._persistence_checkFetchedForSet("reserveAmount");
        this._persistence_propertyChange("reserveAmount", this.reserveAmount, bl);
        this.reserveAmount = bl;
    }

    public Integer _persistence_get_daysBeforeExpirationToNotify() {
        this._persistence_checkFetched("daysBeforeExpirationToNotify");
        return this.daysBeforeExpirationToNotify;
    }

    public void _persistence_set_daysBeforeExpirationToNotify(Integer n) {
        this._persistence_checkFetchedForSet("daysBeforeExpirationToNotify");
        this._persistence_propertyChange("daysBeforeExpirationToNotify", this.daysBeforeExpirationToNotify, n);
        this.daysBeforeExpirationToNotify = n;
    }

    public TimeInterval _persistence_get_activationInterval() {
        this._persistence_checkFetched("activationInterval");
        return this.activationInterval;
    }

    public void _persistence_set_activationInterval(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("activationInterval");
        this._persistence_propertyChange("activationInterval", this.activationInterval, timeInterval);
        this.activationInterval = timeInterval;
    }

    protected void _persistence_initialize_refundType_vh() {
        if (this._persistence_refundType_vh == null) {
            this._persistence_refundType_vh = new ValueHolder((Object)this.refundType);
            this._persistence_refundType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_refundType_vh() {
        PaymentTransferType paymentTransferType;
        this._persistence_initialize_refundType_vh();
        if ((this._persistence_refundType_vh.isCoordinatedWithProperty() || this._persistence_refundType_vh.isNewlyWeavedValueHolder()) && (paymentTransferType = this._persistence_get_refundType()) != this._persistence_refundType_vh.getValue()) {
            this._persistence_set_refundType(paymentTransferType);
        }
        return this._persistence_refundType_vh;
    }

    public void _persistence_set_refundType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_refundType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PaymentTransferType paymentTransferType = this._persistence_get_refundType();
            if (paymentTransferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_refundType((PaymentTransferType)object);
            }
        } else {
            this.refundType = null;
        }
    }

    public PaymentTransferType _persistence_get_refundType() {
        this._persistence_checkFetched("refundType");
        this._persistence_initialize_refundType_vh();
        this.refundType = (PaymentTransferType)this._persistence_refundType_vh.getValue();
        return this.refundType;
    }

    public void _persistence_set_refundType(PaymentTransferType paymentTransferType) {
        this._persistence_checkFetchedForSet("refundType");
        this._persistence_initialize_refundType_vh();
        this.refundType = (PaymentTransferType)this._persistence_refundType_vh.getValue();
        this._persistence_propertyChange("refundType", this.refundType, paymentTransferType);
        this.refundType = paymentTransferType;
        this._persistence_refundType_vh.setValue((Object)paymentTransferType);
    }

    public VoucherGenerationStatus _persistence_get_generationStatus() {
        this._persistence_checkFetched("generationStatus");
        return this.generationStatus;
    }

    public void _persistence_set_generationStatus(VoucherGenerationStatus voucherGenerationStatus) {
        this._persistence_checkFetchedForSet("generationStatus");
        this._persistence_propertyChange("generationStatus", this.generationStatus, voucherGenerationStatus);
        this.generationStatus = voucherGenerationStatus;
    }

    protected void _persistence_initialize_redeemType_vh() {
        if (this._persistence_redeemType_vh == null) {
            this._persistence_redeemType_vh = new ValueHolder((Object)this.redeemType);
            this._persistence_redeemType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_redeemType_vh() {
        PaymentTransferType paymentTransferType;
        this._persistence_initialize_redeemType_vh();
        if ((this._persistence_redeemType_vh.isCoordinatedWithProperty() || this._persistence_redeemType_vh.isNewlyWeavedValueHolder()) && (paymentTransferType = this._persistence_get_redeemType()) != this._persistence_redeemType_vh.getValue()) {
            this._persistence_set_redeemType(paymentTransferType);
        }
        return this._persistence_redeemType_vh;
    }

    public void _persistence_set_redeemType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_redeemType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PaymentTransferType paymentTransferType = this._persistence_get_redeemType();
            if (paymentTransferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_redeemType((PaymentTransferType)object);
            }
        } else {
            this.redeemType = null;
        }
    }

    public PaymentTransferType _persistence_get_redeemType() {
        this._persistence_checkFetched("redeemType");
        this._persistence_initialize_redeemType_vh();
        this.redeemType = (PaymentTransferType)this._persistence_redeemType_vh.getValue();
        return this.redeemType;
    }

    public void _persistence_set_redeemType(PaymentTransferType paymentTransferType) {
        this._persistence_checkFetchedForSet("redeemType");
        this._persistence_initialize_redeemType_vh();
        this.redeemType = (PaymentTransferType)this._persistence_redeemType_vh.getValue();
        this._persistence_propertyChange("redeemType", this.redeemType, paymentTransferType);
        this.redeemType = paymentTransferType;
        this._persistence_redeemType_vh.setValue((Object)paymentTransferType);
    }

    protected void _persistence_initialize_topUpType_vh() {
        if (this._persistence_topUpType_vh == null) {
            this._persistence_topUpType_vh = new ValueHolder((Object)this.topUpType);
            this._persistence_topUpType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_topUpType_vh() {
        PaymentTransferType paymentTransferType;
        this._persistence_initialize_topUpType_vh();
        if ((this._persistence_topUpType_vh.isCoordinatedWithProperty() || this._persistence_topUpType_vh.isNewlyWeavedValueHolder()) && (paymentTransferType = this._persistence_get_topUpType()) != this._persistence_topUpType_vh.getValue()) {
            this._persistence_set_topUpType(paymentTransferType);
        }
        return this._persistence_topUpType_vh;
    }

    public void _persistence_set_topUpType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_topUpType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PaymentTransferType paymentTransferType = this._persistence_get_topUpType();
            if (paymentTransferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_topUpType((PaymentTransferType)object);
            }
        } else {
            this.topUpType = null;
        }
    }

    public PaymentTransferType _persistence_get_topUpType() {
        this._persistence_checkFetched("topUpType");
        this._persistence_initialize_topUpType_vh();
        this.topUpType = (PaymentTransferType)this._persistence_topUpType_vh.getValue();
        return this.topUpType;
    }

    public void _persistence_set_topUpType(PaymentTransferType paymentTransferType) {
        this._persistence_checkFetchedForSet("topUpType");
        this._persistence_initialize_topUpType_vh();
        this.topUpType = (PaymentTransferType)this._persistence_topUpType_vh.getValue();
        this._persistence_propertyChange("topUpType", this.topUpType, paymentTransferType);
        this.topUpType = paymentTransferType;
        this._persistence_topUpType_vh.setValue((Object)paymentTransferType);
    }

    public Integer _persistence_get_pinLength() {
        this._persistence_checkFetched("pinLength");
        return this.pinLength;
    }

    public void _persistence_set_pinLength(Integer n) {
        this._persistence_checkFetchedForSet("pinLength");
        this._persistence_propertyChange("pinLength", this.pinLength, n);
        this.pinLength = n;
    }

    public Boolean _persistence_get_showQrCode() {
        this._persistence_checkFetched("showQrCode");
        return this.showQrCode;
    }

    public void _persistence_set_showQrCode(Boolean bl) {
        this._persistence_checkFetchedForSet("showQrCode");
        this._persistence_propertyChange("showQrCode", this.showQrCode, bl);
        this.showQrCode = bl;
    }

    public Set _persistence_get_accessibleOnProducts() {
        this._persistence_checkFetched("accessibleOnProducts");
        return this.accessibleOnProducts;
    }

    public void _persistence_set_accessibleOnProducts(Set set) {
        this._persistence_checkFetchedForSet("accessibleOnProducts");
        this._persistence_propertyChange("accessibleOnProducts", this.accessibleOnProducts, set);
        this.accessibleOnProducts = set;
    }

    public VoucherGenerationAmount _persistence_get_generationAmount() {
        this._persistence_checkFetched("generationAmount");
        return this.generationAmount;
    }

    public void _persistence_set_generationAmount(VoucherGenerationAmount voucherGenerationAmount) {
        this._persistence_checkFetchedForSet("generationAmount");
        this._persistence_propertyChange("generationAmount", this.generationAmount, voucherGenerationAmount);
        this.generationAmount = voucherGenerationAmount;
    }

    protected void _persistence_initialize_currency_vh() {
        if (this._persistence_currency_vh == null) {
            this._persistence_currency_vh = new ValueHolder((Object)this.currency);
            this._persistence_currency_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_currency_vh() {
        Currency currency;
        this._persistence_initialize_currency_vh();
        if ((this._persistence_currency_vh.isCoordinatedWithProperty() || this._persistence_currency_vh.isNewlyWeavedValueHolder()) && (currency = this._persistence_get_currency()) != this._persistence_currency_vh.getValue()) {
            this._persistence_set_currency(currency);
        }
        return this._persistence_currency_vh;
    }

    public void _persistence_set_currency_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_currency_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Currency currency = this._persistence_get_currency();
            if (currency != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_currency((Currency)object);
            }
        } else {
            this.currency = null;
        }
    }

    public Currency _persistence_get_currency() {
        this._persistence_checkFetched("currency");
        this._persistence_initialize_currency_vh();
        this.currency = (Currency)this._persistence_currency_vh.getValue();
        return this.currency;
    }

    public void _persistence_set_currency(Currency currency) {
        this._persistence_checkFetchedForSet("currency");
        this._persistence_initialize_currency_vh();
        this.currency = (Currency)this._persistence_currency_vh.getValue();
        this._persistence_propertyChange("currency", this.currency, currency);
        this.currency = currency;
        this._persistence_currency_vh.setValue((Object)currency);
    }

    protected void _persistence_initialize_buyType_vh() {
        if (this._persistence_buyType_vh == null) {
            this._persistence_buyType_vh = new ValueHolder((Object)this.buyType);
            this._persistence_buyType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_buyType_vh() {
        PaymentTransferType paymentTransferType;
        this._persistence_initialize_buyType_vh();
        if ((this._persistence_buyType_vh.isCoordinatedWithProperty() || this._persistence_buyType_vh.isNewlyWeavedValueHolder()) && (paymentTransferType = this._persistence_get_buyType()) != this._persistence_buyType_vh.getValue()) {
            this._persistence_set_buyType(paymentTransferType);
        }
        return this._persistence_buyType_vh;
    }

    public void _persistence_set_buyType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_buyType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PaymentTransferType paymentTransferType = this._persistence_get_buyType();
            if (paymentTransferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_buyType((PaymentTransferType)object);
            }
        } else {
            this.buyType = null;
        }
    }

    public PaymentTransferType _persistence_get_buyType() {
        this._persistence_checkFetched("buyType");
        this._persistence_initialize_buyType_vh();
        this.buyType = (PaymentTransferType)this._persistence_buyType_vh.getValue();
        return this.buyType;
    }

    public void _persistence_set_buyType(PaymentTransferType paymentTransferType) {
        this._persistence_checkFetchedForSet("buyType");
        this._persistence_initialize_buyType_vh();
        this.buyType = (PaymentTransferType)this._persistence_buyType_vh.getValue();
        this._persistence_propertyChange("buyType", this.buyType, paymentTransferType);
        this.buyType = paymentTransferType;
        this._persistence_buyType_vh.setValue((Object)paymentTransferType);
    }

    public VoucherPinOnActivation _persistence_get_pinOnActivation() {
        this._persistence_checkFetched("pinOnActivation");
        return this.pinOnActivation;
    }

    public void _persistence_set_pinOnActivation(VoucherPinOnActivation voucherPinOnActivation) {
        this._persistence_checkFetchedForSet("pinOnActivation");
        this._persistence_propertyChange("pinOnActivation", this.pinOnActivation, voucherPinOnActivation);
        this.pinOnActivation = voucherPinOnActivation;
    }

    public Set _persistence_get_productVouchers() {
        this._persistence_checkFetched("productVouchers");
        return this.productVouchers;
    }

    public void _persistence_set_productVouchers(Set set) {
        this._persistence_checkFetchedForSet("productVouchers");
        this._persistence_propertyChange("productVouchers", this.productVouchers, set);
        this.productVouchers = set;
    }

    public String _persistence_get_mask() {
        this._persistence_checkFetched("mask");
        return this.mask;
    }

    public void _persistence_set_mask(String string) {
        this._persistence_checkFetchedForSet("mask");
        this._persistence_propertyChange("mask", this.mask, string);
        this.mask = string;
    }
}

