/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrencyAmount;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.banking.VoucherCustomFieldPossibleValue;
import org.cyclos.entities.banking.VoucherCustomFieldPossibleValueCategory;
import org.cyclos.entities.banking.VoucherPackAmountReservation;
import org.cyclos.entities.banking.VoucherPackCustomFieldValue;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.model.banking.vouchers.VoucherCreationType;
import org.cyclos.server.utils.EnumHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.WeekDay;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="voucher_packs")
public class VoucherPack
extends BaseEntity
implements HasCurrencyAmount,
EntityWithCustomValues<VoucherCustomField, VoucherCustomFieldPossibleValueCategory, VoucherCustomFieldPossibleValue, VoucherPackCustomFieldValue>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="type_id", nullable=false)
    private VoucherType type;
    @Basic
    @Column(name="type_id", insertable=false, updatable=false, nullable=false)
    private Long typeId;
    @Basic
    @Lob
    @Column(name="voucher_tokens")
    private String voucherTokens;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="creation_type", nullable=false)
    private VoucherCreationType creationType;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creation_date", nullable=false)
    private Date creationDate;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="activation_deadline")
    private Date activationDeadline;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration_date", nullable=false)
    private Date expirationDate;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="redeem_after_date", nullable=false)
    private Date redeemAfterDate;
    @Basic
    @Column(name="about_to_expire_notified")
    private Boolean aboutToExpireNotified;
    @Basic
    @Column(name="expiration_notified")
    private Boolean expirationNotified;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="by_id")
    private BasicUser by;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="buyer_id")
    private User buyer;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="buy_id")
    private Payment buy;
    @Basic
    @Lob
    @Column(name="send_message")
    private String sendMessage;
    @Basic
    @Column(name="count", nullable=false)
    private Integer count;
    @Basic
    @Column(name="amount")
    @CurrencyScale
    private BigDecimal amount;
    @Basic
    @Column(name="gift")
    private Boolean gift;
    @OneToMany(mappedBy="voucherPack")
    private Set<VoucherPackAmountReservation> amountReservations;
    @Basic
    @Column(name="redeem_on_weekdays")
    private String redeemOnWeekDays;
    @OneToMany(mappedBy="pack")
    private Set<Voucher> vouchers = new HashSet<Voucher>();
    @OneToMany(mappedBy="owner", cascade={CascadeType.ALL})
    private Set<VoucherPackCustomFieldValue> customValues = new HashSet<VoucherPackCustomFieldValue>();
    static final long serialVersionUID = -7462836989847559932L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_buy_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_type_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_buyer_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_by_vh;

    public Date getActivationDeadline() {
        return this._persistence_get_activationDeadline();
    }

    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    public VoucherPackAmountReservation getAmountReservation() {
        return (VoucherPackAmountReservation)CollectionHelper.first((Iterable)this._persistence_get_amountReservations());
    }

    public Payment getBuy() {
        return this._persistence_get_buy();
    }

    public User getBuyer() {
        return this._persistence_get_buyer();
    }

    public BasicUser getBy() {
        return this._persistence_get_by();
    }

    public VoucherConfiguration getConfiguration() {
        return this._persistence_get_type().getConfiguration();
    }

    public Integer getCount() {
        return this._persistence_get_count();
    }

    public Date getCreationDate() {
        return this._persistence_get_creationDate();
    }

    public VoucherCreationType getCreationType() {
        return this._persistence_get_creationType();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_type().getCurrency();
    }

    @Override
    public Class<VoucherCustomField> getCustomFieldClass() {
        return VoucherCustomField.class;
    }

    @Override
    public Class<VoucherPackCustomFieldValue> getCustomFieldValueClass() {
        return VoucherPackCustomFieldValue.class;
    }

    @Override
    public Set<VoucherPackCustomFieldValue> getCustomValues() {
        return this._persistence_get_customValues();
    }

    public Date getExpirationDate() {
        return this._persistence_get_expirationDate();
    }

    public Boolean getGift() {
        return this._persistence_get_gift();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_type().getNetwork();
    }

    public Date getRedeemAfterDate() {
        return this._persistence_get_redeemAfterDate();
    }

    public Set<WeekDay> getRedeemOnWeekDays() {
        return EnumHelper.decodeOrdinals(WeekDay.class, (String)this._persistence_get_redeemOnWeekDays());
    }

    public String getSendMessage() {
        return this._persistence_get_sendMessage();
    }

    public String getSentToEmail() {
        if (this.isSent()) {
            Voucher voucher = (Voucher)CollectionHelper.first((Iterable)this._persistence_get_vouchers());
            return voucher == null ? null : voucher.getEmail();
        }
        return null;
    }

    public BigDecimal getTotalAmount() {
        return this.round(this._persistence_get_amount().multiply(new BigDecimal(this._persistence_get_count())));
    }

    public VoucherType getType() {
        return this._persistence_get_type();
    }

    public Set<Voucher> getVouchers() {
        return this._persistence_get_vouchers();
    }

    public List<String> getVoucherTokens() {
        return StringHelper.splitTrimming((String)this._persistence_get_voucherTokens(), (String)",");
    }

    public boolean isAboutToExpireNotified() {
        return Boolean.TRUE.equals(this._persistence_get_aboutToExpireNotified());
    }

    public boolean isBought() {
        return this._persistence_get_buyer() != null;
    }

    public boolean isExpirationNotified() {
        return Boolean.TRUE.equals(this._persistence_get_expirationNotified());
    }

    public boolean isGenerated() {
        return this._persistence_get_buyer() == null;
    }

    public boolean isSent() {
        return this._persistence_get_creationType() == VoucherCreationType.SENT;
    }

    public void setAboutToExpireNotified(boolean bl) {
        this._persistence_set_aboutToExpireNotified(bl);
    }

    public void setActivationDeadline(Date date) {
        this._persistence_set_activationDeadline(date);
    }

    public void setAmount(BigDecimal bigDecimal) {
        this._persistence_set_amount(bigDecimal);
    }

    public void setAmountReservation(VoucherPackAmountReservation voucherPackAmountReservation) {
        this._persistence_set_amountReservations(CollectionHelper.asSet((Object[])new VoucherPackAmountReservation[]{voucherPackAmountReservation}));
    }

    public void setBuy(Payment payment) {
        this._persistence_set_buy(payment);
    }

    public void setBuyer(User user) {
        this._persistence_set_buyer(user);
    }

    public void setBy(BasicUser basicUser) {
        this._persistence_set_by(basicUser);
    }

    public void setCount(Integer n) {
        this._persistence_set_count(n);
    }

    public void setCreationDate(Date date) {
        this._persistence_set_creationDate(date);
    }

    public void setCreationType(VoucherCreationType voucherCreationType) {
        this._persistence_set_creationType(voucherCreationType);
    }

    public void setCustomValues(Set<VoucherPackCustomFieldValue> set) {
        this._persistence_set_customValues(set);
    }

    public void setExpirationDate(Date date) {
        this._persistence_set_expirationDate(date);
    }

    public void setExpirationNotified(boolean bl) {
        this._persistence_set_expirationNotified(bl);
    }

    public void setGift(Boolean bl) {
        this._persistence_set_gift(bl);
    }

    public void setRedeemAfterDate(Date date) {
        this._persistence_set_redeemAfterDate(date);
    }

    public void setRedeemOnWeekDays(Set<WeekDay> set) {
        this._persistence_set_redeemOnWeekDays(EnumHelper.encodeOrdinals(WeekDay.class, set));
    }

    public void setSendMessage(String string) {
        this._persistence_set_sendMessage(string);
    }

    public void setType(VoucherType voucherType) {
        this._persistence_set_type(voucherType);
    }

    public void setVouchers(Set<Voucher> set) {
        this._persistence_set_vouchers(set);
    }

    public void setVoucherTokens(List<String> list) {
        this._persistence_set_voucherTokens(StringHelper.join(list, (String)","));
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_buy_vh != null) {
            this._persistence_buy_vh = (WeavedAttributeValueHolderInterface)this._persistence_buy_vh.clone();
        }
        if (this._persistence_type_vh != null) {
            this._persistence_type_vh = (WeavedAttributeValueHolderInterface)this._persistence_type_vh.clone();
        }
        if (this._persistence_buyer_vh != null) {
            this._persistence_buyer_vh = (WeavedAttributeValueHolderInterface)this._persistence_buyer_vh.clone();
        }
        if (this._persistence_by_vh != null) {
            this._persistence_by_vh = (WeavedAttributeValueHolderInterface)this._persistence_by_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new VoucherPack();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "gift") {
            return this.gift;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "buy") {
            return this.buy;
        }
        if (string == "count") {
            return this.count;
        }
        if (string == "sendMessage") {
            return this.sendMessage;
        }
        if (string == "redeemAfterDate") {
            return this.redeemAfterDate;
        }
        if (string == "expirationNotified") {
            return this.expirationNotified;
        }
        if (string == "creationDate") {
            return this.creationDate;
        }
        if (string == "aboutToExpireNotified") {
            return this.aboutToExpireNotified;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "vouchers") {
            return this.vouchers;
        }
        if (string == "voucherTokens") {
            return this.voucherTokens;
        }
        if (string == "buyer") {
            return this.buyer;
        }
        if (string == "creationType") {
            return this.creationType;
        }
        if (string == "activationDeadline") {
            return this.activationDeadline;
        }
        if (string == "amountReservations") {
            return this.amountReservations;
        }
        if (string == "by") {
            return this.by;
        }
        if (string == "typeId") {
            return this.typeId;
        }
        if (string == "redeemOnWeekDays") {
            return this.redeemOnWeekDays;
        }
        if (string == "expirationDate") {
            return this.expirationDate;
        }
        if (string == "customValues") {
            return this.customValues;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "gift") {
            this.gift = (Boolean)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "buy") {
            this.buy = (Payment)object;
            return;
        }
        if (string == "count") {
            this.count = (Integer)object;
            return;
        }
        if (string == "sendMessage") {
            this.sendMessage = (String)object;
            return;
        }
        if (string == "redeemAfterDate") {
            this.redeemAfterDate = (Date)object;
            return;
        }
        if (string == "expirationNotified") {
            this.expirationNotified = (Boolean)object;
            return;
        }
        if (string == "creationDate") {
            this.creationDate = (Date)object;
            return;
        }
        if (string == "aboutToExpireNotified") {
            this.aboutToExpireNotified = (Boolean)object;
            return;
        }
        if (string == "type") {
            this.type = (VoucherType)object;
            return;
        }
        if (string == "vouchers") {
            this.vouchers = (Set)object;
            return;
        }
        if (string == "voucherTokens") {
            this.voucherTokens = (String)object;
            return;
        }
        if (string == "buyer") {
            this.buyer = (User)object;
            return;
        }
        if (string == "creationType") {
            this.creationType = (VoucherCreationType)object;
            return;
        }
        if (string == "activationDeadline") {
            this.activationDeadline = (Date)object;
            return;
        }
        if (string == "amountReservations") {
            this.amountReservations = (Set)object;
            return;
        }
        if (string == "by") {
            this.by = (BasicUser)object;
            return;
        }
        if (string == "typeId") {
            this.typeId = (Long)object;
            return;
        }
        if (string == "redeemOnWeekDays") {
            this.redeemOnWeekDays = (String)object;
            return;
        }
        if (string == "expirationDate") {
            this.expirationDate = (Date)object;
            return;
        }
        if (string == "customValues") {
            this.customValues = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Boolean _persistence_get_gift() {
        this._persistence_checkFetched("gift");
        return this.gift;
    }

    public void _persistence_set_gift(Boolean bl) {
        this._persistence_checkFetchedForSet("gift");
        this._persistence_propertyChange("gift", this.gift, bl);
        this.gift = bl;
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, bigDecimal);
        this.amount = bigDecimal;
    }

    protected void _persistence_initialize_buy_vh() {
        if (this._persistence_buy_vh == null) {
            this._persistence_buy_vh = new ValueHolder((Object)this.buy);
            this._persistence_buy_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_buy_vh() {
        Payment payment;
        this._persistence_initialize_buy_vh();
        if ((this._persistence_buy_vh.isCoordinatedWithProperty() || this._persistence_buy_vh.isNewlyWeavedValueHolder()) && (payment = this._persistence_get_buy()) != this._persistence_buy_vh.getValue()) {
            this._persistence_set_buy(payment);
        }
        return this._persistence_buy_vh;
    }

    public void _persistence_set_buy_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_buy_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Payment payment = this._persistence_get_buy();
            if (payment != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_buy((Payment)object);
            }
        } else {
            this.buy = null;
        }
    }

    public Payment _persistence_get_buy() {
        this._persistence_checkFetched("buy");
        this._persistence_initialize_buy_vh();
        this.buy = (Payment)this._persistence_buy_vh.getValue();
        return this.buy;
    }

    public void _persistence_set_buy(Payment payment) {
        this._persistence_checkFetchedForSet("buy");
        this._persistence_initialize_buy_vh();
        this.buy = (Payment)this._persistence_buy_vh.getValue();
        this._persistence_propertyChange("buy", this.buy, payment);
        this.buy = payment;
        this._persistence_buy_vh.setValue((Object)payment);
    }

    public Integer _persistence_get_count() {
        this._persistence_checkFetched("count");
        return this.count;
    }

    public void _persistence_set_count(Integer n) {
        this._persistence_checkFetchedForSet("count");
        this._persistence_propertyChange("count", this.count, n);
        this.count = n;
    }

    public String _persistence_get_sendMessage() {
        this._persistence_checkFetched("sendMessage");
        return this.sendMessage;
    }

    public void _persistence_set_sendMessage(String string) {
        this._persistence_checkFetchedForSet("sendMessage");
        this._persistence_propertyChange("sendMessage", this.sendMessage, string);
        this.sendMessage = string;
    }

    public Date _persistence_get_redeemAfterDate() {
        this._persistence_checkFetched("redeemAfterDate");
        return this.redeemAfterDate;
    }

    public void _persistence_set_redeemAfterDate(Date date) {
        this._persistence_checkFetchedForSet("redeemAfterDate");
        this._persistence_propertyChange("redeemAfterDate", this.redeemAfterDate, date);
        this.redeemAfterDate = date;
    }

    public Boolean _persistence_get_expirationNotified() {
        this._persistence_checkFetched("expirationNotified");
        return this.expirationNotified;
    }

    public void _persistence_set_expirationNotified(Boolean bl) {
        this._persistence_checkFetchedForSet("expirationNotified");
        this._persistence_propertyChange("expirationNotified", this.expirationNotified, bl);
        this.expirationNotified = bl;
    }

    public Date _persistence_get_creationDate() {
        this._persistence_checkFetched("creationDate");
        return this.creationDate;
    }

    public void _persistence_set_creationDate(Date date) {
        this._persistence_checkFetchedForSet("creationDate");
        this._persistence_propertyChange("creationDate", this.creationDate, date);
        this.creationDate = date;
    }

    public Boolean _persistence_get_aboutToExpireNotified() {
        this._persistence_checkFetched("aboutToExpireNotified");
        return this.aboutToExpireNotified;
    }

    public void _persistence_set_aboutToExpireNotified(Boolean bl) {
        this._persistence_checkFetchedForSet("aboutToExpireNotified");
        this._persistence_propertyChange("aboutToExpireNotified", this.aboutToExpireNotified, bl);
        this.aboutToExpireNotified = bl;
    }

    protected void _persistence_initialize_type_vh() {
        if (this._persistence_type_vh == null) {
            this._persistence_type_vh = new ValueHolder((Object)this.type);
            this._persistence_type_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_type_vh() {
        VoucherType voucherType;
        this._persistence_initialize_type_vh();
        if ((this._persistence_type_vh.isCoordinatedWithProperty() || this._persistence_type_vh.isNewlyWeavedValueHolder()) && (voucherType = this._persistence_get_type()) != this._persistence_type_vh.getValue()) {
            this._persistence_set_type(voucherType);
        }
        return this._persistence_type_vh;
    }

    public void _persistence_set_type_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_type_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            VoucherType voucherType = this._persistence_get_type();
            if (voucherType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_type((VoucherType)object);
            }
        } else {
            this.type = null;
        }
    }

    public VoucherType _persistence_get_type() {
        this._persistence_checkFetched("type");
        this._persistence_initialize_type_vh();
        this.type = (VoucherType)this._persistence_type_vh.getValue();
        return this.type;
    }

    public void _persistence_set_type(VoucherType voucherType) {
        this._persistence_checkFetchedForSet("type");
        this._persistence_initialize_type_vh();
        this.type = (VoucherType)this._persistence_type_vh.getValue();
        this._persistence_propertyChange("type", this.type, voucherType);
        this.type = voucherType;
        this._persistence_type_vh.setValue((Object)voucherType);
    }

    public Set _persistence_get_vouchers() {
        this._persistence_checkFetched("vouchers");
        return this.vouchers;
    }

    public void _persistence_set_vouchers(Set set) {
        this._persistence_checkFetchedForSet("vouchers");
        this._persistence_propertyChange("vouchers", this.vouchers, set);
        this.vouchers = set;
    }

    public String _persistence_get_voucherTokens() {
        this._persistence_checkFetched("voucherTokens");
        return this.voucherTokens;
    }

    public void _persistence_set_voucherTokens(String string) {
        this._persistence_checkFetchedForSet("voucherTokens");
        this._persistence_propertyChange("voucherTokens", this.voucherTokens, string);
        this.voucherTokens = string;
    }

    protected void _persistence_initialize_buyer_vh() {
        if (this._persistence_buyer_vh == null) {
            this._persistence_buyer_vh = new ValueHolder((Object)this.buyer);
            this._persistence_buyer_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_buyer_vh() {
        User user;
        this._persistence_initialize_buyer_vh();
        if ((this._persistence_buyer_vh.isCoordinatedWithProperty() || this._persistence_buyer_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_buyer()) != this._persistence_buyer_vh.getValue()) {
            this._persistence_set_buyer(user);
        }
        return this._persistence_buyer_vh;
    }

    public void _persistence_set_buyer_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_buyer_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_buyer();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_buyer((User)object);
            }
        } else {
            this.buyer = null;
        }
    }

    public User _persistence_get_buyer() {
        this._persistence_checkFetched("buyer");
        this._persistence_initialize_buyer_vh();
        this.buyer = (User)this._persistence_buyer_vh.getValue();
        return this.buyer;
    }

    public void _persistence_set_buyer(User user) {
        this._persistence_checkFetchedForSet("buyer");
        this._persistence_initialize_buyer_vh();
        this.buyer = (User)this._persistence_buyer_vh.getValue();
        this._persistence_propertyChange("buyer", this.buyer, user);
        this.buyer = user;
        this._persistence_buyer_vh.setValue((Object)user);
    }

    public VoucherCreationType _persistence_get_creationType() {
        this._persistence_checkFetched("creationType");
        return this.creationType;
    }

    public void _persistence_set_creationType(VoucherCreationType voucherCreationType) {
        this._persistence_checkFetchedForSet("creationType");
        this._persistence_propertyChange("creationType", this.creationType, voucherCreationType);
        this.creationType = voucherCreationType;
    }

    public Date _persistence_get_activationDeadline() {
        this._persistence_checkFetched("activationDeadline");
        return this.activationDeadline;
    }

    public void _persistence_set_activationDeadline(Date date) {
        this._persistence_checkFetchedForSet("activationDeadline");
        this._persistence_propertyChange("activationDeadline", this.activationDeadline, date);
        this.activationDeadline = date;
    }

    public Set _persistence_get_amountReservations() {
        this._persistence_checkFetched("amountReservations");
        return this.amountReservations;
    }

    public void _persistence_set_amountReservations(Set set) {
        this._persistence_checkFetchedForSet("amountReservations");
        this._persistence_propertyChange("amountReservations", this.amountReservations, set);
        this.amountReservations = set;
    }

    protected void _persistence_initialize_by_vh() {
        if (this._persistence_by_vh == null) {
            this._persistence_by_vh = new ValueHolder((Object)this.by);
            this._persistence_by_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_by_vh() {
        BasicUser basicUser;
        this._persistence_initialize_by_vh();
        if ((this._persistence_by_vh.isCoordinatedWithProperty() || this._persistence_by_vh.isNewlyWeavedValueHolder()) && (basicUser = this._persistence_get_by()) != this._persistence_by_vh.getValue()) {
            this._persistence_set_by(basicUser);
        }
        return this._persistence_by_vh;
    }

    public void _persistence_set_by_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_by_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasicUser basicUser = this._persistence_get_by();
            if (basicUser != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_by((BasicUser)object);
            }
        } else {
            this.by = null;
        }
    }

    public BasicUser _persistence_get_by() {
        this._persistence_checkFetched("by");
        this._persistence_initialize_by_vh();
        this.by = (BasicUser)this._persistence_by_vh.getValue();
        return this.by;
    }

    public void _persistence_set_by(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("by");
        this._persistence_initialize_by_vh();
        this.by = (BasicUser)this._persistence_by_vh.getValue();
        this._persistence_propertyChange("by", this.by, basicUser);
        this.by = basicUser;
        this._persistence_by_vh.setValue((Object)basicUser);
    }

    public Long _persistence_get_typeId() {
        this._persistence_checkFetched("typeId");
        return this.typeId;
    }

    public void _persistence_set_typeId(Long l) {
        this._persistence_checkFetchedForSet("typeId");
        this._persistence_propertyChange("typeId", this.typeId, l);
        this.typeId = l;
    }

    public String _persistence_get_redeemOnWeekDays() {
        this._persistence_checkFetched("redeemOnWeekDays");
        return this.redeemOnWeekDays;
    }

    public void _persistence_set_redeemOnWeekDays(String string) {
        this._persistence_checkFetchedForSet("redeemOnWeekDays");
        this._persistence_propertyChange("redeemOnWeekDays", this.redeemOnWeekDays, string);
        this.redeemOnWeekDays = string;
    }

    public Date _persistence_get_expirationDate() {
        this._persistence_checkFetched("expirationDate");
        return this.expirationDate;
    }

    public void _persistence_set_expirationDate(Date date) {
        this._persistence_checkFetchedForSet("expirationDate");
        this._persistence_propertyChange("expirationDate", this.expirationDate, date);
        this.expirationDate = date;
    }

    public Set _persistence_get_customValues() {
        this._persistence_checkFetched("customValues");
        return this.customValues;
    }

    public void _persistence_set_customValues(Set set) {
        this._persistence_checkFetchedForSet("customValues");
        this._persistence_propertyChange("customValues", this.customValues, set);
        this.customValues = set;
    }
}

