/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.marketplace;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.FixedScale;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.marketplace.AdAddress;
import org.cyclos.entities.marketplace.AdCategory;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.marketplace.AdCustomFieldPossibleValue;
import org.cyclos.entities.marketplace.AdCustomFieldPossibleValueCategory;
import org.cyclos.entities.marketplace.AdCustomFieldValue;
import org.cyclos.entities.marketplace.AdHistoryLog;
import org.cyclos.entities.marketplace.AdImage;
import org.cyclos.entities.marketplace.AdQuestion;
import org.cyclos.entities.marketplace.AdWebShop;
import org.cyclos.entities.marketplace.NotifiedAdInterest;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.ImageOwner;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.model.marketplace.advertisements.AdStatus;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.advertisements.AdWebShopStockType;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="ads", indexes={@Index(name="ix_ads_creation_date", columnList="creation_date"), @Index(name="ix_ads_price_amount", columnList="price_amount"), @Index(name="ix_ads_product_number", unique=true, columnList="owner_id, lower(product_number)")})
@DiscriminatorColumn(name="subclass")
public abstract class BasicAd
extends NamedEntity
implements HasCurrency,
ImageOwner<BasicAd, AdImage>,
EntityWithCustomValues<AdCustomField, AdCustomFieldPossibleValueCategory, AdCustomFieldPossibleValue, AdCustomFieldValue>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @OneToMany(mappedBy="ad", cascade={CascadeType.REMOVE})
    private Set<AdQuestion> questions = new HashSet<AdQuestion>();
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creation_date")
    @ReadOnlyFromDTO(onInsert=false, onUpdate=true)
    private Date creationDate;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="subclass", insertable=false, updatable=false)
    private AdType discriminator;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", nullable=false)
    private AdStatus status;
    @OwnerEntity
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="owner_id", nullable=false)
    @ReadOnlyFromDTO(onInsert=false, onUpdate=true)
    private User owner;
    @Basic
    @Column(name="removed_from_owner", nullable=false)
    private boolean removedFromOwner;
    @Basic
    @Column(name="do_process", nullable=false)
    private boolean doProcess;
    @Basic
    @Column(name="expiration_notified", nullable=false)
    private boolean expirationNotified;
    @ManyToMany
    @JoinTable(name="ads_categories", joinColumns={@JoinColumn(name="ad_id")}, inverseJoinColumns={@JoinColumn(name="category_id")})
    private Set<AdCategory> categories = new HashSet<AdCategory>();
    @Basic
    @Column(name="price_amount")
    @CurrencyScale
    private BigDecimal priceAmount;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="currency_id")
    @ReadOnlyFromDTO(onInsert=false)
    private Currency priceCurrency;
    @Basic
    @Column(name="promotional_price")
    @CurrencyScale
    private BigDecimal promotionalPrice;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="begin", column=@Column(name="begin_promotional_price_period")), @AttributeOverride(name="end", column=@Column(name="end_promotional_price_period"))})
    private DatePeriod promotionalPeriod;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="begin", column=@Column(name="begin_publication_period")), @AttributeOverride(name="end", column=@Column(name="end_publication_period"))})
    private DatePeriod publicationPeriod;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="image_id")
    private AdImage image;
    @OneToMany(mappedBy="ad")
    @OrderBy(value="order")
    private List<AdImage> images = new ArrayList<AdImage>();
    @Basic
    @Lob
    @Column(name="description")
    private String description;
    @Basic
    @Lob
    @Column(name="auth_notes")
    private String authorizationNotes;
    @Basic
    @Column(name="last_modified")
    @Temporal(value=TemporalType.TIMESTAMP)
    @ReadOnlyFromDTO
    private Date lastModified;
    @Basic
    @Column(name="deleted_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deletedDate;
    @OneToMany(mappedBy="owner", cascade={CascadeType.ALL})
    private Set<AdCustomFieldValue> customValues = new HashSet<AdCustomFieldValue>();
    @OneToMany(mappedBy="ad", cascade={CascadeType.REMOVE})
    private Set<AdHistoryLog> adHistory = new HashSet<AdHistoryLog>();
    @ManyToMany
    @JoinTable(name="ads_addresses", joinColumns={@JoinColumn(name="ad_id")}, inverseJoinColumns={@JoinColumn(name="address_id")})
    private Set<UserAddress> addresses = new HashSet<UserAddress>();
    @OneToMany(mappedBy="ad")
    private Set<AdAddress> adAddresses = new HashSet<AdAddress>();
    @Basic
    @Column(name="stock_quantity")
    @FixedScale(value=2)
    protected BigDecimal stockQuantity;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="stock_type")
    protected AdWebShopStockType stockType = AdWebShopStockType.AVAILABLE;
    @OneToMany(mappedBy="ad", cascade={CascadeType.REMOVE})
    private Set<NotifiedAdInterest> notifiedAdInterests;
    @ManyToMany(mappedBy="favoriteAds")
    private Set<BasicUser> favoriteFor = new HashSet<BasicUser>();
    @Transient
    private List<TempImage> uploadedImages;
    static final long serialVersionUID = -2544050184492271295L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_owner_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_image_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_priceCurrency_vh;

    public static AdStatus getActualStatus(DatePeriod datePeriod, boolean bl, Date date, AdStatus adStatus) {
        Date date2 = DateHelper.now();
        if (bl || date != null) {
            return AdStatus.DISABLED;
        }
        if (ObjectHelper.isOneOf((Object)adStatus, (Object[])new Object[]{AdStatus.ACTIVE, AdStatus.EXPIRED, AdStatus.SCHEDULED})) {
            if (datePeriod != null && date2.before(datePeriod.getBegin())) {
                return AdStatus.SCHEDULED;
            }
            if (datePeriod != null && date2.after(datePeriod.getEnd())) {
                return AdStatus.EXPIRED;
            }
            return AdStatus.ACTIVE;
        }
        return adStatus;
    }

    public Set<AdAddress> getAdAddresses() {
        return this._persistence_get_adAddresses();
    }

    public Set<UserAddress> getAddresses() {
        return this._persistence_get_addresses();
    }

    public Set<AdHistoryLog> getAdHistory() {
        return this._persistence_get_adHistory();
    }

    public abstract AdType getAdType();

    public String getAuthorizationNotes() {
        return this._persistence_get_authorizationNotes();
    }

    public Set<AdCategory> getCategories() {
        return this._persistence_get_categories();
    }

    public Date getCreationDate() {
        return this._persistence_get_creationDate();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_priceCurrency();
    }

    @CurrencyScale
    public BigDecimal getCurrentPrice() {
        if (this.isPromotionalPeriodActive() && this._persistence_get_promotionalPrice() != null) {
            return this._persistence_get_promotionalPrice();
        }
        return this._persistence_get_priceAmount();
    }

    @Override
    public Class<AdCustomField> getCustomFieldClass() {
        return AdCustomField.class;
    }

    @Override
    public Class<AdCustomFieldValue> getCustomFieldValueClass() {
        return AdCustomFieldValue.class;
    }

    @Override
    public Set<AdCustomFieldValue> getCustomValues() {
        return this._persistence_get_customValues();
    }

    public Date getDeletedDate() {
        return this._persistence_get_deletedDate();
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public AdType getDiscriminator() {
        return this._persistence_get_discriminator();
    }

    @Override
    public AdImage getImage() {
        return this._persistence_get_image();
    }

    public int getImageCount() {
        return CollectionHelper.size((Collection)this._persistence_get_images());
    }

    @Override
    public List<AdImage> getImages() {
        return this._persistence_get_images();
    }

    public Date getLastModified() {
        return this._persistence_get_lastModified();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_owner().getNetwork();
    }

    public Set<NotifiedAdInterest> getNotifiedAdInterests() {
        return this._persistence_get_notifiedAdInterests();
    }

    public Integer getNumberOfImages() {
        if (this._persistence_get_images() != null) {
            return this._persistence_get_images().size();
        }
        return 0;
    }

    public User getOwner() {
        return this._persistence_get_owner();
    }

    public AdStatus getPersistedStatus() {
        return this._persistence_get_status();
    }

    public CurrencyAmount getPrice() {
        if (this._persistence_get_priceAmount() == null) {
            return null;
        }
        return new CurrencyAmount(this._persistence_get_priceCurrency(), this._persistence_get_priceAmount());
    }

    public DatePeriod getPromotionalPeriod() {
        return this._persistence_get_promotionalPeriod();
    }

    public BigDecimal getPromotionalPrice() {
        return this._persistence_get_promotionalPrice();
    }

    public DatePeriod getPublicationPeriod() {
        return this._persistence_get_publicationPeriod();
    }

    public Set<AdQuestion> getQuestions() {
        return this._persistence_get_questions();
    }

    public AdCategory getSingleCategory() {
        return CollectionHelper.size((Collection)this._persistence_get_categories()) == 1 ? (AdCategory)CollectionHelper.first((Iterable)this._persistence_get_categories()) : null;
    }

    public AdStatus getStatus() {
        return BasicAd.getActualStatus(this._persistence_get_publicationPeriod(), this._persistence_get_removedFromOwner(), this._persistence_get_deletedDate(), this._persistence_get_status());
    }

    public AdType getType() {
        AdType adType = AdType.ADVERTISEMENT;
        if (this instanceof AdWebShop) {
            adType = AdType.WEB_SHOP;
        }
        return adType;
    }

    public List<TempImage> getUploadedImages() {
        return this.uploadedImages;
    }

    public boolean isAdInterestNotified() {
        return CollectionHelper.isNotEmpty((Iterable)this._persistence_get_notifiedAdInterests());
    }

    public boolean isDoProcess() {
        return this._persistence_get_doProcess();
    }

    public boolean isExpirationNotified() {
        return this._persistence_get_expirationNotified();
    }

    public boolean isHidden() {
        return this._persistence_get_status() == AdStatus.HIDDEN;
    }

    public abstract boolean isInStock();

    public boolean isPromotionalPeriodActive() {
        return DateHelper.includes((Date)(this._persistence_get_promotionalPeriod() == null ? null : this._persistence_get_promotionalPeriod().getBegin()), (Date)(this._persistence_get_promotionalPeriod() == null ? null : this._persistence_get_promotionalPeriod().getEnd()), (Date)new Date(), (boolean)false);
    }

    public boolean isRemovedFromOwner() {
        return this._persistence_get_removedFromOwner();
    }

    public void setAdAddresses(Set<AdAddress> set) {
        this._persistence_set_adAddresses(set);
    }

    public void setAddresses(Set<UserAddress> set) {
        this._persistence_set_addresses(set);
    }

    public void setAdHistory(Set<AdHistoryLog> set) {
        this._persistence_set_adHistory(set);
    }

    public void setAuthorizationNotes(String string) {
        this._persistence_set_authorizationNotes(string);
    }

    public void setCategories(Set<AdCategory> set) {
        this._persistence_set_categories(set);
    }

    public void setCreationDate(Date date) {
        this._persistence_set_creationDate(date);
    }

    public void setCustomValues(Set<AdCustomFieldValue> set) {
        this._persistence_set_customValues(set);
    }

    public void setDeletedDate(Date date) {
        this._persistence_set_deletedDate(date);
    }

    public void setDescription(String string) {
        this._persistence_set_description(string);
    }

    public void setDoProcess(boolean bl) {
        this._persistence_set_doProcess(bl);
    }

    public void setExpirationNotified(boolean bl) {
        this._persistence_set_expirationNotified(bl);
    }

    @Override
    public void setImage(AdImage adImage) {
        this._persistence_set_image(adImage);
    }

    @Override
    public void setImages(List<AdImage> list) {
        this._persistence_set_images(list);
    }

    public void setLastModified(Date date) {
        this._persistence_set_lastModified(date);
    }

    public void setOwner(User user) {
        this._persistence_set_owner(user);
    }

    public void setPrice(CurrencyAmount currencyAmount) {
        this._persistence_set_priceAmount(currencyAmount == null ? null : currencyAmount.getAmount());
        this._persistence_set_priceCurrency(currencyAmount == null ? null : currencyAmount.getCurrency());
    }

    public void setPromotionalPeriod(DatePeriod datePeriod) {
        this._persistence_set_promotionalPeriod(datePeriod);
    }

    public void setPromotionalPrice(BigDecimal bigDecimal) {
        this._persistence_set_promotionalPrice(bigDecimal);
    }

    public void setPublicationPeriod(DatePeriod datePeriod) {
        this._persistence_set_publicationPeriod(datePeriod);
    }

    public void setQuestions(Set<AdQuestion> set) {
        this._persistence_set_questions(set);
    }

    public void setRemovedFromOwner(boolean bl) {
        this._persistence_set_removedFromOwner(bl);
    }

    public void setStatus(AdStatus adStatus) {
        this._persistence_set_status(adStatus);
    }

    public void setUploadedImages(List<TempImage> list) {
        this.uploadedImages = list;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_owner_vh != null) {
            this._persistence_owner_vh = (WeavedAttributeValueHolderInterface)this._persistence_owner_vh.clone();
        }
        if (this._persistence_image_vh != null) {
            this._persistence_image_vh = (WeavedAttributeValueHolderInterface)this._persistence_image_vh.clone();
        }
        if (this._persistence_priceCurrency_vh != null) {
            this._persistence_priceCurrency_vh = (WeavedAttributeValueHolderInterface)this._persistence_priceCurrency_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new BasicAd();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "promotionalPeriod") {
            return this.promotionalPeriod;
        }
        if (string == "addresses") {
            return this.addresses;
        }
        if (string == "doProcess") {
            return this.doProcess;
        }
        if (string == "promotionalPrice") {
            return this.promotionalPrice;
        }
        if (string == "questions") {
            return this.questions;
        }
        if (string == "notifiedAdInterests") {
            return this.notifiedAdInterests;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "stockQuantity") {
            return this.stockQuantity;
        }
        if (string == "adAddresses") {
            return this.adAddresses;
        }
        if (string == "publicationPeriod") {
            return this.publicationPeriod;
        }
        if (string == "removedFromOwner") {
            return this.removedFromOwner;
        }
        if (string == "categories") {
            return this.categories;
        }
        if (string == "priceAmount") {
            return this.priceAmount;
        }
        if (string == "customValues") {
            return this.customValues;
        }
        if (string == "owner") {
            return this.owner;
        }
        if (string == "image") {
            return this.image;
        }
        if (string == "images") {
            return this.images;
        }
        if (string == "stockType") {
            return this.stockType;
        }
        if (string == "favoriteFor") {
            return this.favoriteFor;
        }
        if (string == "expirationNotified") {
            return this.expirationNotified;
        }
        if (string == "creationDate") {
            return this.creationDate;
        }
        if (string == "adHistory") {
            return this.adHistory;
        }
        if (string == "discriminator") {
            return this.discriminator;
        }
        if (string == "priceCurrency") {
            return this.priceCurrency;
        }
        if (string == "authorizationNotes") {
            return this.authorizationNotes;
        }
        if (string == "deletedDate") {
            return this.deletedDate;
        }
        if (string == "lastModified") {
            return this.lastModified;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "promotionalPeriod") {
            this.promotionalPeriod = (DatePeriod)object;
            return;
        }
        if (string == "addresses") {
            this.addresses = (Set)object;
            return;
        }
        if (string == "doProcess") {
            this.doProcess = (Boolean)object;
            return;
        }
        if (string == "promotionalPrice") {
            this.promotionalPrice = (BigDecimal)object;
            return;
        }
        if (string == "questions") {
            this.questions = (Set)object;
            return;
        }
        if (string == "notifiedAdInterests") {
            this.notifiedAdInterests = (Set)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "stockQuantity") {
            this.stockQuantity = (BigDecimal)object;
            return;
        }
        if (string == "adAddresses") {
            this.adAddresses = (Set)object;
            return;
        }
        if (string == "publicationPeriod") {
            this.publicationPeriod = (DatePeriod)object;
            return;
        }
        if (string == "removedFromOwner") {
            this.removedFromOwner = (Boolean)object;
            return;
        }
        if (string == "categories") {
            this.categories = (Set)object;
            return;
        }
        if (string == "priceAmount") {
            this.priceAmount = (BigDecimal)object;
            return;
        }
        if (string == "customValues") {
            this.customValues = (Set)object;
            return;
        }
        if (string == "owner") {
            this.owner = (User)object;
            return;
        }
        if (string == "image") {
            this.image = (AdImage)object;
            return;
        }
        if (string == "images") {
            this.images = (List)object;
            return;
        }
        if (string == "stockType") {
            this.stockType = (AdWebShopStockType)object;
            return;
        }
        if (string == "favoriteFor") {
            this.favoriteFor = (Set)object;
            return;
        }
        if (string == "expirationNotified") {
            this.expirationNotified = (Boolean)object;
            return;
        }
        if (string == "creationDate") {
            this.creationDate = (Date)object;
            return;
        }
        if (string == "adHistory") {
            this.adHistory = (Set)object;
            return;
        }
        if (string == "discriminator") {
            this.discriminator = (AdType)object;
            return;
        }
        if (string == "priceCurrency") {
            this.priceCurrency = (Currency)object;
            return;
        }
        if (string == "authorizationNotes") {
            this.authorizationNotes = (String)object;
            return;
        }
        if (string == "deletedDate") {
            this.deletedDate = (Date)object;
            return;
        }
        if (string == "lastModified") {
            this.lastModified = (Date)object;
            return;
        }
        if (string == "status") {
            this.status = (AdStatus)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public DatePeriod _persistence_get_promotionalPeriod() {
        this._persistence_checkFetched("promotionalPeriod");
        return this.promotionalPeriod;
    }

    public void _persistence_set_promotionalPeriod(DatePeriod datePeriod) {
        this._persistence_checkFetchedForSet("promotionalPeriod");
        this._persistence_propertyChange("promotionalPeriod", this.promotionalPeriod, datePeriod);
        this.promotionalPeriod = datePeriod;
    }

    public Set _persistence_get_addresses() {
        this._persistence_checkFetched("addresses");
        return this.addresses;
    }

    public void _persistence_set_addresses(Set set) {
        this._persistence_checkFetchedForSet("addresses");
        this._persistence_propertyChange("addresses", this.addresses, set);
        this.addresses = set;
    }

    public boolean _persistence_get_doProcess() {
        this._persistence_checkFetched("doProcess");
        return this.doProcess;
    }

    public void _persistence_set_doProcess(boolean bl) {
        this._persistence_checkFetchedForSet("doProcess");
        this._persistence_propertyChange("doProcess", new Boolean(this.doProcess), new Boolean(bl));
        this.doProcess = bl;
    }

    public BigDecimal _persistence_get_promotionalPrice() {
        this._persistence_checkFetched("promotionalPrice");
        return this.promotionalPrice;
    }

    public void _persistence_set_promotionalPrice(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("promotionalPrice");
        this._persistence_propertyChange("promotionalPrice", this.promotionalPrice, bigDecimal);
        this.promotionalPrice = bigDecimal;
    }

    public Set _persistence_get_questions() {
        this._persistence_checkFetched("questions");
        return this.questions;
    }

    public void _persistence_set_questions(Set set) {
        this._persistence_checkFetchedForSet("questions");
        this._persistence_propertyChange("questions", this.questions, set);
        this.questions = set;
    }

    public Set _persistence_get_notifiedAdInterests() {
        this._persistence_checkFetched("notifiedAdInterests");
        return this.notifiedAdInterests;
    }

    public void _persistence_set_notifiedAdInterests(Set set) {
        this._persistence_checkFetchedForSet("notifiedAdInterests");
        this._persistence_propertyChange("notifiedAdInterests", this.notifiedAdInterests, set);
        this.notifiedAdInterests = set;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public BigDecimal _persistence_get_stockQuantity() {
        this._persistence_checkFetched("stockQuantity");
        return this.stockQuantity;
    }

    public void _persistence_set_stockQuantity(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("stockQuantity");
        this._persistence_propertyChange("stockQuantity", this.stockQuantity, bigDecimal);
        this.stockQuantity = bigDecimal;
    }

    public Set _persistence_get_adAddresses() {
        this._persistence_checkFetched("adAddresses");
        return this.adAddresses;
    }

    public void _persistence_set_adAddresses(Set set) {
        this._persistence_checkFetchedForSet("adAddresses");
        this._persistence_propertyChange("adAddresses", this.adAddresses, set);
        this.adAddresses = set;
    }

    public DatePeriod _persistence_get_publicationPeriod() {
        this._persistence_checkFetched("publicationPeriod");
        return this.publicationPeriod;
    }

    public void _persistence_set_publicationPeriod(DatePeriod datePeriod) {
        this._persistence_checkFetchedForSet("publicationPeriod");
        this._persistence_propertyChange("publicationPeriod", this.publicationPeriod, datePeriod);
        this.publicationPeriod = datePeriod;
    }

    public boolean _persistence_get_removedFromOwner() {
        this._persistence_checkFetched("removedFromOwner");
        return this.removedFromOwner;
    }

    public void _persistence_set_removedFromOwner(boolean bl) {
        this._persistence_checkFetchedForSet("removedFromOwner");
        this._persistence_propertyChange("removedFromOwner", new Boolean(this.removedFromOwner), new Boolean(bl));
        this.removedFromOwner = bl;
    }

    public Set _persistence_get_categories() {
        this._persistence_checkFetched("categories");
        return this.categories;
    }

    public void _persistence_set_categories(Set set) {
        this._persistence_checkFetchedForSet("categories");
        this._persistence_propertyChange("categories", this.categories, set);
        this.categories = set;
    }

    public BigDecimal _persistence_get_priceAmount() {
        this._persistence_checkFetched("priceAmount");
        return this.priceAmount;
    }

    public void _persistence_set_priceAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("priceAmount");
        this._persistence_propertyChange("priceAmount", this.priceAmount, bigDecimal);
        this.priceAmount = bigDecimal;
    }

    public Set _persistence_get_customValues() {
        this._persistence_checkFetched("customValues");
        return this.customValues;
    }

    public void _persistence_set_customValues(Set set) {
        this._persistence_checkFetchedForSet("customValues");
        this._persistence_propertyChange("customValues", this.customValues, set);
        this.customValues = set;
    }

    protected void _persistence_initialize_owner_vh() {
        if (this._persistence_owner_vh == null) {
            this._persistence_owner_vh = new ValueHolder((Object)this.owner);
            this._persistence_owner_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_owner_vh() {
        User user;
        this._persistence_initialize_owner_vh();
        if ((this._persistence_owner_vh.isCoordinatedWithProperty() || this._persistence_owner_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_owner()) != this._persistence_owner_vh.getValue()) {
            this._persistence_set_owner(user);
        }
        return this._persistence_owner_vh;
    }

    public void _persistence_set_owner_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_owner_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_owner();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_owner((User)object);
            }
        } else {
            this.owner = null;
        }
    }

    public User _persistence_get_owner() {
        this._persistence_checkFetched("owner");
        this._persistence_initialize_owner_vh();
        this.owner = (User)this._persistence_owner_vh.getValue();
        return this.owner;
    }

    public void _persistence_set_owner(User user) {
        this._persistence_checkFetchedForSet("owner");
        this._persistence_initialize_owner_vh();
        this.owner = (User)this._persistence_owner_vh.getValue();
        this._persistence_propertyChange("owner", this.owner, user);
        this.owner = user;
        this._persistence_owner_vh.setValue((Object)user);
    }

    protected void _persistence_initialize_image_vh() {
        if (this._persistence_image_vh == null) {
            this._persistence_image_vh = new ValueHolder((Object)this.image);
            this._persistence_image_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_image_vh() {
        AdImage adImage;
        this._persistence_initialize_image_vh();
        if ((this._persistence_image_vh.isCoordinatedWithProperty() || this._persistence_image_vh.isNewlyWeavedValueHolder()) && (adImage = this._persistence_get_image()) != this._persistence_image_vh.getValue()) {
            this._persistence_set_image(adImage);
        }
        return this._persistence_image_vh;
    }

    public void _persistence_set_image_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_image_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AdImage adImage = this._persistence_get_image();
            if (adImage != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_image((AdImage)object);
            }
        } else {
            this.image = null;
        }
    }

    public AdImage _persistence_get_image() {
        this._persistence_checkFetched("image");
        this._persistence_initialize_image_vh();
        this.image = (AdImage)this._persistence_image_vh.getValue();
        return this.image;
    }

    public void _persistence_set_image(AdImage adImage) {
        this._persistence_checkFetchedForSet("image");
        this._persistence_initialize_image_vh();
        this.image = (AdImage)this._persistence_image_vh.getValue();
        this._persistence_propertyChange("image", this.image, adImage);
        this.image = adImage;
        this._persistence_image_vh.setValue((Object)adImage);
    }

    public List _persistence_get_images() {
        this._persistence_checkFetched("images");
        return this.images;
    }

    public void _persistence_set_images(List list) {
        this._persistence_checkFetchedForSet("images");
        this._persistence_propertyChange("images", this.images, list);
        this.images = list;
    }

    public AdWebShopStockType _persistence_get_stockType() {
        this._persistence_checkFetched("stockType");
        return this.stockType;
    }

    public void _persistence_set_stockType(AdWebShopStockType adWebShopStockType) {
        this._persistence_checkFetchedForSet("stockType");
        this._persistence_propertyChange("stockType", this.stockType, adWebShopStockType);
        this.stockType = adWebShopStockType;
    }

    public Set _persistence_get_favoriteFor() {
        this._persistence_checkFetched("favoriteFor");
        return this.favoriteFor;
    }

    public void _persistence_set_favoriteFor(Set set) {
        this._persistence_checkFetchedForSet("favoriteFor");
        this._persistence_propertyChange("favoriteFor", this.favoriteFor, set);
        this.favoriteFor = set;
    }

    public boolean _persistence_get_expirationNotified() {
        this._persistence_checkFetched("expirationNotified");
        return this.expirationNotified;
    }

    public void _persistence_set_expirationNotified(boolean bl) {
        this._persistence_checkFetchedForSet("expirationNotified");
        this._persistence_propertyChange("expirationNotified", new Boolean(this.expirationNotified), new Boolean(bl));
        this.expirationNotified = bl;
    }

    public Date _persistence_get_creationDate() {
        this._persistence_checkFetched("creationDate");
        return this.creationDate;
    }

    public void _persistence_set_creationDate(Date date) {
        this._persistence_checkFetchedForSet("creationDate");
        this._persistence_propertyChange("creationDate", this.creationDate, date);
        this.creationDate = date;
    }

    public Set _persistence_get_adHistory() {
        this._persistence_checkFetched("adHistory");
        return this.adHistory;
    }

    public void _persistence_set_adHistory(Set set) {
        this._persistence_checkFetchedForSet("adHistory");
        this._persistence_propertyChange("adHistory", this.adHistory, set);
        this.adHistory = set;
    }

    public AdType _persistence_get_discriminator() {
        this._persistence_checkFetched("discriminator");
        return this.discriminator;
    }

    public void _persistence_set_discriminator(AdType adType) {
        this._persistence_checkFetchedForSet("discriminator");
        this._persistence_propertyChange("discriminator", this.discriminator, adType);
        this.discriminator = adType;
    }

    protected void _persistence_initialize_priceCurrency_vh() {
        if (this._persistence_priceCurrency_vh == null) {
            this._persistence_priceCurrency_vh = new ValueHolder((Object)this.priceCurrency);
            this._persistence_priceCurrency_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_priceCurrency_vh() {
        Currency currency;
        this._persistence_initialize_priceCurrency_vh();
        if ((this._persistence_priceCurrency_vh.isCoordinatedWithProperty() || this._persistence_priceCurrency_vh.isNewlyWeavedValueHolder()) && (currency = this._persistence_get_priceCurrency()) != this._persistence_priceCurrency_vh.getValue()) {
            this._persistence_set_priceCurrency(currency);
        }
        return this._persistence_priceCurrency_vh;
    }

    public void _persistence_set_priceCurrency_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_priceCurrency_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Currency currency = this._persistence_get_priceCurrency();
            if (currency != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_priceCurrency((Currency)object);
            }
        } else {
            this.priceCurrency = null;
        }
    }

    public Currency _persistence_get_priceCurrency() {
        this._persistence_checkFetched("priceCurrency");
        this._persistence_initialize_priceCurrency_vh();
        this.priceCurrency = (Currency)this._persistence_priceCurrency_vh.getValue();
        return this.priceCurrency;
    }

    public void _persistence_set_priceCurrency(Currency currency) {
        this._persistence_checkFetchedForSet("priceCurrency");
        this._persistence_initialize_priceCurrency_vh();
        this.priceCurrency = (Currency)this._persistence_priceCurrency_vh.getValue();
        this._persistence_propertyChange("priceCurrency", this.priceCurrency, currency);
        this.priceCurrency = currency;
        this._persistence_priceCurrency_vh.setValue((Object)currency);
    }

    public String _persistence_get_authorizationNotes() {
        this._persistence_checkFetched("authorizationNotes");
        return this.authorizationNotes;
    }

    public void _persistence_set_authorizationNotes(String string) {
        this._persistence_checkFetchedForSet("authorizationNotes");
        this._persistence_propertyChange("authorizationNotes", this.authorizationNotes, string);
        this.authorizationNotes = string;
    }

    public Date _persistence_get_deletedDate() {
        this._persistence_checkFetched("deletedDate");
        return this.deletedDate;
    }

    public void _persistence_set_deletedDate(Date date) {
        this._persistence_checkFetchedForSet("deletedDate");
        this._persistence_propertyChange("deletedDate", this.deletedDate, date);
        this.deletedDate = date;
    }

    public Date _persistence_get_lastModified() {
        this._persistence_checkFetched("lastModified");
        return this.lastModified;
    }

    public void _persistence_set_lastModified(Date date) {
        this._persistence_checkFetchedForSet("lastModified");
        this._persistence_propertyChange("lastModified", this.lastModified, date);
        this.lastModified = date;
    }

    public AdStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(AdStatus adStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, adStatus);
        this.status = adStatus;
    }
}

