/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.marketplace;

import java.math.BigDecimal;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.FixedScale;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.marketplace.AdWebShop;
import org.cyclos.entities.marketplace.Order;
import org.cyclos.entities.system.Network;
import org.cyclos.model.marketplace.webshoporders.QuantityAdjustment;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="ad_order_products")
public class OrderProduct
extends BaseEntity
implements HasCurrency,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="order_id", nullable=false, updatable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private Order order;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ad_id", nullable=false, updatable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private AdWebShop product;
    @Basic
    @Column(name="product_quantity", nullable=false)
    @FixedScale(value=2)
    private BigDecimal quantity;
    @Basic
    @Column(name="price")
    @CurrencyScale
    private BigDecimal price;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="quantity_adjustment")
    private QuantityAdjustment quantityAdjustment;
    @Basic
    @Column(name="product_index", nullable=false)
    private int productIndex;
    static final long serialVersionUID = 2600485127642974235L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_product_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_order_vh;

    @Override
    public Currency getCurrency() {
        return this._persistence_get_order().getCurrency();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_order().getNetwork();
    }

    public Order getOrder() {
        return this._persistence_get_order();
    }

    public BigDecimal getPrice() {
        return this._persistence_get_price();
    }

    public AdWebShop getProduct() {
        return this._persistence_get_product();
    }

    public int getProductIndex() {
        return this._persistence_get_productIndex();
    }

    public BigDecimal getProductTotal() {
        return this._persistence_get_price() == null || this._persistence_get_quantity() == null ? BigDecimal.ZERO : this._persistence_get_price().multiply(this._persistence_get_quantity());
    }

    public BigDecimal getQuantity() {
        return this._persistence_get_quantity();
    }

    public QuantityAdjustment getQuantityAdjustment() {
        return this._persistence_get_quantityAdjustment();
    }

    public void setOrder(Order order) {
        this._persistence_set_order(order);
    }

    public void setPrice(BigDecimal bigDecimal) {
        this._persistence_set_price(bigDecimal);
    }

    public void setProduct(AdWebShop adWebShop) {
        this._persistence_set_product(adWebShop);
    }

    public void setProductIndex(int n) {
        this._persistence_set_productIndex(n);
    }

    public void setQuantity(BigDecimal bigDecimal) {
        this._persistence_set_quantity(bigDecimal);
    }

    public void setQuantityAdjustment(QuantityAdjustment quantityAdjustment) {
        this._persistence_set_quantityAdjustment(quantityAdjustment);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_product_vh != null) {
            this._persistence_product_vh = (WeavedAttributeValueHolderInterface)this._persistence_product_vh.clone();
        }
        if (this._persistence_order_vh != null) {
            this._persistence_order_vh = (WeavedAttributeValueHolderInterface)this._persistence_order_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new OrderProduct();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "product") {
            return this.product;
        }
        if (string == "quantity") {
            return this.quantity;
        }
        if (string == "productIndex") {
            return this.productIndex;
        }
        if (string == "price") {
            return this.price;
        }
        if (string == "quantityAdjustment") {
            return this.quantityAdjustment;
        }
        if (string == "order") {
            return this.order;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "product") {
            this.product = (AdWebShop)object;
            return;
        }
        if (string == "quantity") {
            this.quantity = (BigDecimal)object;
            return;
        }
        if (string == "productIndex") {
            this.productIndex = (Integer)object;
            return;
        }
        if (string == "price") {
            this.price = (BigDecimal)object;
            return;
        }
        if (string == "quantityAdjustment") {
            this.quantityAdjustment = (QuantityAdjustment)object;
            return;
        }
        if (string == "order") {
            this.order = (Order)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_product_vh() {
        if (this._persistence_product_vh == null) {
            this._persistence_product_vh = new ValueHolder((Object)this.product);
            this._persistence_product_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_product_vh() {
        AdWebShop adWebShop;
        this._persistence_initialize_product_vh();
        if ((this._persistence_product_vh.isCoordinatedWithProperty() || this._persistence_product_vh.isNewlyWeavedValueHolder()) && (adWebShop = this._persistence_get_product()) != this._persistence_product_vh.getValue()) {
            this._persistence_set_product(adWebShop);
        }
        return this._persistence_product_vh;
    }

    public void _persistence_set_product_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_product_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AdWebShop adWebShop = this._persistence_get_product();
            if (adWebShop != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_product((AdWebShop)object);
            }
        } else {
            this.product = null;
        }
    }

    public AdWebShop _persistence_get_product() {
        this._persistence_checkFetched("product");
        this._persistence_initialize_product_vh();
        this.product = (AdWebShop)this._persistence_product_vh.getValue();
        return this.product;
    }

    public void _persistence_set_product(AdWebShop adWebShop) {
        this._persistence_checkFetchedForSet("product");
        this._persistence_initialize_product_vh();
        this.product = (AdWebShop)this._persistence_product_vh.getValue();
        this._persistence_propertyChange("product", this.product, adWebShop);
        this.product = adWebShop;
        this._persistence_product_vh.setValue((Object)adWebShop);
    }

    public BigDecimal _persistence_get_quantity() {
        this._persistence_checkFetched("quantity");
        return this.quantity;
    }

    public void _persistence_set_quantity(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("quantity");
        this._persistence_propertyChange("quantity", this.quantity, bigDecimal);
        this.quantity = bigDecimal;
    }

    public int _persistence_get_productIndex() {
        this._persistence_checkFetched("productIndex");
        return this.productIndex;
    }

    public void _persistence_set_productIndex(int n) {
        this._persistence_checkFetchedForSet("productIndex");
        this._persistence_propertyChange("productIndex", new Integer(this.productIndex), new Integer(n));
        this.productIndex = n;
    }

    public BigDecimal _persistence_get_price() {
        this._persistence_checkFetched("price");
        return this.price;
    }

    public void _persistence_set_price(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("price");
        this._persistence_propertyChange("price", this.price, bigDecimal);
        this.price = bigDecimal;
    }

    public QuantityAdjustment _persistence_get_quantityAdjustment() {
        this._persistence_checkFetched("quantityAdjustment");
        return this.quantityAdjustment;
    }

    public void _persistence_set_quantityAdjustment(QuantityAdjustment quantityAdjustment) {
        this._persistence_checkFetchedForSet("quantityAdjustment");
        this._persistence_propertyChange("quantityAdjustment", this.quantityAdjustment, quantityAdjustment);
        this.quantityAdjustment = quantityAdjustment;
    }

    protected void _persistence_initialize_order_vh() {
        if (this._persistence_order_vh == null) {
            this._persistence_order_vh = new ValueHolder((Object)this.order);
            this._persistence_order_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_order_vh() {
        Order order;
        this._persistence_initialize_order_vh();
        if ((this._persistence_order_vh.isCoordinatedWithProperty() || this._persistence_order_vh.isNewlyWeavedValueHolder()) && (order = this._persistence_get_order()) != this._persistence_order_vh.getValue()) {
            this._persistence_set_order(order);
        }
        return this._persistence_order_vh;
    }

    public void _persistence_set_order_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_order_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Order order = this._persistence_get_order();
            if (order != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_order((Order)object);
            }
        } else {
            this.order = null;
        }
    }

    public Order _persistence_get_order() {
        this._persistence_checkFetched("order");
        this._persistence_initialize_order_vh();
        this.order = (Order)this._persistence_order_vh.getValue();
        return this.order;
    }

    public void _persistence_set_order(Order order) {
        this._persistence_checkFetchedForSet("order");
        this._persistence_initialize_order_vh();
        this.order = (Order)this._persistence_order_vh.getValue();
        this._persistence_propertyChange("order", this.order, order);
        this.order = order;
        this._persistence_order_vh.setValue((Object)order);
    }
}

