/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.messaging;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.messaging.MessageCategory;
import org.cyclos.entities.messaging.OutgoingMessage;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.User;
import org.cyclos.model.messaging.messages.MessageBox;
import org.cyclos.model.messaging.messages.MessageNature;
import org.cyclos.model.messaging.messages.MessageOwner;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="messages")
@DiscriminatorColumn(name="subclass")
public abstract class Message
extends NetworkedEntity
implements DefinesNetwork,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="date", updatable=false, nullable=false)
    private Date date;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="subclass", insertable=false, updatable=false)
    private MessageNature nature;
    @Basic
    @Lob
    @Column(name="subject", updatable=false)
    private String subject;
    @Basic
    @Column(name="is_read")
    private boolean read;
    @Basic
    @Column(name="is_replied")
    private boolean replied;
    @Basic
    @Column(name="conversation_id")
    private Long conversationId;
    @Basic
    @Column(name="removed_at")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date removedAt;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id", nullable=false)
    private Network network;
    @Basic
    @Lob
    @Column(name="body", updatable=false)
    private String body;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="message_owner")
    private MessageOwner messageOwner;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="owner_user_id", updatable=false)
    private User owner;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="category_id", updatable=false)
    private MessageCategory category;
    static final long serialVersionUID = 5560419915728654615L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_owner_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_category_vh;

    public String getBody() {
        return this._persistence_get_body();
    }

    public MessageCategory getCategory() {
        return this._persistence_get_category();
    }

    public Long getConversationId() {
        return this._persistence_get_conversationId();
    }

    public Date getDate() {
        return this._persistence_get_date();
    }

    public MessageBox getMessageBox() {
        if (this._persistence_get_removedAt() != null) {
            return MessageBox.TRASH;
        }
        if (this instanceof OutgoingMessage) {
            return MessageBox.SENT_ITEMS;
        }
        return MessageBox.INBOX;
    }

    public MessageOwner getMessageOwner() {
        return this._persistence_get_messageOwner();
    }

    public abstract MessageNature getNature();

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public User getOwner() {
        return this._persistence_get_owner();
    }

    public Date getRemovedAt() {
        return this._persistence_get_removedAt();
    }

    public String getSubject() {
        return this._persistence_get_subject();
    }

    public boolean isRead() {
        return this._persistence_get_read();
    }

    public boolean isRemoved() {
        return this._persistence_get_removedAt() != null;
    }

    public boolean isReplied() {
        return this._persistence_get_replied();
    }

    public void setBody(String string) {
        this._persistence_set_body(string);
    }

    public void setCategory(MessageCategory messageCategory) {
        this._persistence_set_category(messageCategory);
    }

    public void setConversationId(Long l) {
        this._persistence_set_conversationId(l);
    }

    public void setDate(Date date) {
        this._persistence_set_date(date);
    }

    public void setMessageOwner(MessageOwner messageOwner) {
        this._persistence_set_messageOwner(messageOwner);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setOwner(User user) {
        this._persistence_set_owner(user);
    }

    public void setRead(boolean bl) {
        this._persistence_set_read(bl);
    }

    public void setRemovedAt(Date date) {
        this._persistence_set_removedAt(date);
    }

    public void setReplied(boolean bl) {
        this._persistence_set_replied(bl);
    }

    public void setSubject(String string) {
        this._persistence_set_subject(string);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_owner_vh != null) {
            this._persistence_owner_vh = (WeavedAttributeValueHolderInterface)this._persistence_owner_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        if (this._persistence_category_vh != null) {
            this._persistence_category_vh = (WeavedAttributeValueHolderInterface)this._persistence_category_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Message();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "owner") {
            return this.owner;
        }
        if (string == "read") {
            return this.read;
        }
        if (string == "nature") {
            return this.nature;
        }
        if (string == "replied") {
            return this.replied;
        }
        if (string == "subject") {
            return this.subject;
        }
        if (string == "conversationId") {
            return this.conversationId;
        }
        if (string == "body") {
            return this.body;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "messageOwner") {
            return this.messageOwner;
        }
        if (string == "removedAt") {
            return this.removedAt;
        }
        if (string == "category") {
            return this.category;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (Date)object;
            return;
        }
        if (string == "owner") {
            this.owner = (User)object;
            return;
        }
        if (string == "read") {
            this.read = (Boolean)object;
            return;
        }
        if (string == "nature") {
            this.nature = (MessageNature)object;
            return;
        }
        if (string == "replied") {
            this.replied = (Boolean)object;
            return;
        }
        if (string == "subject") {
            this.subject = (String)object;
            return;
        }
        if (string == "conversationId") {
            this.conversationId = (Long)object;
            return;
        }
        if (string == "body") {
            this.body = (String)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "messageOwner") {
            this.messageOwner = (MessageOwner)object;
            return;
        }
        if (string == "removedAt") {
            this.removedAt = (Date)object;
            return;
        }
        if (string == "category") {
            this.category = (MessageCategory)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(Date date) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, date);
        this.date = date;
    }

    protected void _persistence_initialize_owner_vh() {
        if (this._persistence_owner_vh == null) {
            this._persistence_owner_vh = new ValueHolder((Object)this.owner);
            this._persistence_owner_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_owner_vh() {
        User user;
        this._persistence_initialize_owner_vh();
        if ((this._persistence_owner_vh.isCoordinatedWithProperty() || this._persistence_owner_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_owner()) != this._persistence_owner_vh.getValue()) {
            this._persistence_set_owner(user);
        }
        return this._persistence_owner_vh;
    }

    public void _persistence_set_owner_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_owner_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_owner();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_owner((User)object);
            }
        } else {
            this.owner = null;
        }
    }

    public User _persistence_get_owner() {
        this._persistence_checkFetched("owner");
        this._persistence_initialize_owner_vh();
        this.owner = (User)this._persistence_owner_vh.getValue();
        return this.owner;
    }

    public void _persistence_set_owner(User user) {
        this._persistence_checkFetchedForSet("owner");
        this._persistence_initialize_owner_vh();
        this.owner = (User)this._persistence_owner_vh.getValue();
        this._persistence_propertyChange("owner", this.owner, user);
        this.owner = user;
        this._persistence_owner_vh.setValue((Object)user);
    }

    public boolean _persistence_get_read() {
        this._persistence_checkFetched("read");
        return this.read;
    }

    public void _persistence_set_read(boolean bl) {
        this._persistence_checkFetchedForSet("read");
        this._persistence_propertyChange("read", new Boolean(this.read), new Boolean(bl));
        this.read = bl;
    }

    public MessageNature _persistence_get_nature() {
        this._persistence_checkFetched("nature");
        return this.nature;
    }

    public void _persistence_set_nature(MessageNature messageNature) {
        this._persistence_checkFetchedForSet("nature");
        this._persistence_propertyChange("nature", this.nature, messageNature);
        this.nature = messageNature;
    }

    public boolean _persistence_get_replied() {
        this._persistence_checkFetched("replied");
        return this.replied;
    }

    public void _persistence_set_replied(boolean bl) {
        this._persistence_checkFetchedForSet("replied");
        this._persistence_propertyChange("replied", new Boolean(this.replied), new Boolean(bl));
        this.replied = bl;
    }

    public String _persistence_get_subject() {
        this._persistence_checkFetched("subject");
        return this.subject;
    }

    public void _persistence_set_subject(String string) {
        this._persistence_checkFetchedForSet("subject");
        this._persistence_propertyChange("subject", this.subject, string);
        this.subject = string;
    }

    public Long _persistence_get_conversationId() {
        this._persistence_checkFetched("conversationId");
        return this.conversationId;
    }

    public void _persistence_set_conversationId(Long l) {
        this._persistence_checkFetchedForSet("conversationId");
        this._persistence_propertyChange("conversationId", this.conversationId, l);
        this.conversationId = l;
    }

    public String _persistence_get_body() {
        this._persistence_checkFetched("body");
        return this.body;
    }

    public void _persistence_set_body(String string) {
        this._persistence_checkFetchedForSet("body");
        this._persistence_propertyChange("body", this.body, string);
        this.body = string;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public MessageOwner _persistence_get_messageOwner() {
        this._persistence_checkFetched("messageOwner");
        return this.messageOwner;
    }

    public void _persistence_set_messageOwner(MessageOwner messageOwner) {
        this._persistence_checkFetchedForSet("messageOwner");
        this._persistence_propertyChange("messageOwner", this.messageOwner, messageOwner);
        this.messageOwner = messageOwner;
    }

    public Date _persistence_get_removedAt() {
        this._persistence_checkFetched("removedAt");
        return this.removedAt;
    }

    public void _persistence_set_removedAt(Date date) {
        this._persistence_checkFetchedForSet("removedAt");
        this._persistence_propertyChange("removedAt", this.removedAt, date);
        this.removedAt = date;
    }

    protected void _persistence_initialize_category_vh() {
        if (this._persistence_category_vh == null) {
            this._persistence_category_vh = new ValueHolder((Object)this.category);
            this._persistence_category_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_category_vh() {
        MessageCategory messageCategory;
        this._persistence_initialize_category_vh();
        if ((this._persistence_category_vh.isCoordinatedWithProperty() || this._persistence_category_vh.isNewlyWeavedValueHolder()) && (messageCategory = this._persistence_get_category()) != this._persistence_category_vh.getValue()) {
            this._persistence_set_category(messageCategory);
        }
        return this._persistence_category_vh;
    }

    public void _persistence_set_category_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_category_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            MessageCategory messageCategory = this._persistence_get_category();
            if (messageCategory != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_category((MessageCategory)object);
            }
        } else {
            this.category = null;
        }
    }

    public MessageCategory _persistence_get_category() {
        this._persistence_checkFetched("category");
        this._persistence_initialize_category_vh();
        this.category = (MessageCategory)this._persistence_category_vh.getValue();
        return this.category;
    }

    public void _persistence_set_category(MessageCategory messageCategory) {
        this._persistence_checkFetchedForSet("category");
        this._persistence_initialize_category_vh();
        this.category = (MessageCategory)this._persistence_category_vh.getValue();
        this._persistence_propertyChange("category", this.category, messageCategory);
        this.category = messageCategory;
        this._persistence_category_vh.setValue((Object)messageCategory);
    }
}

